/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.organiser;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.io.JPanelCSVOptions;
import jsbugs.organiser.PanelColumnSelection;
import jsbugs.table.CellWarningRenderer;
import jsbugs.table.HighlightingTable;
import jsbugs.table.ObjectValidatorInSet;
import jsbugs.table.ObjectValidatorIsNumber;
import jsbugs.table.SimpleTableModel;
import jsbugs.table.TableRowHeader;
import jsbugs.uiutil.ComboboxItem;
import jsbugs.util.ColourGenerator;
import model3.EnvScheme;
import model3.SBdb;
import model3.Well;
import model3.organiser.PaleoImporSampletRecord;
import model3.organiser.PaleoImportRecord;
import model3.organiser.PaleoRangeImportRecord;
import org.apache.commons.lang3.StringUtils;
import util.DepthParseException;
import util.DepthUtils;
import util.FilePathUtils;
import util.NumberFormatUtils;
import util.SB;
import util.exception.StackError;
import util.gridreader.GridReaderException;
import util.gridreader.TableData;
import util.gridreader.TableReader;
import util.gridreader.TableRow;

public class DialogPaleoImport
extends SBDialog {
    private static final String SAMPLE_CARD_NAME = "SAMPLE";
    private static final String RANGE_CARD_NAME = "RANGE";
    private static Logger log = Logger.getLogger(DialogPaleoImport.class.getName());
    private TableData data = null;
    private final SBdb db;
    private NumberFormat numberFormat;
    private ImportFormat selectedFormat = ImportFormat.SamplePerLine;
    private ButtonGroup buttonGroupFileFormat;
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JButton jButtonSelectFile;
    private JCheckBox jCheckBoxUseFirstRowAsHeaders;
    private JComboBox<String> jComboBox8;
    private JComboBox<String> jComboBoxPaleoEnvironment;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel8;
    private JPanel jPanel3;
    private JPanel jPanelButtons;
    private JPanel jPanelCSVOptions;
    private JPanelCSVOptions jPanelCSVOptions1;
    private JPanel jPanelColumnSelections;
    private JPanel jPanelFileSelection;
    private JPanel jPanelFormat;
    private JPanel jPanelOptions;
    private JPanel jPanelRangeColumns;
    private JPanel jPanelSampleColumns;
    private JPanel jPanelTable;
    private JPanel jPanelTopSelection;
    private JPanel jPanelUnits;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonRangeFormat;
    private JRadioButton jRadioButtonSampleFormat;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinner1;
    private JTable jTableImportData;
    private JTextField jTextFieldFilePath;
    private PanelColumnSelection panelColumnSelectionLowerPaleoenvironment;
    private PanelColumnSelection panelColumnSelectionPaleoenvironment;
    private PanelColumnSelection panelColumnSelectionRangeBase;
    private PanelColumnSelection panelColumnSelectionRangePaleoenvironment;
    private PanelColumnSelection panelColumnSelectionRangeTop;
    private PanelColumnSelection panelColumnSelectionRangeWellCode;
    private PanelColumnSelection panelColumnSelectionRangeWellName;
    private PanelColumnSelection panelColumnSelectionSampleBaseDepth;
    private PanelColumnSelection panelColumnSelectionSampleLabel;
    private PanelColumnSelection panelColumnSelectionSampleTopDepth;
    private PanelColumnSelection panelColumnSelectionSampleType;
    private PanelColumnSelection panelColumnSelectionWellCode;
    private PanelColumnSelection panelColumnSelectionWellName;

    public DialogPaleoImport(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.initComponents();
        this.jSpinner1.setModel(new SpinnerNumberModel(1, 1, 999, 1));
        this.db = db;
        Color[] colours = ColourGenerator.generateColours(8);
        this.panelColumnSelectionWellCode.setColour(colours[0]);
        this.panelColumnSelectionWellName.setColour(colours[1]);
        this.panelColumnSelectionSampleTopDepth.setColour(colours[2]);
        this.panelColumnSelectionSampleBaseDepth.setColour(colours[3]);
        this.panelColumnSelectionSampleLabel.setColour(colours[4]);
        this.panelColumnSelectionSampleType.setColour(colours[5]);
        this.panelColumnSelectionPaleoenvironment.setColour(colours[6]);
        this.panelColumnSelectionRangeWellCode.setColour(colours[0]);
        this.panelColumnSelectionRangeWellName.setColour(colours[1]);
        this.panelColumnSelectionRangeTop.setColour(colours[2]);
        this.panelColumnSelectionRangeBase.setColour(colours[3]);
        this.panelColumnSelectionRangePaleoenvironment.setColour(colours[6]);
        this.panelColumnSelectionLowerPaleoenvironment.setColour(colours[7]);
        CardLayout cl = (CardLayout)this.jPanelColumnSelections.getLayout();
        cl.show(this.jPanelColumnSelections, SAMPLE_CARD_NAME);
        this.updateNumberFormat();
        for (PanelColumnSelection p : this.getSelectionPanels()) {
            p.getOptionsBox().addActionListener(new ActionListener(this){
                final /* synthetic */ DialogPaleoImport this$0;
                {
                    DialogPaleoImport dialogPaleoImport = this$0;
                    Objects.requireNonNull(dialogPaleoImport);
                    this.this$0 = dialogPaleoImport;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.this$0.columnSelectionChanged(e);
                }
            });
        }
        this.jSpinner1.addChangeListener(new ChangeListener(this){
            final /* synthetic */ DialogPaleoImport this$0;
            {
                DialogPaleoImport dialogPaleoImport = this$0;
                Objects.requireNonNull(dialogPaleoImport);
                this.this$0 = dialogPaleoImport;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.this$0.updateTableHighlighting();
                this.this$0.updateColumnRenderers();
            }
        });
        this.jPanelCSVOptions1.addPropertyChangeListener(new PropertyChangeListener(this){
            final /* synthetic */ DialogPaleoImport this$0;
            {
                DialogPaleoImport dialogPaleoImport = this$0;
                Objects.requireNonNull(dialogPaleoImport);
                this.this$0 = dialogPaleoImport;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("delimiter")) {
                    this.this$0.reloadCurrentFile();
                } else if (evt.getPropertyName().equals("separator")) {
                    this.this$0.updateNumberFormat();
                }
            }
        });
        SB.setTableHeaderBold((JTable)this.jTableImportData);
        TableRowHeader.addTableRowHeader(this.jScrollPane1, this.jTableImportData);
        if (this.db != null) {
            try {
                ArrayList<ComboboxItem<EnvScheme>> items = new ArrayList<ComboboxItem<EnvScheme>>();
                for (EnvScheme e : db.getEnvSchemes()) {
                    items.add(new ComboboxItem<EnvScheme>(e, e.getName()));
                }
                this.jComboBoxPaleoEnvironment.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
            }
            catch (SQLException ex) {
                Logger.getLogger(DialogPaleoImport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void loadFile(File importFile) throws IOException, FileNotFoundException, GridReaderException {
        SimpleTableModel model;
        this.clearColumnSelection();
        TableReader reader = new TableReader();
        reader.setDelimiter(this.jPanelCSVOptions1.getColumnDelimiter());
        if (this.jCheckBoxUseFirstRowAsHeaders.isSelected()) {
            this.data = reader.readTableData(importFile);
            String[] headings = this.data.getHeaders().toArray(new String[this.data.getHeaders().size()]);
            model = new SimpleTableModel(this.data.toObjectArray(), headings);
        } else {
            this.data = reader.readTableDataWithoutHeaders(importFile);
            model = new SimpleTableModel(this.data.toObjectArray());
        }
        this.data.setNumberFormat(this.numberFormat);
        this.jTableImportData.setModel(model);
        this.jTextFieldFilePath.setText(importFile.getPath());
        List<String> columnNames = this.buildColumnNames(this.data, model);
        for (PanelColumnSelection p : this.getSelectionPanels()) {
            p.setSelectionOptions(columnNames);
        }
        this.jPanelCSVOptions1.setEnabled(!FilePathUtils.isFileExtension((String)importFile.getPath(), (String[])new String[]{"xls", "xlsx"}));
        this.jScrollPane1.repaint();
        this.jScrollPane1.getRowHeader().invalidate();
    }

    private void clearColumnSelection() {
        for (PanelColumnSelection p : this.getSelectionPanels()) {
            p.clearSelection();
        }
    }

    public char getUnits() {
        return this.jRadioButtonFeet.isSelected() ? (char)'F' : 'M';
    }

    public List<PaleoImporSampletRecord> buildSampleImportRecords() {
        if (this.data == null) {
            return null;
        }
        assert (this.selectedFormat() == ImportFormat.SamplePerLine);
        Set paleoTermSet = this.buildTermSet(this.getSelectedPaleoScheme());
        ArrayList<PaleoImporSampletRecord> importRecords = new ArrayList<PaleoImporSampletRecord>();
        char units = this.jRadioButtonFeet.isSelected() ? (char)'F' : 'M';
        for (int rowIndex = this.startAtRowIndex(); rowIndex < this.data.getRows().size(); ++rowIndex) {
            String paleoLabel;
            TableRow dataRow = (TableRow)this.data.getRows().get(rowIndex);
            Double topDepth = this.getDepthValue(this.panelColumnSelectionSampleTopDepth, dataRow, units);
            Double baseDepth = this.getDepthValue(this.panelColumnSelectionSampleBaseDepth, dataRow, units);
            if (topDepth == null && baseDepth == null) continue;
            String label = this.getColumnStringFromRow(this.panelColumnSelectionSampleLabel, dataRow);
            String sampleTypeString = this.getColumnStringFromRow(this.panelColumnSelectionSampleType, dataRow);
            SampleType type = null;
            if (!StringUtils.isEmpty((CharSequence)sampleTypeString)) {
                type = SampleType.parseType((String)sampleTypeString);
            }
            if (type == null) {
                type = SampleType.CU;
            }
            if ((paleoLabel = this.getColumnStringFromRow(this.panelColumnSelectionPaleoenvironment, dataRow)) == null || !paleoTermSet.contains(paleoLabel.toLowerCase())) continue;
            String wellName = this.getColumnStringFromRow(this.panelColumnSelectionWellName, dataRow);
            String wellCode = this.getColumnStringFromRow(this.panelColumnSelectionWellCode, dataRow);
            if (StringUtils.isBlank((CharSequence)wellCode) && !StringUtils.isBlank((CharSequence)wellName)) {
                wellCode = Well.makeCode(wellName);
            } else if (StringUtils.isBlank((CharSequence)wellName) && !StringUtils.isBlank((CharSequence)wellCode)) {
                wellName = wellCode;
            } else if (StringUtils.isBlank((CharSequence)wellName) && StringUtils.isBlank((CharSequence)wellCode)) {
                wellName = this.generateWellNameFromFilename();
                wellCode = Well.makeCode(wellName);
            }
            if (topDepth != null && baseDepth != null && baseDepth < topDepth) {
                Double temp = baseDepth;
                baseDepth = topDepth;
                topDepth = temp;
            }
            PaleoImporSampletRecord record = new PaleoImporSampletRecord(topDepth, baseDepth, label, type, paleoLabel, wellName, wellCode);
            importRecords.add(record);
        }
        return importRecords;
    }

    private DepthType getDepthTypeValue(PanelColumnSelection selection, TableRow dataRow, char units, String defaultType) {
        DepthType depthType = null;
        if (selection.isSelected()) {
            int colIndex = selection.getOptionsBox().getSelectedIndex() - 1;
            try {
                if (!StringUtils.isEmpty((CharSequence)dataRow.get(colIndex))) {
                    depthType = new DepthType(this);
                    depthType.type = defaultType;
                    String text = dataRow.get(colIndex);
                    if (!(text = text.trim()).matches("[0-9.]")) {
                        Pattern p = Pattern.compile("[a-zA-Z]+");
                        Matcher m = p.matcher(text);
                        while (m.find()) {
                            String sType = m.group();
                            SampleType sampleType = SampleType.parseType((String)sType);
                            if (sampleType == null) continue;
                            depthType.type = sampleType.toString();
                            break;
                        }
                        if (text.indexOf(32) > 0) {
                            text = text.substring(0, text.indexOf(32));
                        }
                    }
                    depthType.depth = DepthUtils.parseDepthString((String)text, (char)units);
                }
            }
            catch (DepthParseException ex) {
                depthType = null;
                log.log(Level.WARNING, null, ex);
            }
        }
        return depthType;
    }

    private Double getDepthValue(PanelColumnSelection selection, TableRow dataRow, char units) {
        Double depth = null;
        if (selection.isSelected()) {
            int colIndex = selection.getOptionsBox().getSelectedIndex() - 1;
            try {
                if (!StringUtils.isEmpty((CharSequence)dataRow.get(colIndex))) {
                    depth = DepthUtils.parseDepthString((String)dataRow.get(colIndex), (char)units);
                }
            }
            catch (DepthParseException ex) {
                log.log(Level.WARNING, null, ex);
            }
        }
        return depth;
    }

    public List<PaleoRangeImportRecord> buildRangeImportRecords() {
        if (this.data == null || !this.jRadioButtonRangeFormat.isSelected()) {
            return null;
        }
        assert (this.selectedFormat() == ImportFormat.RangePerLine);
        Set paleoTermSet = this.buildTermSet(this.getSelectedPaleoScheme());
        ArrayList<PaleoRangeImportRecord> importRecords = new ArrayList<PaleoRangeImportRecord>();
        char units = this.jRadioButtonFeet.isSelected() ? (char)'F' : 'M';
        for (int rowIndex = this.startAtRowIndex(); rowIndex < this.data.getRows().size(); ++rowIndex) {
            String paleoLabelLower;
            String paleoLabel;
            TableRow dataRow = (TableRow)this.data.getRows().get(rowIndex);
            DepthType top = this.getDepthTypeValue(this.panelColumnSelectionRangeTop, dataRow, units, "CU");
            DepthType base = this.getDepthTypeValue(this.panelColumnSelectionRangeBase, dataRow, units, "CU");
            if (top == null || base == null) continue;
            if (base.depth < top.depth) {
                Double temp = base.depth;
                String tt = base.type;
                base.depth = top.depth;
                base.type = top.type;
                top.depth = temp;
                top.type = tt;
            }
            if ((paleoLabel = this.getColumnStringFromRow(this.panelColumnSelectionRangePaleoenvironment, dataRow)) == null || !paleoTermSet.contains(paleoLabel.toLowerCase()) || (paleoLabelLower = this.getColumnStringFromRow(this.panelColumnSelectionLowerPaleoenvironment, dataRow)) != null && !paleoTermSet.contains(paleoLabelLower.toLowerCase())) continue;
            String wellName = this.getColumnStringFromRow(this.panelColumnSelectionRangeWellName, dataRow);
            String wellCode = this.getColumnStringFromRow(this.panelColumnSelectionRangeWellCode, dataRow);
            if (StringUtils.isBlank((CharSequence)wellCode) && !StringUtils.isBlank((CharSequence)wellName)) {
                wellCode = Well.makeCode(wellName);
            } else if (StringUtils.isBlank((CharSequence)wellName) && !StringUtils.isBlank((CharSequence)wellCode)) {
                wellName = wellCode;
            } else if (StringUtils.isBlank((CharSequence)wellName) && StringUtils.isBlank((CharSequence)wellCode)) {
                wellName = this.generateWellNameFromFilename();
                wellCode = Well.makeCode(wellName);
            }
            PaleoRangeImportRecord record = new PaleoRangeImportRecord((double)top.depth, top.type, (double)base.depth, base.type, paleoLabel, paleoLabelLower, wellName, wellCode);
            importRecords.add(record);
        }
        return importRecords;
    }

    private String getColumnStringFromRow(PanelColumnSelection selection, TableRow row) {
        String value = null;
        if (selection.isSelected()) {
            int colIndex = selection.getOptionsBox().getSelectedIndex() - 1;
            value = row.get(colIndex);
        }
        return value;
    }

    public EnvScheme getSelectedPaleoScheme() {
        Object item = this.jComboBoxPaleoEnvironment.getSelectedItem();
        if (item == null || !(item instanceof ComboboxItem)) {
            return null;
        }
        Object value = ((ComboboxItem)item).getValue();
        if (!(value instanceof EnvScheme)) {
            return null;
        }
        return (EnvScheme)value;
    }

    private String generateWellNameFromFilename() {
        if (StringUtils.isBlank((CharSequence)this.jTextFieldFilePath.getText())) {
            return "Imported Well";
        }
        return FilePathUtils.extractFileNameWithoutExtension((String)this.jTextFieldFilePath.getText());
    }

    private List<String> buildColumnNames(TableData data, SimpleTableModel model) {
        ArrayList<String> columnNames = new ArrayList<String>();
        if (data.getHeaders() == null) {
            for (int i = 0; i < model.getColumnCount(); ++i) {
                columnNames.add("Column " + Integer.toString(i + 1));
            }
        } else {
            for (int i = 0; i < model.getColumnCount(); ++i) {
                Object header = null;
                if (i < data.getHeaders().size()) {
                    header = (String)data.getHeaders().get(i);
                }
                if (StringUtils.isBlank(header)) {
                    header = "Column " + Integer.toString(i + 1);
                }
                columnNames.add((String)header);
            }
        }
        return columnNames;
    }

    private void columnSelectionChanged(ActionEvent e) {
        JComboBox source = (JComboBox)e.getSource();
        int selectedIndex = source.getSelectedIndex();
        if (selectedIndex > 0) {
            for (PanelColumnSelection p : this.getSelectionPanels()) {
                if (p.getOptionsBox() == source || p.getOptionsBox().getSelectedIndex() != selectedIndex) continue;
                p.getOptionsBox().setSelectedIndex(0);
            }
        }
        this.updateColumnRenderers();
        this.updateTableHighlighting();
    }

    private Iterable<PanelColumnSelection> getSelectionPanels() {
        ArrayList<PanelColumnSelection> panels = new ArrayList<PanelColumnSelection>();
        for (Component c : this.jPanelSampleColumns.getComponents()) {
            if (!(c instanceof PanelColumnSelection)) continue;
            panels.add((PanelColumnSelection)c);
        }
        for (Component c : this.jPanelRangeColumns.getComponents()) {
            if (!(c instanceof PanelColumnSelection)) continue;
            panels.add((PanelColumnSelection)c);
        }
        return panels;
    }

    private void showValidationWarning(String message) {
        JOptionPane.showMessageDialog((Component)((Object)this), message, "Paleoenvironment Import", 2);
    }

    private void updateNumberFormat() {
        this.numberFormat = NumberFormatUtils.buildNumberFormatWithSeparator((char)this.jPanelCSVOptions1.getDecimalSeparator());
        if (this.data != null) {
            this.data.setNumberFormat(this.numberFormat);
        }
        this.updateColumnRenderers();
    }

    private void initComponents() {
        this.jComboBox8 = new JComboBox();
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupFileFormat = new ButtonGroup();
        this.jPanelFileSelection = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldFilePath = new JTextField();
        this.jButtonSelectFile = new JButton();
        this.jPanelButtons = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanelOptions = new JPanel();
        this.jPanelFormat = new JPanel();
        this.jRadioButtonSampleFormat = new JRadioButton();
        this.jRadioButtonRangeFormat = new JRadioButton();
        this.jPanelTopSelection = new JPanel();
        this.jCheckBoxUseFirstRowAsHeaders = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jComboBoxPaleoEnvironment = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jPanelColumnSelections = new JPanel();
        this.jPanelRangeColumns = new JPanel();
        this.panelColumnSelectionRangeWellCode = new PanelColumnSelection();
        this.panelColumnSelectionRangeWellName = new PanelColumnSelection();
        this.panelColumnSelectionRangeTop = new PanelColumnSelection();
        this.panelColumnSelectionRangeBase = new PanelColumnSelection();
        this.panelColumnSelectionRangePaleoenvironment = new PanelColumnSelection();
        this.panelColumnSelectionLowerPaleoenvironment = new PanelColumnSelection();
        this.jPanel3 = new JPanel();
        this.jPanelSampleColumns = new JPanel();
        this.panelColumnSelectionWellCode = new PanelColumnSelection();
        this.panelColumnSelectionWellName = new PanelColumnSelection();
        this.panelColumnSelectionSampleTopDepth = new PanelColumnSelection();
        this.panelColumnSelectionSampleBaseDepth = new PanelColumnSelection();
        this.panelColumnSelectionSampleType = new PanelColumnSelection();
        this.panelColumnSelectionSampleLabel = new PanelColumnSelection();
        this.panelColumnSelectionPaleoenvironment = new PanelColumnSelection();
        this.jPanelCSVOptions = new JPanel();
        this.jPanelCSVOptions1 = new JPanelCSVOptions();
        this.jPanelUnits = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jPanelTable = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableImportData = new HighlightingTable();
        this.jComboBox8.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.setDefaultCloseOperation(2);
        this.setTitle("Paleoenvironment Import");
        this.jPanelFileSelection.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.jPanelFileSelection.setLayout(new BorderLayout(4, 0));
        this.jLabel1.setText("File :");
        this.jPanelFileSelection.add((Component)this.jLabel1, "Before");
        this.jTextFieldFilePath.setEditable(false);
        this.jTextFieldFilePath.setBackground(new Color(255, 255, 204));
        this.jPanelFileSelection.add((Component)this.jTextFieldFilePath, "Center");
        this.jButtonSelectFile.setText("...");
        this.jButtonSelectFile.setMaximumSize(new Dimension(30, 23));
        this.jButtonSelectFile.setMinimumSize(new Dimension(30, 23));
        this.jButtonSelectFile.setPreferredSize(new Dimension(30, 23));
        this.jButtonSelectFile.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPaleoImport this$0;
            {
                DialogPaleoImport dialogPaleoImport = this$0;
                Objects.requireNonNull(dialogPaleoImport);
                this.this$0 = dialogPaleoImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectFileActionPerformed(evt);
            }
        });
        this.jPanelFileSelection.add((Component)this.jButtonSelectFile, "After");
        this.getContentPane().add((Component)this.jPanelFileSelection, "First");
        this.jPanelButtons.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5));
        this.jPanelButtons.setLayout(new FlowLayout(2, 5, 0));
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPaleoImport this$0;
            {
                DialogPaleoImport dialogPaleoImport = this$0;
                Objects.requireNonNull(dialogPaleoImport);
                this.this$0 = dialogPaleoImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOkActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonOk);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPaleoImport this$0;
            {
                DialogPaleoImport dialogPaleoImport = this$0;
                Objects.requireNonNull(dialogPaleoImport);
                this.this$0 = dialogPaleoImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanelButtons, "Last");
        this.jPanelOptions.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 10));
        this.jPanelFormat.setBorder(BorderFactory.createTitledBorder(null, "Format", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanelFormat.setMaximumSize(new Dimension(240, 300));
        this.jPanelFormat.setPreferredSize(new Dimension(240, 69));
        this.jPanelFormat.setLayout(new BoxLayout(this.jPanelFormat, 3));
        this.buttonGroupFileFormat.add(this.jRadioButtonSampleFormat);
        this.jRadioButtonSampleFormat.setSelected(true);
        this.jRadioButtonSampleFormat.setText("One line per sample");
        this.jRadioButtonSampleFormat.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPaleoImport this$0;
            {
                DialogPaleoImport dialogPaleoImport = this$0;
                Objects.requireNonNull(dialogPaleoImport);
                this.this$0 = dialogPaleoImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonSampleFormatActionPerformed(evt);
            }
        });
        this.jPanelFormat.add(this.jRadioButtonSampleFormat);
        this.buttonGroupFileFormat.add(this.jRadioButtonRangeFormat);
        this.jRadioButtonRangeFormat.setText("One line per Paleoenvironment Range");
        this.jRadioButtonRangeFormat.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPaleoImport this$0;
            {
                DialogPaleoImport dialogPaleoImport = this$0;
                Objects.requireNonNull(dialogPaleoImport);
                this.this$0 = dialogPaleoImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonRangeFormatActionPerformed(evt);
            }
        });
        this.jPanelFormat.add(this.jRadioButtonRangeFormat);
        this.jPanelOptions.add(this.jPanelFormat);
        this.jPanelTopSelection.setBorder(BorderFactory.createTitledBorder(null, "Settings", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanelTopSelection.setMaximumSize(new Dimension(240, 300));
        this.jPanelTopSelection.setPreferredSize(new Dimension(240, 140));
        this.jPanelTopSelection.setRequestFocusEnabled(false);
        this.jCheckBoxUseFirstRowAsHeaders.setText("Use first row as column headings");
        this.jCheckBoxUseFirstRowAsHeaders.setHorizontalTextPosition(10);
        this.jCheckBoxUseFirstRowAsHeaders.setMargin(new Insets(2, 0, 2, 2));
        this.jCheckBoxUseFirstRowAsHeaders.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPaleoImport this$0;
            {
                DialogPaleoImport dialogPaleoImport = this$0;
                Objects.requireNonNull(dialogPaleoImport);
                this.this$0 = dialogPaleoImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxUseFirstRowAsHeadersActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Data starts at row");
        this.jComboBoxPaleoEnvironment.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPaleoImport this$0;
            {
                DialogPaleoImport dialogPaleoImport = this$0;
                Objects.requireNonNull(dialogPaleoImport);
                this.this$0 = dialogPaleoImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxPaleoEnvironmentActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Paleoenvironment Scheme");
        GroupLayout jPanelTopSelectionLayout = new GroupLayout(this.jPanelTopSelection);
        this.jPanelTopSelection.setLayout(jPanelTopSelectionLayout);
        jPanelTopSelectionLayout.setHorizontalGroup(jPanelTopSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopSelectionLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanelTopSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxPaleoEnvironment, 0, -1, Short.MAX_VALUE).addGroup(jPanelTopSelectionLayout.createSequentialGroup().addGroup(jPanelTopSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addGroup(jPanelTopSelectionLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSpinner1, -2, -1, -2)).addComponent(this.jCheckBoxUseFirstRowAsHeaders)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelTopSelectionLayout.setVerticalGroup(jPanelTopSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopSelectionLayout.createSequentialGroup().addComponent(this.jCheckBoxUseFirstRowAsHeaders).addGap(5, 5, 5).addGroup(jPanelTopSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jSpinner1, -2, -1, -2)).addGap(5, 5, 5).addComponent(this.jLabel8).addGap(5, 5, 5).addComponent(this.jComboBoxPaleoEnvironment, -2, -1, -2).addContainerGap(25, Short.MAX_VALUE)));
        this.jPanelOptions.add(this.jPanelTopSelection);
        this.jPanelColumnSelections.setBorder(BorderFactory.createTitledBorder(null, "Column Selection", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanelColumnSelections.setMaximumSize(new Dimension(240, 300));
        this.jPanelColumnSelections.setPreferredSize(new Dimension(240, 205));
        this.jPanelColumnSelections.setLayout(new CardLayout());
        this.jPanelRangeColumns.setLayout(new BoxLayout(this.jPanelRangeColumns, 1));
        this.panelColumnSelectionRangeWellCode.setDescription("Well Code");
        this.jPanelRangeColumns.add(this.panelColumnSelectionRangeWellCode);
        this.panelColumnSelectionRangeWellName.setDescription("Well Name");
        this.panelColumnSelectionRangeWellName.setDoubleBuffered(false);
        this.jPanelRangeColumns.add(this.panelColumnSelectionRangeWellName);
        this.panelColumnSelectionRangeTop.setDescription("Range Top Depth");
        this.jPanelRangeColumns.add(this.panelColumnSelectionRangeTop);
        this.panelColumnSelectionRangeBase.setDescription("Range Base Depth");
        this.panelColumnSelectionRangeBase.setDoubleBuffered(false);
        this.jPanelRangeColumns.add(this.panelColumnSelectionRangeBase);
        this.panelColumnSelectionRangePaleoenvironment.setDescription("Paleoenvrionment");
        this.jPanelRangeColumns.add(this.panelColumnSelectionRangePaleoenvironment);
        this.panelColumnSelectionLowerPaleoenvironment.setDescription("(Lower Env)");
        this.jPanelRangeColumns.add(this.panelColumnSelectionLowerPaleoenvironment);
        this.jPanel3.setPreferredSize(new Dimension(119, 50));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 214, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 31, Short.MAX_VALUE));
        this.jPanelRangeColumns.add(this.jPanel3);
        this.jPanelColumnSelections.add((Component)this.jPanelRangeColumns, RANGE_CARD_NAME);
        this.jPanelSampleColumns.setLayout(new BoxLayout(this.jPanelSampleColumns, 1));
        this.panelColumnSelectionWellCode.setDescription("Well Code");
        this.jPanelSampleColumns.add(this.panelColumnSelectionWellCode);
        this.panelColumnSelectionWellName.setDescription("Well Name");
        this.panelColumnSelectionWellName.setDoubleBuffered(false);
        this.jPanelSampleColumns.add(this.panelColumnSelectionWellName);
        this.panelColumnSelectionSampleTopDepth.setDescription("Sample Top Depth");
        this.jPanelSampleColumns.add(this.panelColumnSelectionSampleTopDepth);
        this.panelColumnSelectionSampleBaseDepth.setDescription("Sample Base Depth");
        this.jPanelSampleColumns.add(this.panelColumnSelectionSampleBaseDepth);
        this.panelColumnSelectionSampleType.setDescription("Sample Type");
        this.jPanelSampleColumns.add(this.panelColumnSelectionSampleType);
        this.panelColumnSelectionSampleLabel.setDescription("Sample Label");
        this.panelColumnSelectionSampleLabel.setMaxComboboxSize(new Dimension(100, Short.MAX_VALUE));
        this.jPanelSampleColumns.add(this.panelColumnSelectionSampleLabel);
        this.panelColumnSelectionPaleoenvironment.setDescription("Paleoenvrionment");
        this.jPanelSampleColumns.add(this.panelColumnSelectionPaleoenvironment);
        this.jPanelColumnSelections.add((Component)this.jPanelSampleColumns, SAMPLE_CARD_NAME);
        this.jPanelOptions.add(this.jPanelColumnSelections);
        this.jPanelCSVOptions.setBorder(BorderFactory.createTitledBorder(null, "CSV Import Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanelCSVOptions.setMaximumSize(new Dimension(240, 300));
        this.jPanelCSVOptions.setPreferredSize(new Dimension(240, 100));
        GroupLayout jPanelCSVOptionsLayout = new GroupLayout(this.jPanelCSVOptions);
        this.jPanelCSVOptions.setLayout(jPanelCSVOptionsLayout);
        jPanelCSVOptionsLayout.setHorizontalGroup(jPanelCSVOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCSVOptionsLayout.createSequentialGroup().addComponent(this.jPanelCSVOptions1, -2, -1, -2).addGap(0, 14, Short.MAX_VALUE)));
        jPanelCSVOptionsLayout.setVerticalGroup(jPanelCSVOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCSVOptionsLayout.createSequentialGroup().addComponent(this.jPanelCSVOptions1, -2, -1, -2).addGap(0, 22, Short.MAX_VALUE)));
        this.jPanelOptions.add(this.jPanelCSVOptions);
        this.jPanelUnits.setBorder(BorderFactory.createTitledBorder(null, "Units", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanelUnits.setMaximumSize(new Dimension(240, 300));
        this.jPanelUnits.setOpaque(false);
        this.jPanelUnits.setPreferredSize(new Dimension(240, 60));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        GroupLayout jPanelUnitsLayout = new GroupLayout(this.jPanelUnits);
        this.jPanelUnits.setLayout(jPanelUnitsLayout);
        jPanelUnitsLayout.setHorizontalGroup(jPanelUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelUnitsLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonMetres).addGap(18, 18, 18).addComponent(this.jRadioButtonFeet).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelUnitsLayout.setVerticalGroup(jPanelUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelUnitsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelUnitsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonMetres).addComponent(this.jRadioButtonFeet)).addContainerGap(12, Short.MAX_VALUE)));
        GroupLayout jPanelOptionsLayout = new GroupLayout(this.jPanelOptions);
        this.jPanelOptions.setLayout(jPanelOptionsLayout);
        jPanelOptionsLayout.setHorizontalGroup(jPanelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsLayout.createSequentialGroup().addGroup(jPanelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanelTopSelection, -1, 226, Short.MAX_VALUE).addComponent(this.jPanelColumnSelections, -2, 0, Short.MAX_VALUE).addComponent(this.jPanelCSVOptions, -1, 226, Short.MAX_VALUE).addComponent(this.jPanelUnits, -1, 226, Short.MAX_VALUE).addComponent(this.jPanelFormat, -2, 0, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelOptionsLayout.setVerticalGroup(jPanelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsLayout.createSequentialGroup().addComponent(this.jPanelFormat, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanelTopSelection, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanelColumnSelections, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanelCSVOptions, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanelUnits, -2, 65, -2)));
        this.getContentPane().add((Component)this.jPanelOptions, "After");
        this.jPanelTable.setBorder(BorderFactory.createEmptyBorder(5, 10, 2, 0));
        this.jPanelTable.setLayout(new BorderLayout());
        this.jTableImportData.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTableImportData.setEnabled(false);
        this.jScrollPane1.setViewportView(this.jTableImportData);
        this.jPanelTable.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanelTable, "Center");
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        if (StringUtils.isBlank((CharSequence)this.jTextFieldFilePath.getText())) {
            this.showValidationWarning("No data file loaded.");
            return;
        }
        if (this.buttonGroupUnits.getSelection() == null) {
            this.showValidationWarning("No depth units selected.");
            return;
        }
        int recordCount = 0;
        if (this.selectedFormat() == ImportFormat.SamplePerLine) {
            if (!this.panelColumnSelectionPaleoenvironment.isSelected()) {
                this.showValidationWarning("Paleoenvironment column is not selected.");
                return;
            }
            if (!this.panelColumnSelectionSampleTopDepth.isSelected() && !this.panelColumnSelectionSampleBaseDepth.isSelected()) {
                this.showValidationWarning("No sample depth column selected.");
                return;
            }
            List<PaleoImporSampletRecord> records = this.buildSampleImportRecords();
            String warning = this.checkNameCodeCombinations(records);
            if (!warning.isEmpty()) {
                this.showValidationWarning(warning);
                return;
            }
            recordCount = records.size();
        } else {
            if (!this.panelColumnSelectionRangePaleoenvironment.isSelected()) {
                this.showValidationWarning("Paleoenvironment column is not selected.");
                return;
            }
            if (!this.panelColumnSelectionRangeBase.isSelected()) {
                this.showValidationWarning("No range base depth column selected.");
                return;
            }
            if (!this.panelColumnSelectionRangeTop.isSelected()) {
                this.showValidationWarning("No range top depth column selected.");
                return;
            }
            List<PaleoRangeImportRecord> records = this.buildRangeImportRecords();
            String warning = this.checkNameCodeCombinations(records);
            if (!warning.isEmpty()) {
                this.showValidationWarning(warning);
                return;
            }
            recordCount = records.size();
        }
        if (recordCount == 0) {
            this.showValidationWarning("No records could be built from current selection. Make sure at least one record has a valid depth and paleoenvironment label.");
            return;
        }
        this.setIsOK(true);
        this.setVisible(false);
    }

    private void jButtonSelectFileActionPerformed(ActionEvent evt) {
        File f;
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel or CSV file", "csv", "xls", "xlsx");
        File initialDirectory = null;
        if (!this.jTextFieldFilePath.getText().isEmpty()) {
            initialDirectory = new File(this.jTextFieldFilePath.getText());
        }
        if ((f = FileChooserUtils.chooseReadableFile((Component)((Object)this), (FileNameExtensionFilter)filter, initialDirectory)) != null) {
            try {
                this.loadFile(f);
            }
            catch (IOException | GridReaderException ex) {
                StackError.showStackError((String)("An error occurred while reading the file " + f.getName() + "."), (Throwable)ex);
            }
        }
    }

    private void jCheckBoxUseFirstRowAsHeadersActionPerformed(ActionEvent evt) {
        this.reloadCurrentFile();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setIsOK(false);
        this.setVisible(false);
    }

    private void jComboBoxPaleoEnvironmentActionPerformed(ActionEvent evt) {
        this.updateColumnRenderers();
    }

    private void jRadioButtonSampleFormatActionPerformed(ActionEvent evt) {
        this.formatSelectionChanged();
    }

    private void jRadioButtonRangeFormatActionPerformed(ActionEvent evt) {
        this.formatSelectionChanged();
    }

    public ImportFormat selectedFormat() {
        if (this.jRadioButtonSampleFormat.isSelected()) {
            return ImportFormat.SamplePerLine;
        }
        return this.selectedFormat;
    }

    private void formatSelectionChanged() {
        CardLayout cl = (CardLayout)this.jPanelColumnSelections.getLayout();
        if (this.jRadioButtonSampleFormat.isSelected() && this.selectedFormat != ImportFormat.SamplePerLine) {
            cl.show(this.jPanelColumnSelections, SAMPLE_CARD_NAME);
            this.selectedFormat = ImportFormat.SamplePerLine;
            this.clearColumnSelection();
            this.updateColumnRenderers();
        } else if (this.jRadioButtonRangeFormat.isSelected() && this.selectedFormat != ImportFormat.RangePerLine) {
            cl.show(this.jPanelColumnSelections, RANGE_CARD_NAME);
            this.selectedFormat = ImportFormat.RangePerLine;
            this.clearColumnSelection();
            this.updateColumnRenderers();
        }
    }

    private void reloadCurrentFile() {
        File f = this.getCurrentSelectedFile();
        if (f != null) {
            try {
                this.loadFile(f);
            }
            catch (IOException | GridReaderException ex) {
                StackError.showStackError((String)("An error occurred while reading the file " + f.getName() + "."), (Throwable)ex);
            }
        }
    }

    public File getCurrentSelectedFile() {
        String path = this.jTextFieldFilePath.getText();
        if (!StringUtils.isBlank((CharSequence)path)) {
            return new File(path);
        }
        return null;
    }

    private void updateTableHighlighting() {
        HighlightingTable t = (HighlightingTable)this.jTableImportData;
        TableModel tableModel = t.getModel();
        t.clearHighlights();
        for (PanelColumnSelection panel : this.getSelectionPanels()) {
            if (!panel.isSelected() || panel.getOptionsBox().getSelectedIndex() == 0) continue;
            int column = panel.getOptionsBox().getSelectedIndex() - 1;
            for (int i = this.startAtRowIndex(); i < tableModel.getRowCount(); ++i) {
                t.addHighlight(new HighlightingTable.CellPosition(column, i), panel.getColour());
            }
        }
        t.repaint();
    }

    private void updateColumnRenderers() {
        TableColumnModel colModel = this.jTableImportData.getColumnModel();
        for (TableColumn column : Collections.list(colModel.getColumns())) {
            column.setCellRenderer(new DefaultTableCellRenderer());
        }
        this.setNumberValidator(colModel, this.panelColumnSelectionSampleBaseDepth);
        this.setNumberValidator(colModel, this.panelColumnSelectionSampleTopDepth);
        this.setNumberValidator(colModel, this.panelColumnSelectionRangeTop);
        this.setNumberValidator(colModel, this.panelColumnSelectionRangeBase);
        this.setPaleoValidator(colModel, this.panelColumnSelectionPaleoenvironment);
        this.setPaleoValidator(colModel, this.panelColumnSelectionRangePaleoenvironment);
        this.setPaleoValidator(colModel, this.panelColumnSelectionLowerPaleoenvironment);
        this.setSampleTypeValidator(colModel, this.panelColumnSelectionSampleType);
        this.jTableImportData.repaint();
    }

    private void setNumberValidator(TableColumnModel colModel, PanelColumnSelection columnSelection) {
        if (columnSelection.isSelected()) {
            CellWarningRenderer renderer = new CellWarningRenderer(new ObjectValidatorIsNumber(this.numberFormat));
            renderer.setStartingRow(this.startAtRowIndex());
            colModel.getColumn(columnSelection.getSelectedColumn()).setCellRenderer(renderer);
        }
    }

    private void setPaleoValidator(TableColumnModel colModel, PanelColumnSelection columnSelection) {
        if (columnSelection.isSelected()) {
            ObjectValidatorInSet validator = new ObjectValidatorInSet(this.buildTermSet(this.getSelectedPaleoScheme()), true);
            validator.setErrorMessage("Not a term in the selected scheme.");
            CellWarningRenderer renderer = new CellWarningRenderer(validator);
            renderer.setStartingRow(this.startAtRowIndex());
            colModel.getColumn(columnSelection.getSelectedColumn()).setCellRenderer(renderer);
        }
    }

    private void setSampleTypeValidator(TableColumnModel colModel, PanelColumnSelection columnSelection) {
        if (columnSelection.isSelected()) {
            HashSet<String> types = new HashSet<String>();
            for (SampleType t : SampleType.values()) {
                types.add(t.name());
            }
            ObjectValidatorInSet validator = new ObjectValidatorInSet(types, true);
            validator.setErrorMessage("Not a recognised sample type.");
            CellWarningRenderer renderer = new CellWarningRenderer(validator);
            renderer.setStartingRow(this.startAtRowIndex());
            colModel.getColumn(columnSelection.getSelectedColumn()).setCellRenderer(renderer);
        }
    }

    private Set buildTermSet(EnvScheme scheme) {
        HashSet<String> s = new HashSet<String>();
        for (int i = 1; i <= scheme.getNClasses(); ++i) {
            s.add(scheme.getTerm(i).toLowerCase());
        }
        return s;
    }

    private int startAtRowIndex() {
        return (Integer)this.jSpinner1.getValue() - 1;
    }

    private <T extends PaleoImportRecord> String checkNameCodeCombinations(List<T> records) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (PaleoImportRecord record : records) {
            if (!map.containsKey(record.getWellCode())) {
                map.put(record.getWellCode(), record.getWellName());
                continue;
            }
            if (((String)map.get(record.getWellCode())).equals(record.getWellName())) continue;
            return String.format("Multiple well names found for well code %s, %s and %s. Each well code must correspond to a single well name.", record.getWellCode(), map.get(record.getWellCode()), record.getWellName());
        }
        return "";
    }

    public static enum ImportFormat {
        SamplePerLine,
        RangePerLine;

    }

    private class DepthType {
        Double depth;
        String type;

        private DepthType(DialogPaleoImport dialogPaleoImport) {
            Objects.requireNonNull(dialogPaleoImport);
        }
    }
}

