/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.overlay;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import jsbugs.overlay.Line;

public class GridLayoutHelper {
    private final Dimension size;
    private final int columns;
    private final int rows;
    private final int gridlineWidth;
    private final Dimension baseCellSize;
    private final int remainingHorizontalPixels;
    private final int remainingVerticalPixels;

    public GridLayoutHelper(Dimension size, int rows, int columns, int gridlineWidth) {
        this.size = size;
        this.columns = columns;
        this.rows = rows;
        this.gridlineWidth = gridlineWidth;
        this.baseCellSize = this.baseCellSize(gridlineWidth);
        this.remainingHorizontalPixels = size.width - gridlineWidth * (columns + 1) - this.baseCellSize.width * columns;
        this.remainingVerticalPixels = size.height - gridlineWidth * (rows + 1) - this.baseCellSize.height * rows;
    }

    public Dimension getBaseCellSize() {
        return this.baseCellSize;
    }

    public Line[] getGridlines() {
        Line[] lines = new Line[this.rows + this.columns + 2];
        for (int row = 0; row <= this.rows; ++row) {
            lines[row] = this.getHorizontalGridline(row);
        }
        for (int column = 0; column <= this.columns; ++column) {
            lines[this.rows + 1 + column] = this.getVerticalGridline(column);
        }
        return lines;
    }

    public Line[] getHorizontalGridlines() {
        Line[] lines = new Line[this.rows + 1];
        for (int row = 0; row <= this.rows; ++row) {
            lines[row] = this.getHorizontalGridline(row);
        }
        return lines;
    }

    public Line getHorizontalGridline(int row) {
        return this.getHorizontalGridline(row, this.gridlineWidth);
    }

    public Line getHorizontalGridline(int row, int lineWidth) {
        int y = 0;
        int cellHeightBefore = this.baseCellSize((int)lineWidth).height * row;
        int remainingPixels = this.size.height - lineWidth * (this.rows + 1) - this.baseCellSize((int)lineWidth).height * this.rows;
        if (remainingPixels > 0) {
            cellHeightBefore = row > remainingPixels ? (cellHeightBefore += remainingPixels) : (cellHeightBefore += row);
        }
        int totGridLineWidth = lineWidth * row;
        int gridAdjust = lineWidth / 2;
        y = cellHeightBefore + totGridLineWidth + gridAdjust;
        return new Line(new Point(0, y), new Point(this.size.width, y));
    }

    public Line[] getVerticalGridlines() {
        Line[] lines = new Line[this.columns + 1];
        for (int column = 0; column <= this.columns; ++column) {
            lines[column] = this.getVerticalGridline(column);
        }
        return lines;
    }

    public Line getVerticalGridline(int column) {
        return this.getVerticalGridline(column, this.gridlineWidth);
    }

    public Line getVerticalGridline(int column, int lineWidth) {
        int x = 0;
        int cellWidthBefore = this.baseCellSize((int)lineWidth).width * column;
        int remainingPixels = this.size.width - lineWidth * (this.columns + 1) - this.baseCellSize((int)lineWidth).width * this.columns;
        if (remainingPixels > 0) {
            cellWidthBefore = column > remainingPixels ? (cellWidthBefore += remainingPixels) : (cellWidthBefore += column);
        }
        int totGridLineWidth = lineWidth * column;
        int gridAdjust = lineWidth / 2;
        x = cellWidthBefore + totGridLineWidth + gridAdjust;
        return new Line(new Point(x, 0), new Point(x, this.size.height));
    }

    public Rectangle getSelectionBorder(Rectangle cellSelection, int borderWidthPx) {
        int xStart = this.getVerticalGridline((int)cellSelection.x, (int)borderWidthPx).start.x;
        int xEnd = this.getVerticalGridline((int)(cellSelection.x + cellSelection.width), (int)borderWidthPx).end.x;
        int yStart = this.getHorizontalGridline((int)cellSelection.y, (int)borderWidthPx).start.y;
        int yEnd = this.getHorizontalGridline((int)(cellSelection.y + cellSelection.height), (int)borderWidthPx).end.y;
        return new Rectangle(xStart, yStart, xEnd - xStart, yEnd - yStart);
    }

    public Rectangle getCellOutline(int row, int column, int outlineWidthPx) {
        Rectangle cell = this.getCell(row, column);
        int adjust = outlineWidthPx / 2;
        return new Rectangle(cell.x + adjust, cell.y + adjust, cell.width - outlineWidthPx, cell.height - outlineWidthPx);
    }

    public Rectangle getCell(int row, int column) {
        int width = this.baseCellSize.width;
        int height = this.baseCellSize.height;
        int cellHeightBefore = this.baseCellSize.height * row;
        int cellWidthBefore = this.baseCellSize.width * column;
        if (this.remainingHorizontalPixels > 0) {
            if (column >= this.remainingHorizontalPixels) {
                cellWidthBefore += this.remainingHorizontalPixels;
            } else {
                cellWidthBefore += column;
                ++width;
            }
        }
        if (this.remainingVerticalPixels > 0) {
            if (row >= this.remainingVerticalPixels) {
                cellHeightBefore += this.remainingVerticalPixels;
            } else {
                cellHeightBefore += row;
                ++height;
            }
        }
        int totVerticalGridlineWidth = this.gridlineWidth * (row + 1);
        int totHorizontalGridlineWidth = this.gridlineWidth * (column + 1);
        int x = cellWidthBefore + totHorizontalGridlineWidth;
        int y = cellHeightBefore + totVerticalGridlineWidth;
        return new Rectangle(x, y, width, height);
    }

    public Point getClickedCell(int x, int y) {
        int i;
        int cellRow = this.rows - 1;
        int cellColumn = this.columns - 1;
        for (i = 0; i < this.rows - 1; ++i) {
            if (y >= this.getCell((int)(i + 1), (int)0).y - this.gridlineWidth / 2) continue;
            cellRow = i;
            break;
        }
        for (i = 0; i < this.columns - 1; ++i) {
            if (x >= this.getCell((int)0, (int)(i + 1)).x - this.gridlineWidth / 2) continue;
            cellColumn = i;
            break;
        }
        return new Point(cellColumn, cellRow);
    }

    private Dimension baseCellSize(int gridlineSize) {
        int totalCellHeight = this.size.height - (this.rows + 1) * gridlineSize;
        int totalCellWidth = this.size.width - (this.columns + 1) * gridlineSize;
        int cellHeight = totalCellHeight / this.rows;
        int cellWidth = totalCellWidth / this.columns;
        return new Dimension(cellWidth, cellHeight);
    }
}

