/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.overlay;

import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.sql.SQLException;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.overlay.SizeFactor;
import model3.SBdb;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.Well;
import util.SBException;

public class TaxonCountManager {
    private Well well;
    private Smpdtl smpdtl;
    private final SBdb db;
    private UndoableEditSupport undoSupport = new UndoableEditSupport();

    public TaxonCountManager(SBdb db, Well w, Smpdtl d) {
        this.db = db;
        this.well = w;
        this.smpdtl = d;
    }

    public UndoableEditSupport getUndoSupport() {
        return this.undoSupport;
    }

    public void setSmpdtl(Well w, Smpdtl d) {
        if (w != this.well) {
            this.well = w;
        }
        if (d != this.smpdtl) {
            this.smpdtl = d;
        }
    }

    public void addQuantitativeCount(Taxon taxon, SizeFactor factor, int amount, Situation situation, boolean isQuestionable, boolean isMarker) throws SBException, SQLException {
        TaxonOcc occ = this.smpdtl.getFss(taxon, situation, isQuestionable ? (char)'?' : 'P', 0);
        if (occ == null) {
            this.insertOccurrence(taxon, factor, amount, situation, isQuestionable, isMarker);
        } else {
            if (this.getSizeCount(occ, factor) + amount < 0) {
                amount = -1 * this.getSizeCount(occ, factor);
            }
            if (amount == 0) {
                return;
            }
            this.incrememntCount(occ, factor, amount);
        }
    }

    private void incrememntCount(TaxonOcc occ, SizeFactor factor, int amount) throws SQLException, SBException {
        this.undoSupport.postEdit(this.smpdtl.incrementOcc(this.well.getWellID(), this.smpdtl.getSample().getSampID(), occ, this.getSizeFactorNumber(factor), amount, true));
        this.db.commit();
        this.smpdtl.notifyObservers();
    }

    private void insertOccurrence(Taxon taxon, SizeFactor factor, int amount, Situation situation, boolean isQuestionable, boolean isMarker) throws SBException, SQLException {
        this.undoSupport.postEdit((UndoableEdit)((Object)this.smpdtl.insertOccurrence(new TaxonOcc.Builder(this.db, taxon, situation, isQuestionable, 0).marker(isMarker).count(factor == SizeFactor.COARSE ? amount : 0, factor == SizeFactor.MEDIUM ? amount : 0, factor == SizeFactor.FINE ? amount : 0), this.well.getWellID())));
        this.db.commit();
        this.smpdtl.notifyObservers();
    }

    public void setSemiQuantCount(Taxon taxon, Situation situation, boolean isQuestionable, boolean isMarker, boolean isCaved, String abundanceEntry) throws SQLException, SBException {
        if (this.smpdtl == null || !this.well.canWrite(this.db, null)) {
            return;
        }
        TaxonOcc occ = this.smpdtl.getFss(taxon, situation, isQuestionable ? (char)'?' : 'P', 0);
        AbundanceScheme scheme = this.db.getAbundanceSchemeService().findAbundanceScheme(this.smpdtl.getHeader().getAbnSchID()).orElse(null);
        if (scheme == null) {
            return;
        }
        if (occ != null) {
            if (occ.getTotalCount() > 0) {
                return;
            }
            this.undoSupport.postEdit((UndoableEdit)((Object)this.smpdtl.setSubjAbund(this.well.getWellID(), occ, abundanceEntry)));
        } else {
            this.undoSupport.postEdit((UndoableEdit)((Object)this.smpdtl.insertOccurrence(new TaxonOcc.Builder(this.db, taxon, situation, isQuestionable, 0).subjAbund(abundanceEntry).marker(isMarker), this.well.getWellID())));
        }
        this.db.commit();
        this.smpdtl.notifyObservers();
    }

    private int getSizeCount(TaxonOcc occ, SizeFactor factor) {
        if (factor == SizeFactor.FINE) {
            return occ.getFine();
        }
        if (factor == SizeFactor.COARSE) {
            return occ.getCoarse();
        }
        return occ.getMedium();
    }

    private int getSizeFactorNumber(SizeFactor factor) {
        if (factor == SizeFactor.FINE) {
            return 3;
        }
        if (factor == SizeFactor.MEDIUM) {
            return 2;
        }
        return 1;
    }

    public void addOutsideTheCountOcc(Taxon t, Situation situation, boolean questionable, boolean mkr) throws SBException, SQLException {
        if (this.smpdtl == null) {
            return;
        }
        TaxonOcc occ = this.smpdtl.getFss(t, situation, questionable ? (char)'?' : 'P', 0);
        if (occ == null) {
            this.undoSupport.postEdit((UndoableEdit)((Object)this.smpdtl.insertOccurrence(new TaxonOcc.Builder(this.db, t, situation, questionable, 0).marker(mkr), this.well.getWellID())));
        }
        this.db.commit();
        this.smpdtl.notifyObservers();
    }
}

