/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.refresh;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.Timer;
import jsbugs.refresh.DataRefreshTask;

public class RefreshHelper {
    private static long REFRESH_INTERVAL = 0L;
    private static RefreshHelper helperInstance;
    public static final Object REFRESH_LOCK;
    public static final String TIME_FORMAT = "HH:mm:ss";
    private Timer timer;
    private ActionListener timerListener;
    private DataRefreshTask currentRefreshTask;

    public static long getRefreshInterval() {
        return REFRESH_INTERVAL;
    }

    public static void setRefreshInterval(long refreshInterval) {
        REFRESH_INTERVAL = refreshInterval;
    }

    private RefreshHelper() {
    }

    public static boolean startRefresh(final JLabel jLabelRefresh) {
        if (REFRESH_INTERVAL <= 0L) {
            RefreshHelper.stopRefresh();
            jLabelRefresh.setText("Data refresh off");
            return false;
        }
        helperInstance = new RefreshHelper();
        RefreshHelper.helperInstance.timerListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (helperInstance == null) {
                    return;
                }
                if (RefreshHelper.helperInstance.currentRefreshTask != null && !RefreshHelper.helperInstance.currentRefreshTask.isDone()) {
                    Logger.getLogger(RefreshHelper.class.getName()).warning("Refresh task aborted because previous refresh was not done");
                    return;
                }
                RefreshHelper.helperInstance.currentRefreshTask = new DataRefreshTask(jLabelRefresh, null);
                jLabelRefresh.setText("Refreshing...");
                RefreshHelper.helperInstance.currentRefreshTask.execute();
            }
        };
        RefreshHelper.helperInstance.timer = new Timer((int)REFRESH_INTERVAL, RefreshHelper.helperInstance.timerListener);
        RefreshHelper.helperInstance.timer.start();
        return true;
    }

    public static void stopRefresh() {
        if (helperInstance != null) {
            RefreshHelper.helperInstance.timer.stop();
            helperInstance = null;
        }
    }

    static {
        REFRESH_LOCK = new Object();
    }
}

