/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.sampleage;

import com.stratadata.model3.well.sample.SampleProperties;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.io.DialogCSVOptions;
import jsbugs.sampleage.DialogSampleAgeImportConfirm;
import jsbugs.sampleage.DialogViewTableData;
import jsbugs.sampleage.ImportSampleAgePreviewTableModel;
import jsbugs.sampleage.SampleAgeCreationRecord;
import jsbugs.sampleage.SampleAgeImportRecord;
import jsbugs.sampleage.SampleAgeUpdateRecord;
import jsbugs.sampleage.SampleCreationRequest;
import jsbugs.sampleage.SamplePropsListMatcher;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.DecimalRenderer;
import jsbugs.table.DepthRenderer;
import model3.Lastval;
import model3.SBdb;
import model3.Sample;
import util.AgeFormat;
import util.AgeUtils;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;
import util.exception.StackError;
import util.gridreader.GridReaderException;
import util.gridreader.TableData;
import util.gridreader.TableReader;
import util.gridreader.TableRow;

public class DialogSampleAgeImport
extends SBDialog {
    public static final String LAST_WINDOWS_SAMPLE_AGE_IMPORT_KEY = "WINSAGEIMP";
    public static final String LAST_UNIX_SAMPLE_AGE_IMPORT_KEY = "UNXSAGEIMP";
    private TableData data = null;
    private String filename;
    private List<JComboBox> mappingComboBoxes = null;
    private Frame parent;
    private DialogViewTableData viewDialog;
    private final List<Sample> existingSamples;
    private List<SampleAgeImportRecord> importRecords = new ArrayList<SampleAgeImportRecord>();
    private List<SampleAgeCreationRecord> creationReocrds = new ArrayList<SampleAgeCreationRecord>();
    private final SamplePropsListMatcher sampleListMatcher = new SamplePropsListMatcher();
    private static String NO_COLUMN_TEXT = "<No Column>";
    private char units = (char)77;
    private List<SampleAgeUpdateRecord> updateRecords = new ArrayList<SampleAgeUpdateRecord>();
    private AgeFormat ageUnits = AgeFormat.MA;
    private final SBdb sbdb;
    private boolean generateMissingSamples = false;
    private DialogCSVOptions dlgOptions;
    private JButton jButtonAccept;
    private JButton jButtonAccept1;
    private JButton jButtonCancel;
    private JButton jButtonImportOptions;
    private JButton jButtonOpenFile;
    private JButton jButtonViewData;
    private JCheckBox jCheckBoxGenerateMissingSamples;
    private JComboBox<String> jComboBoxAge;
    private JComboBox<String> jComboBoxBaseDepth;
    private JComboBox<String> jComboBoxDepth;
    private JComboBox<String> jComboBoxIsotopeRatio;
    private JComboBox<String> jComboBoxLabel;
    private JComboBox<String> jComboBoxNegativeError;
    private JComboBox<String> jComboBoxPositiveError;
    private JComboBox<String> jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelAge;
    private JLabel jLabelBaseDepth;
    private JLabel jLabelDataFile;
    private JLabel jLabelIsotopeRatio;
    private JLabel jLabelLabel;
    private JLabel jLabelNegativeError;
    private JLabel jLabelPositiveError;
    private JLabel jLabelTopDepth;
    private JLabel jLabelType;
    private JPanel jPanelColumnMappings;
    private JScrollPane jScrollPane1;
    private JTable jTableImportSampleAgePreview;

    public DialogSampleAgeImport(Frame parent, boolean modal, List<Sample> existingSamples, char units, AgeFormat ageUnits, SBdb sbdb) {
        super(parent, modal);
        this.setTitle("Read Sample Age Data");
        this.initComponents();
        this.existingSamples = existingSamples;
        this.units = units;
        this.ageUnits = ageUnits;
        this.sbdb = sbdb;
        this.dlgOptions = new DialogCSVOptions((JDialog)((Object)this), true);
        this.mappingComboBoxes = new ArrayList<JComboBox>();
        this.mappingComboBoxes.add(this.jComboBoxDepth);
        this.mappingComboBoxes.add(this.jComboBoxBaseDepth);
        this.mappingComboBoxes.add(this.jComboBoxLabel);
        this.mappingComboBoxes.add(this.jComboBoxType);
        this.mappingComboBoxes.add(this.jComboBoxAge);
        this.mappingComboBoxes.add(this.jComboBoxPositiveError);
        this.mappingComboBoxes.add(this.jComboBoxNegativeError);
        this.mappingComboBoxes.add(this.jComboBoxIsotopeRatio);
        this.jPanelColumnMappings.setVisible(false);
        this.jLabelBaseDepth.setText("Base Depth (" + DepthUnits.getUnits((char)units).getAbr() + ")");
        this.jLabelTopDepth.setText("Top Depth (" + DepthUnits.getUnits((char)units).getAbr() + ")");
        this.jLabelAge.setText("Age (" + ageUnits.getDescr() + ")");
        this.jLabelPositiveError.setText("Positive Error (" + ageUnits.getDescr() + ")");
        this.jLabelNegativeError.setText("Negative Error (" + ageUnits.getDescr() + ")");
        ImportSampleAgePreviewTableModel model = new ImportSampleAgePreviewTableModel();
        model.setUnits(units);
        model.setAgeUnits(ageUnits);
        this.jTableImportSampleAgePreview.setModel(model);
        SB.setTableHeaderBold((JTable)this.jTableImportSampleAgePreview);
        TableUtils.setPrefferedWidths((JTable)this.jTableImportSampleAgePreview, (int[])new int[]{100, 105, 60, 40, 70, 100, 100, 100, 20, 96, 106, 60, 40});
        TableColumnModel columnModel = this.jTableImportSampleAgePreview.getTableHeader().getColumnModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setWidth(model.colWidth[i]);
        }
        columnModel.getColumn(10).setCellRenderer(new DepthRenderer());
        columnModel.getColumn(9).setCellRenderer(new DepthRenderer());
        columnModel.getColumn(1).setCellRenderer(new DepthRenderer());
        columnModel.getColumn(0).setCellRenderer(new DepthRenderer());
        columnModel.getColumn(8).setCellRenderer(new ArrowCellRenderer());
        columnModel.getColumn(8).setMaxWidth(20);
        columnModel.getColumn(8).setMinWidth(20);
        columnModel.getColumn(4).setCellRenderer(new DecimalRenderer(false));
        columnModel.getColumn(6).setCellRenderer(new DecimalRenderer(false));
        columnModel.getColumn(5).setCellRenderer(new DecimalRenderer(false));
        columnModel.getColumn(7).setCellRenderer(new DecimalRenderer(false));
        this.updateMatchTable();
        for (JComboBox cbo : this.mappingComboBoxes) {
            cbo.addActionListener(new ActionListener(this){
                final /* synthetic */ DialogSampleAgeImport this$0;
                {
                    DialogSampleAgeImport dialogSampleAgeImport = this$0;
                    Objects.requireNonNull(dialogSampleAgeImport);
                    this.this$0 = dialogSampleAgeImport;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.this$0.mappingSelectionChanged();
                }
            });
        }
    }

    private void mappingSelectionChanged() {
        this.importRecords = this.buildImportRecords();
        this.updateMatchTable();
    }

    private List<SampleAgeImportRecord> buildImportRecords() {
        HashMap<SampleAgeMappings, Integer> map = new HashMap<SampleAgeMappings, Integer>();
        map.put(SampleAgeMappings.TOP_DEPTH, this.getMappingFromComboBox(this.jComboBoxDepth, this.data.getHeaders()));
        map.put(SampleAgeMappings.BASE_DEPTH, this.getMappingFromComboBox(this.jComboBoxBaseDepth, this.data.getHeaders()));
        map.put(SampleAgeMappings.LABEL, this.getMappingFromComboBox(this.jComboBoxLabel, this.data.getHeaders()));
        map.put(SampleAgeMappings.TYPE, this.getMappingFromComboBox(this.jComboBoxType, this.data.getHeaders()));
        map.put(SampleAgeMappings.AGE, this.getMappingFromComboBox(this.jComboBoxAge, this.data.getHeaders()));
        map.put(SampleAgeMappings.ISOTOPE_RATIO, this.getMappingFromComboBox(this.jComboBoxIsotopeRatio, this.data.getHeaders()));
        map.put(SampleAgeMappings.POSITIVE_ERROR, this.getMappingFromComboBox(this.jComboBoxPositiveError, this.data.getHeaders()));
        map.put(SampleAgeMappings.NEGATIVE_ERROR, this.getMappingFromComboBox(this.jComboBoxNegativeError, this.data.getHeaders()));
        ArrayList<SampleAgeImportRecord> records = new ArrayList<SampleAgeImportRecord>();
        for (TableRow row : this.data.getRows()) {
            SampleType type;
            String typeStr;
            Double baseDepth;
            Double topDepth;
            SampleAgeImportRecord record = new SampleAgeImportRecord();
            if ((Integer)map.get((Object)SampleAgeMappings.TOP_DEPTH) >= 0 && (topDepth = row.getDouble(((Integer)map.get((Object)SampleAgeMappings.TOP_DEPTH)).intValue())) != null) {
                record.setTopDepth(SampleCreationRequest.getDepthValue(DepthUtils.convToM((double)topDepth, (char)this.units)));
            }
            if ((Integer)map.get((Object)SampleAgeMappings.BASE_DEPTH) >= 0 && (baseDepth = row.getDouble(((Integer)map.get((Object)SampleAgeMappings.BASE_DEPTH)).intValue())) != null) {
                record.setBaseDepth(SampleCreationRequest.getDepthValue(DepthUtils.convToM((double)baseDepth, (char)this.units)));
            }
            if ((Integer)map.get((Object)SampleAgeMappings.AGE) >= 0) {
                record.setAge(AgeUtils.convertToMa((Double)row.getDouble(((Integer)map.get((Object)SampleAgeMappings.AGE)).intValue()), (AgeFormat)this.ageUnits));
            }
            if ((Integer)map.get((Object)SampleAgeMappings.POSITIVE_ERROR) >= 0) {
                record.setPositiveError(AgeUtils.convertToMa((Float)row.getFloat(((Integer)map.get((Object)SampleAgeMappings.POSITIVE_ERROR)).intValue()), (AgeFormat)this.ageUnits));
            }
            if ((Integer)map.get((Object)SampleAgeMappings.NEGATIVE_ERROR) >= 0) {
                record.setNegativeError(AgeUtils.convertToMa((Float)row.getFloat(((Integer)map.get((Object)SampleAgeMappings.NEGATIVE_ERROR)).intValue()), (AgeFormat)this.ageUnits));
            }
            if ((Integer)map.get((Object)SampleAgeMappings.ISOTOPE_RATIO) >= 0) {
                record.setIsotopeRatio(row.getDouble(((Integer)map.get((Object)SampleAgeMappings.ISOTOPE_RATIO)).intValue()));
            }
            if ((Integer)map.get((Object)SampleAgeMappings.TYPE) >= 0 && (typeStr = row.get(((Integer)map.get((Object)SampleAgeMappings.TYPE)).intValue())) != null && (type = SampleType.parseType((String)typeStr)) != null) {
                record.setType(type);
            }
            if ((Integer)map.get((Object)SampleAgeMappings.LABEL) >= 0) {
                record.setLabel(row.get(((Integer)map.get((Object)SampleAgeMappings.LABEL)).intValue()));
            }
            if (record.isEmpty()) continue;
            records.add(record);
        }
        return records;
    }

    private int getMappingFromComboBox(JComboBox box, List<String> columnHeaders) {
        if (box.getSelectedItem() == null || ((String)box.getSelectedItem()).equals(NO_COLUMN_TEXT)) {
            return -1;
        }
        String selectedColumn = (String)box.getSelectedItem();
        int selectedIndex = columnHeaders.indexOf(selectedColumn);
        return selectedIndex;
    }

    private void updateMatchTable() {
        List<Map.Entry<SampleProperties, SampleProperties>> matchResults = this.sampleListMatcher.matchLists(this.importRecords, this.existingSamples);
        boolean oneMatch = false;
        ArrayList<Map.Entry<SampleAgeImportRecord, SampleProperties>> results = new ArrayList<Map.Entry<SampleAgeImportRecord, SampleProperties>>();
        for (Map.Entry<SampleProperties, SampleProperties> entry : matchResults) {
            SampleAgeImportRecord record = (SampleAgeImportRecord)entry.getKey();
            SampleProperties sample = (Sample)entry.getValue();
            if (sample == null && this.generateMissingSamples && record.hasDepth()) {
                SampleType type = record.getType() != null ? record.getType() : SampleType.CU;
                sample = new SampleCreationRequest(record.getTopDepth(), record.getBaseDepth(), record.getLabel(), type);
            }
            results.add(new AbstractMap.SimpleEntry<SampleAgeImportRecord, Sample>(record, (Sample)sample));
            oneMatch = oneMatch || record != null && sample != null;
        }
        ((ImportSampleAgePreviewTableModel)this.jTableImportSampleAgePreview.getModel()).setRows(results);
        ((ImportSampleAgePreviewTableModel)this.jTableImportSampleAgePreview.getModel()).fireTableDataChanged();
        this.jButtonAccept1.setEnabled(oneMatch);
    }

    private void openNewDataFile(File file) {
        this.filename = file.getName();
        try {
            TableReader reader = new TableReader();
            if (file.getName().toLowerCase().endsWith(".xls") || file.getName().toLowerCase().endsWith(".xlsx")) {
                this.data = reader.readTableData(file);
            } else {
                reader.setDelimiter(this.dlgOptions.getColumnDelimiter());
                this.data = reader.readTableData(file);
                DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
                DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
                dfs.setDecimalSeparator(this.dlgOptions.getDecimalSeparator());
                df.setDecimalFormatSymbols(dfs);
                this.data.setNumberFormat((NumberFormat)df);
            }
        }
        catch (IOException | GridReaderException ex) {
            StackError.showStackError((String)("An error occurred while opening the file. \n" + ex.getMessage()), (Throwable)ex);
        }
        ArrayList<String> options = new ArrayList<String>(this.data.getHeaders());
        options.add(0, NO_COLUMN_TEXT);
        for (JComboBox cbo : this.mappingComboBoxes) {
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(options.toArray());
            cbo.setModel(model);
        }
        this.setInitialSelection(this.jComboBoxDepth, options, new String[]{"top"});
        this.setInitialSelection(this.jComboBoxBaseDepth, options, new String[]{"base"});
        this.setInitialSelection(this.jComboBoxLabel, options, new String[]{"sample", "label"});
        this.setInitialSelection(this.jComboBoxType, options, new String[]{"type"});
        this.setInitialSelection(this.jComboBoxAge, options, new String[]{"age"});
        this.setInitialSelection(this.jComboBoxPositiveError, options, new String[]{"+ve", "pos", "positive", "error"});
        this.setInitialSelection(this.jComboBoxNegativeError, options, new String[]{"-ve", "neg", "negative"});
        this.setInitialSelection(this.jComboBoxIsotopeRatio, options, new String[]{"ratio", "isotope"});
        this.jPanelColumnMappings.setVisible(true);
        this.jButtonViewData.setEnabled(true);
        this.jLabelDataFile.setText("Opened file " + this.filename);
    }

    private void setInitialSelection(JComboBox box, List<String> options, String[] keywords) {
        for (String option : options) {
            for (String keyword : keywords) {
                Pattern p = Pattern.compile("\\b" + keyword + "\\b", 2);
                Matcher m = p.matcher(option);
                if (!m.find()) continue;
                box.setSelectedItem(option);
                return;
            }
        }
    }

    private void showFileContentsDialog() {
        this.closeFileContentsDialog();
        this.viewDialog = new DialogViewTableData((Dialog)((Object)this), false, this.data);
        this.viewDialog.pack();
        this.viewDialog.setLocationRelativeTo(this.parent);
        this.viewDialog.setTitle("Contents of " + this.filename);
        this.viewDialog.setVisible(true);
    }

    private void closeFileContentsDialog() {
        if (this.viewDialog == null) {
            return;
        }
        this.viewDialog.setVisible(false);
        this.viewDialog.dispose();
        this.viewDialog = null;
    }

    private void initComponents() {
        this.jButtonAccept = new JButton();
        this.jLabel2 = new JLabel();
        this.jButtonOpenFile = new JButton();
        this.jPanelColumnMappings = new JPanel();
        this.jLabelTopDepth = new JLabel();
        this.jLabelBaseDepth = new JLabel();
        this.jLabelLabel = new JLabel();
        this.jLabelType = new JLabel();
        this.jComboBoxBaseDepth = new JComboBox();
        this.jComboBoxDepth = new JComboBox();
        this.jComboBoxLabel = new JComboBox();
        this.jComboBoxType = new JComboBox();
        this.jLabelAge = new JLabel();
        this.jLabelPositiveError = new JLabel();
        this.jLabelNegativeError = new JLabel();
        this.jLabelIsotopeRatio = new JLabel();
        this.jComboBoxPositiveError = new JComboBox();
        this.jComboBoxNegativeError = new JComboBox();
        this.jComboBoxIsotopeRatio = new JComboBox();
        this.jComboBoxAge = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTableImportSampleAgePreview = new ImportSampleAgePreviewTable(this);
        this.jButtonCancel = new JButton();
        this.jButtonAccept1 = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabelDataFile = new JLabel();
        this.jButtonViewData = new JButton();
        this.jCheckBoxGenerateMissingSamples = new JCheckBox();
        this.jButtonImportOptions = new JButton();
        this.jButtonAccept.setText("Accept");
        this.jButtonAccept.setEnabled(false);
        this.jLabel2.setFont(new Font("Tahoma", 0, 18));
        this.jLabel2.setText("Existing Samples");
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(550, 395));
        this.setPreferredSize(new Dimension(900, 450));
        this.jButtonOpenFile.setText("Open file ...");
        this.jButtonOpenFile.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeImport this$0;
            {
                DialogSampleAgeImport dialogSampleAgeImport = this$0;
                Objects.requireNonNull(dialogSampleAgeImport);
                this.this$0 = dialogSampleAgeImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOpenFileActionPerformed(evt);
            }
        });
        this.jPanelColumnMappings.setBorder(BorderFactory.createTitledBorder(null, "Column Mappings", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabelTopDepth.setText("Top Depth");
        this.jLabelBaseDepth.setText("Base Depth");
        this.jLabelLabel.setText("Label");
        this.jLabelType.setText("Type");
        this.jComboBoxBaseDepth.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxDepth.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxLabel.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabelAge.setText("Age");
        this.jLabelPositiveError.setText("Positive Error");
        this.jLabelNegativeError.setText("Negative Error");
        this.jLabelIsotopeRatio.setText("Isotope Raito");
        this.jComboBoxPositiveError.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxNegativeError.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxIsotopeRatio.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxAge.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanelColumnMappingsLayout = new GroupLayout(this.jPanelColumnMappings);
        this.jPanelColumnMappings.setLayout(jPanelColumnMappingsLayout);
        jPanelColumnMappingsLayout.setHorizontalGroup(jPanelColumnMappingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelColumnMappingsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelColumnMappingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelLabel).addComponent(this.jLabelBaseDepth).addComponent(this.jLabelTopDepth).addComponent(this.jLabelType)).addGap(37, 37, 37).addGroup(jPanelColumnMappingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelColumnMappingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxDepth, 0, 100, Short.MAX_VALUE).addComponent(this.jComboBoxLabel, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxBaseDepth, 0, -1, Short.MAX_VALUE)).addComponent(this.jComboBoxType, -2, 100, -2)).addGap(65, 65, 65).addGroup(jPanelColumnMappingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, jPanelColumnMappingsLayout.createSequentialGroup().addComponent(this.jLabelAge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jComboBoxAge, -2, 100, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanelColumnMappingsLayout.createSequentialGroup().addComponent(this.jLabelPositiveError).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 37, Short.MAX_VALUE).addComponent(this.jComboBoxPositiveError, -2, 100, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanelColumnMappingsLayout.createSequentialGroup().addGroup(jPanelColumnMappingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelIsotopeRatio).addComponent(this.jLabelNegativeError)).addGap(31, 31, 31).addGroup(jPanelColumnMappingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxIsotopeRatio, 0, 100, Short.MAX_VALUE).addComponent(this.jComboBoxNegativeError, 0, -1, Short.MAX_VALUE)))).addContainerGap(414, Short.MAX_VALUE)));
        jPanelColumnMappingsLayout.setVerticalGroup(jPanelColumnMappingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelColumnMappingsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelColumnMappingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTopDepth).addComponent(this.jComboBoxDepth, -2, -1, -2).addComponent(this.jLabelAge).addComponent(this.jComboBoxAge, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelColumnMappingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelBaseDepth).addComponent(this.jComboBoxBaseDepth, -2, -1, -2).addComponent(this.jLabelPositiveError).addComponent(this.jComboBoxPositiveError, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelColumnMappingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelLabel).addComponent(this.jComboBoxLabel, -2, -1, -2).addComponent(this.jLabelNegativeError).addComponent(this.jComboBoxNegativeError, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelColumnMappingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelType).addComponent(this.jComboBoxType, -2, -1, -2).addComponent(this.jLabelIsotopeRatio).addComponent(this.jComboBoxIsotopeRatio, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTableImportSampleAgePreview.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jScrollPane1.setViewportView(this.jTableImportSampleAgePreview);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeImport this$0;
            {
                DialogSampleAgeImport dialogSampleAgeImport = this$0;
                Objects.requireNonNull(dialogSampleAgeImport);
                this.this$0 = dialogSampleAgeImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonAccept1.setText("Accept");
        this.jButtonAccept1.setEnabled(false);
        this.jButtonAccept1.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeImport this$0;
            {
                DialogSampleAgeImport dialogSampleAgeImport = this$0;
                Objects.requireNonNull(dialogSampleAgeImport);
                this.this$0 = dialogSampleAgeImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAccept1ActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Tahoma", 0, 18));
        this.jLabel3.setText("Existing Samples");
        this.jLabel1.setFont(new Font("Tahoma", 0, 18));
        this.jLabel1.setText("Imported Sample Age Data");
        this.jLabelDataFile.setText("No sample age file loaded.");
        this.jButtonViewData.setText("View data");
        this.jButtonViewData.setEnabled(false);
        this.jButtonViewData.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeImport this$0;
            {
                DialogSampleAgeImport dialogSampleAgeImport = this$0;
                Objects.requireNonNull(dialogSampleAgeImport);
                this.this$0 = dialogSampleAgeImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonViewDataActionPerformed(evt);
            }
        });
        this.jCheckBoxGenerateMissingSamples.setText("Generate missing samples");
        this.jCheckBoxGenerateMissingSamples.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeImport this$0;
            {
                DialogSampleAgeImport dialogSampleAgeImport = this$0;
                Objects.requireNonNull(dialogSampleAgeImport);
                this.this$0 = dialogSampleAgeImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxGenerateMissingSamplesActionPerformed(evt);
            }
        });
        this.jButtonImportOptions.setText("CSV import options ...");
        this.jButtonImportOptions.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeImport this$0;
            {
                DialogSampleAgeImport dialogSampleAgeImport = this$0;
                Objects.requireNonNull(dialogSampleAgeImport);
                this.this$0 = dialogSampleAgeImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonImportOptionsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxGenerateMissingSamples).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanelColumnMappings, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonAccept1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOpenFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonImportOptions).addGap(15, 15, 15).addComponent(this.jLabelDataFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonViewData)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel3))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOpenFile).addComponent(this.jLabelDataFile).addComponent(this.jButtonViewData).addComponent(this.jButtonImportOptions)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelColumnMappings, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 151, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxGenerateMissingSamples).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonAccept1)).addContainerGap()));
        this.pack();
    }

    private void jButtonOpenFileActionPerformed(ActionEvent evt) {
        FileNameExtensionFilter filter;
        File file;
        String lastFileOpened = Lastval.tryGetString(this.sbdb, LAST_WINDOWS_SAMPLE_AGE_IMPORT_KEY, LAST_UNIX_SAMPLE_AGE_IMPORT_KEY);
        File initialDir = null;
        if (lastFileOpened != null) {
            initialDir = new File(lastFileOpened).getParentFile();
        }
        if ((file = FileChooserUtils.chooseReadableFile((Component)((Object)this), (FileNameExtensionFilter)(filter = new FileNameExtensionFilter("Excel or CSV file", "csv", "xls", "xlsx")), (File)initialDir)) != null) {
            Lastval.tryPutString(this.sbdb, LAST_WINDOWS_SAMPLE_AGE_IMPORT_KEY, LAST_UNIX_SAMPLE_AGE_IMPORT_KEY, file.getPath());
            this.openNewDataFile(file);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        if (this.viewDialog != null) {
            this.closeFileContentsDialog();
        }
        this.dispose();
    }

    private void jButtonViewDataActionPerformed(ActionEvent evt) {
        this.viewDialog = new DialogViewTableData((Dialog)((Object)this), false, this.data);
        this.viewDialog.pack();
        this.viewDialog.setLocationRelativeTo(this.parent);
        this.viewDialog.setTitle("Contents of " + this.filename);
        this.viewDialog.setVisible(true);
    }

    private void jButtonAccept1ActionPerformed(ActionEvent evt) {
        this.updateRecords = new ArrayList<SampleAgeUpdateRecord>();
        this.creationReocrds = new ArrayList<SampleAgeCreationRecord>();
        List<Map.Entry<SampleAgeImportRecord, SampleProperties>> results = ((ImportSampleAgePreviewTableModel)this.jTableImportSampleAgePreview.getModel()).getRows();
        for (Map.Entry<SampleAgeImportRecord, SampleProperties> res : results) {
            if (res.getKey() == null || res.getValue() == null) continue;
            if (res.getValue() instanceof Sample) {
                this.updateRecords.add(new SampleAgeUpdateRecord((Sample)res.getValue(), res.getKey().getAge(), res.getKey().getPositiveError(), res.getKey().getNegativeError(), res.getKey().getIsotopeRatio()));
                continue;
            }
            if (!(res.getValue() instanceof SampleCreationRequest)) continue;
            this.creationReocrds.add(new SampleAgeCreationRecord((SampleCreationRequest)res.getValue(), res.getKey().getAge(), res.getKey().getPositiveError(), res.getKey().getNegativeError(), res.getKey().getIsotopeRatio()));
        }
        DialogSampleAgeImportConfirm confirmDialog = new DialogSampleAgeImportConfirm((Dialog)((Object)this), true, this.getCreationRecords(), this.getUpdateRecords(), this.units, this.ageUnits);
        confirmDialog.pack();
        confirmDialog.setLocationRelativeTo((Component)((Object)this));
        confirmDialog.setVisible(true);
        if (confirmDialog.isOK) {
            this.setIsOK(true);
            this.setVisible(false);
        }
    }

    private void jCheckBoxGenerateMissingSamplesActionPerformed(ActionEvent evt) {
        this.generateMissingSamples = this.jCheckBoxGenerateMissingSamples.isSelected();
        this.updateMatchTable();
    }

    private void jButtonImportOptionsActionPerformed(ActionEvent evt) {
        this.dlgOptions.setLocationRelativeTo((Component)((Object)this));
        this.dlgOptions.pack();
        this.dlgOptions.setVisible(true);
    }

    public List<SampleAgeUpdateRecord> getUpdateRecords() {
        return this.updateRecords;
    }

    public List<SampleAgeCreationRecord> getCreationRecords() {
        return this.creationReocrds;
    }

    public static enum SampleAgeMappings {
        TOP_DEPTH,
        BASE_DEPTH,
        LABEL,
        TYPE,
        AGE,
        POSITIVE_ERROR,
        NEGATIVE_ERROR,
        ISOTOPE_RATIO;

    }

    private class ImportSampleAgePreviewTable
    extends JTable {
        final /* synthetic */ DialogSampleAgeImport this$0;

        private ImportSampleAgePreviewTable(DialogSampleAgeImport dialogSampleAgeImport) {
            DialogSampleAgeImport dialogSampleAgeImport2 = dialogSampleAgeImport;
            Objects.requireNonNull(dialogSampleAgeImport2);
            this.this$0 = dialogSampleAgeImport2;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
            Component c = super.prepareRenderer(renderer, row, col);
            int[] selectedRows = this.getSelectedRows();
            Arrays.sort(selectedRows);
            if (Arrays.binarySearch(selectedRows, row) >= 0) {
                c.setBackground(this.getSelectionBackground());
                c.setForeground(this.getSelectionForeground());
            } else {
                c.setForeground(this.getForeground());
                if (col > 8) {
                    Map.Entry<SampleAgeImportRecord, SampleProperties> rowObject = ((ImportSampleAgePreviewTableModel)this.getModel()).getRows().get(row);
                    if (rowObject.getValue() instanceof SampleCreationRequest) {
                        c.setBackground(new Color(200, 255, 200));
                    } else {
                        c.setBackground(this.getBackground());
                    }
                } else if (col < 8) {
                    c.setBackground(this.getBackground());
                } else if (col == 8) {
                    c.setBackground(new Color(240, 240, 240));
                }
            }
            return c;
        }
    }
}

