/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.sampleage;

import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.sampleage.SampleAgeCreationRecord;
import jsbugs.sampleage.SampleAgeUpdateRecord;
import jsbugs.sampleage.SampleUpdatesTableModel;
import jsbugs.table.DecimalRenderer;
import jsbugs.table.DepthRenderer;
import util.AgeFormat;
import util.SB;

public class DialogSampleAgeImportConfirm
extends JDialog {
    boolean isOK = false;
    private JButton jButtonCancel;
    private JButton jButtonUpdate;
    private JLabel jLabel1;
    private JLabel jLabelMessage;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public DialogSampleAgeImportConfirm(Frame parent, boolean modal, List<SampleAgeCreationRecord> creationRecords, List<SampleAgeUpdateRecord> updateReocrds, char units, AgeFormat ageUnits) {
        super(parent, modal);
        this.initComponents();
        this.init(creationRecords, updateReocrds, units, ageUnits);
    }

    public DialogSampleAgeImportConfirm(Dialog parent, boolean modal, List<SampleAgeCreationRecord> creationRecords, List<SampleAgeUpdateRecord> updateReocrds, char units, AgeFormat ageUnits) {
        super(parent, modal);
        this.initComponents();
        this.init(creationRecords, updateReocrds, units, ageUnits);
    }

    private void init(List<SampleAgeCreationRecord> creationRecords, List<SampleAgeUpdateRecord> updateReocrds, char units, AgeFormat ageUnits) {
        SampleUpdatesTableModel model = new SampleUpdatesTableModel(creationRecords, updateReocrds, units, ageUnits);
        if (creationRecords.isEmpty()) {
            this.jLabelMessage.setVisible(false);
            this.pack();
        } else {
            this.jLabelMessage.setVisible(true);
            if (creationRecords.size() == 1) {
                this.jLabelMessage.setText("One new sample will be created.");
            } else {
                this.jLabelMessage.setText(creationRecords.size() + " new samples will be created.");
            }
        }
        this.jTable1.setModel(model);
        SB.setTableHeaderBold((JTable)this.jTable1);
        TableUtils.setPrefferedWidths((JTable)this.jTable1, (int[])new int[]{100, 105, 60, 40, 70, 100, 100, 100});
        TableColumnModel columnModel = this.jTable1.getTableHeader().getColumnModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setWidth(SampleUpdatesTableModel.colWidth[i]);
        }
        columnModel.getColumn(0).setCellRenderer(new DepthRenderer());
        columnModel.getColumn(1).setCellRenderer(new DepthRenderer());
        columnModel.getColumn(4).setCellRenderer(new DecimalRenderer(false));
        columnModel.getColumn(6).setCellRenderer(new DecimalRenderer(false));
        columnModel.getColumn(5).setCellRenderer(new DecimalRenderer(false));
        columnModel.getColumn(7).setCellRenderer(new DecimalRenderer(false));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new SampleUpdatesTable(this);
        this.jButtonCancel = new JButton();
        this.jButtonUpdate = new JButton();
        this.jLabelMessage = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Import Confirmation");
        this.setMinimumSize(new Dimension(711, 241));
        this.jLabel1.setText("Are you sure you want to import the following Sample Age data :");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeImportConfirm this$0;
            {
                DialogSampleAgeImportConfirm dialogSampleAgeImportConfirm = this$0;
                Objects.requireNonNull(dialogSampleAgeImportConfirm);
                this.this$0 = dialogSampleAgeImportConfirm;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonUpdate.setText("Update");
        this.jButtonUpdate.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSampleAgeImportConfirm this$0;
            {
                DialogSampleAgeImportConfirm dialogSampleAgeImportConfirm = this$0;
                Objects.requireNonNull(dialogSampleAgeImportConfirm);
                this.this$0 = dialogSampleAgeImportConfirm;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonUpdateActionPerformed(evt);
            }
        });
        this.jLabelMessage.setText("# of new samples will be created.");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelMessage, -1, 204, Short.MAX_VALUE).addGap(497, 497, 497)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 144, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelMessage, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonUpdate).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.isOK = false;
        this.setVisible(false);
    }

    private void jButtonUpdateActionPerformed(ActionEvent evt) {
        this.isOK = true;
        this.setVisible(false);
    }

    private class SampleUpdatesTable
    extends JTable {
        private Color highlightColour;
        final /* synthetic */ DialogSampleAgeImportConfirm this$0;

        private SampleUpdatesTable(DialogSampleAgeImportConfirm dialogSampleAgeImportConfirm) {
            DialogSampleAgeImportConfirm dialogSampleAgeImportConfirm2 = dialogSampleAgeImportConfirm;
            Objects.requireNonNull(dialogSampleAgeImportConfirm2);
            this.this$0 = dialogSampleAgeImportConfirm2;
            this.highlightColour = new Color(255, 255, 204);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
            Component c = super.prepareRenderer(renderer, row, col);
            SampleUpdatesTableModel model = (SampleUpdatesTableModel)this.getModel();
            if (Arrays.asList(new int[][]{this.getSelectedRows()}).contains(row)) {
                c.setBackground(this.getSelectionBackground());
                c.setForeground(this.getSelectionForeground());
            } else if (model.hasValueChanged(row, col)) {
                c.setBackground(this.highlightColour);
                c.setForeground(this.getForeground());
            } else {
                c.setBackground(this.getBackground());
                c.setForeground(this.getForeground());
            }
            return c;
        }
    }
}

