/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.sampleage;

import com.stratadata.model3.well.sample.SampleProperties;
import com.stratadata.model3.well.sample.SampleType;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import jsbugs.sampleage.SampleAgeImportRecord;
import util.AgeFormat;
import util.AgeUtils;
import util.DepthUnits;
import util.DepthUtils;

class ImportSampleAgePreviewTableModel
extends AbstractTableModel {
    String[] colTitles = new String[]{"Top Depth", "Base Depth", "Label", "Type", "Age", "+ve Error", "-ve Error", "Isotope Ratio", "", "Top Depth", "Base Depth", "Label", "Type"};
    int[] colWidth = new int[]{20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20};
    private char units = (char)77;
    private AgeFormat ageUnits = AgeFormat.MA;
    static final int COL_RECORD_TOP_DEPHT = 0;
    static final int COL_RECORD_BASE_DEPTH = 1;
    static final int COL_RECORD_LABEL = 2;
    static final int COL_RECORD_TYPE = 3;
    static final int COL_RECORD_AGE = 4;
    static final int COL_RECORD_POSITIVE_ERROR = 5;
    static final int COL_RECORD_NEGATIVE_ERROR = 6;
    static final int COL_RECORD_ISOTOPE_RATIO = 7;
    static final int COL_MATCH_ARROW = 8;
    static final int COL_SAMPLE_TOP_DEPTH = 9;
    static final int COL_SAMPLE_BASE_DEPTH = 10;
    static final int COL_SAMPLE_LABEL = 11;
    static final int COL_SAMPLE_TYPE = 12;
    private List<Map.Entry<SampleAgeImportRecord, SampleProperties>> rows;

    ImportSampleAgePreviewTableModel() {
    }

    public void setRows(List<Map.Entry<SampleAgeImportRecord, SampleProperties>> rows) {
        this.rows = rows;
    }

    public void setUnits(char units) {
        this.units = units;
    }

    public void setAgeUnits(AgeFormat ageUnits) {
        this.ageUnits = ageUnits;
    }

    public List<Map.Entry<SampleAgeImportRecord, SampleProperties>> getRows() {
        return this.rows;
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.colTitles.length;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 9 || column == 10 || column == 0 || column == 1) {
            return this.colTitles[column] + " (" + DepthUnits.getUnits((char)this.units).getAbr() + ")";
        }
        if (column == 4 || column == 6 || column == 5) {
            return this.colTitles[column] + " (" + this.ageUnits.getDescr() + ")";
        }
        return this.colTitles[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Map.Entry<SampleAgeImportRecord, SampleProperties> row = this.rows.get(rowIndex);
        if (row == null) {
            return null;
        }
        switch (columnIndex) {
            case 9: {
                if (row.getValue() == null || !row.getValue().hasDepth() || row.getValue().getTopDepth() == null) {
                    return null;
                }
                return DepthUtils.convFromM((double)row.getValue().getTopDepth(), (char)this.units);
            }
            case 10: {
                if (row.getValue() == null || !row.getValue().hasDepth() || row.getValue().getBaseDepth() == null) {
                    return null;
                }
                return DepthUtils.convFromM((double)row.getValue().getBaseDepth(), (char)this.units);
            }
            case 11: {
                if (row.getValue() == null) {
                    return null;
                }
                return row.getValue().getLabel();
            }
            case 12: {
                if (row.getValue() == null) {
                    return null;
                }
                return row.getValue().getType();
            }
            case 8: {
                return row.getKey() != null && row.getValue() != null;
            }
            case 0: {
                if (row.getKey() == null || !row.getKey().hasDepth() || row.getKey().getTopDepth() == null) {
                    return null;
                }
                return DepthUtils.convFromM((double)row.getKey().getTopDepth(), (char)this.units);
            }
            case 1: {
                if (row.getKey() == null || !row.getKey().hasDepth() || row.getKey().getBaseDepth() == null) {
                    return null;
                }
                return DepthUtils.convFromM((double)row.getKey().getBaseDepth(), (char)this.units);
            }
            case 2: {
                if (row.getKey() == null) {
                    return null;
                }
                return row.getKey().getLabel();
            }
            case 3: {
                if (row.getKey() == null) {
                    return null;
                }
                return row.getKey().getType();
            }
            case 4: {
                if (row.getKey() == null) {
                    return null;
                }
                return AgeUtils.convertFromMa((Double)row.getKey().getAge(), (AgeFormat)this.ageUnits);
            }
            case 5: {
                if (row.getKey() == null) {
                    return null;
                }
                return AgeUtils.convertFromMa((Float)row.getKey().getPositiveError(), (AgeFormat)this.ageUnits);
            }
            case 6: {
                if (row.getKey() == null) {
                    return null;
                }
                return AgeUtils.convertFromMa((Float)row.getKey().getNegativeError(), (AgeFormat)this.ageUnits);
            }
            case 7: {
                if (row.getKey() == null) {
                    return null;
                }
                return row.getKey().getIsotopeRatio();
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 9: 
            case 10: {
                return Double.class;
            }
            case 11: {
                return String.class;
            }
            case 12: {
                return SampleType.class;
            }
            case 8: {
                return Boolean.class;
            }
            case 0: 
            case 1: {
                return Double.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return SampleType.class;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return Double.class;
            }
        }
        return String.class;
    }
}

