/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.sampleage;

import javax.swing.JTextField;
import jsbugs.uiutil.TextFieldUtils;
import util.AgeFormat;

public class SampleAgeTextFieldBuilder {
    public static final double SAMPLE_AGE_MAX = 4600.0;
    static final double RATIO_MAX = 9.999999999999998E9;
    public static final int SAMPLE_AGE_PRECISION_MA = 6;
    public static final int SAMPLE_AGE_PRECISION_KA = 3;

    public static JTextField BuildSampleAgeTextField() {
        return SampleAgeTextFieldBuilder.BuildSampleAgeTextField(AgeFormat.MA);
    }

    public static JTextField BuildSampleAgeTextField(AgeFormat af) {
        return TextFieldUtils.buildDecimalOnlyTextField(false, 4600.0 * af.getMultiplyer(), SampleAgeTextFieldBuilder.getPrecision(af));
    }

    public static JTextField BuildSampleAgeErrorTextField() {
        return SampleAgeTextFieldBuilder.BuildSampleAgeErrorTextField(AgeFormat.MA);
    }

    public static JTextField BuildSampleAgeErrorTextField(AgeFormat af) {
        return TextFieldUtils.buildDecimalOnlyTextField(false, 4600.0 * af.getMultiplyer(), SampleAgeTextFieldBuilder.getPrecision(af));
    }

    public static JTextField BuildIsotopeRatioTextField() {
        return TextFieldUtils.buildDecimalOnlyTextField(true, 9.999999999999998E9, 6);
    }

    public static void UpdateTextFieldDocumentForSampleAge(JTextField tf, AgeFormat af) {
        tf.setDocument(TextFieldUtils.buildDecimalDocument(false, 4600.0 * af.getMultiplyer(), SampleAgeTextFieldBuilder.getPrecision(af)));
    }

    public static void UpdateTextFieldForSampleAge(JTextField tf, AgeFormat af) {
        TextFieldUtils.updateTextFieldToDecimalOnly(tf, false, 4600.0 * af.getMultiplyer(), SampleAgeTextFieldBuilder.getPrecision(af));
    }

    public static void UpdateTextFieldDocumentForSampleAgeError(JTextField tf, AgeFormat af) {
        tf.setDocument(TextFieldUtils.buildDecimalDocument(false, 4600.0 * af.getMultiplyer(), SampleAgeTextFieldBuilder.getPrecision(af)));
    }

    private static int getPrecision(AgeFormat af) {
        if (af == AgeFormat.KA) {
            return 3;
        }
        return 6;
    }
}

