/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.sampleage;

import com.stratadata.model3.well.sample.SampleProperties;
import com.stratadata.model3.well.sample.SampleType;
import util.NumberUtils;

public class SampleCreationRequest
implements SampleProperties {
    static final double DEPTH_MAX = 9.9999999999E7;
    static final int DEPTH_MAX_PRECISION = 3;
    private Double topDepth;
    private Double baseDepth;
    private String label;
    private SampleType type;

    public SampleCreationRequest(Double topDepth, Double baseDepth, String label, SampleType type) {
        if (topDepth == null && baseDepth == null) {
            throw new IllegalArgumentException("Top depth and base depth can't be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Sample type can't be null.");
        }
        this.topDepth = SampleCreationRequest.getDepthValue(topDepth);
        this.baseDepth = SampleCreationRequest.getDepthValue(baseDepth);
        this.label = label;
        this.type = type;
    }

    public static Double getDepthValue(Double value) {
        if (value == null) {
            return null;
        }
        if (Math.abs(value) > 9.9999999999E7) {
            return 9.9999999999E7 * Math.signum(value);
        }
        return NumberUtils.roundValue((Double)value, (int)3);
    }

    public Double getTopDepth() {
        return this.topDepth;
    }

    public Double getBaseDepth() {
        return this.baseDepth;
    }

    public String getLabel() {
        return this.label;
    }

    public SampleType getType() {
        return this.type;
    }

    public boolean hasDepth() {
        return this.baseDepth != null || this.topDepth != null;
    }
}

