/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.sampleage;

import com.stratadata.model3.well.sample.SampleProperties;
import org.apache.commons.lang3.StringUtils;

public class SamplePropsMatcher {
    private final double precision = 0.005;

    boolean match(SampleProperties a, SampleProperties b) {
        if (!a.hasDepth() && a.getLabel() == null) {
            return false;
        }
        if (!b.hasDepth() && b.getLabel() == null) {
            return false;
        }
        if (a.getType() != null && b.getType() != null && a.getType() != b.getType()) {
            return false;
        }
        boolean matching = true;
        boolean comparedOne = false;
        if (a.hasDepth() && b.hasDepth() && a.getTopDepth() != null && b.getTopDepth() != null) {
            matching = matching && this.compareDouble(a.getTopDepth(), b.getTopDepth());
            comparedOne = true;
        }
        if (a.hasDepth() && b.hasDepth() && a.getBaseDepth() != null && b.getBaseDepth() != null) {
            matching = matching && this.compareDouble(a.getBaseDepth(), b.getBaseDepth());
            comparedOne = true;
        }
        if (!StringUtils.isBlank((CharSequence)a.getLabel()) && !StringUtils.isBlank((CharSequence)b.getLabel())) {
            matching = matching && a.getLabel().equals(b.getLabel());
            comparedOne = true;
        }
        if (comparedOne) {
            return matching;
        }
        return false;
    }

    private boolean compareDouble(Double a, Double b) {
        Double diff = a - b;
        return Math.abs(diff) < 0.005;
    }
}

