/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.sampleage;

import com.stratadata.model3.well.sample.SampleType;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jsbugs.sampleage.SampleAgeCreationRecord;
import jsbugs.sampleage.SampleAgeUpdateRecord;
import util.AgeFormat;
import util.AgeUtils;
import util.DepthUnits;
import util.DepthUtils;

class SampleUpdatesTableModel
extends AbstractTableModel {
    private char units = (char)77;
    private final AgeFormat ageUnits;
    static String[] colTitles = new String[]{"Top Depth", "Base Depth", "Label", "Type", "Age", "+ve Error", "-ve Error", "Isotope Ratio"};
    static int[] colWidth = new int[]{20, 20, 20, 20, 20, 20, 20, 20};
    static final int COL_TOP_DEPTH = 0;
    static final int COL_BASE_DEPTH = 1;
    static final int COL_LABEL = 2;
    static final int COL_TYPE = 3;
    static final int COL_AGE = 4;
    static final int COL_POSITIVE_ERROR = 5;
    static final int COL_NEGATIVE_ERROR = 6;
    static final int COL_ISOTOPE_RATIO = 7;
    private List<SampleAgeUpdateRecord> updateReocrds;
    private List<SampleAgeCreationRecord> creationRecords;

    public SampleUpdatesTableModel(List<SampleAgeCreationRecord> creationRecords, List<SampleAgeUpdateRecord> records, char units, AgeFormat ageUnits) {
        this.creationRecords = creationRecords;
        this.updateReocrds = records;
        this.units = units;
        this.ageUnits = ageUnits;
    }

    public boolean hasValueChanged(int rowIndex, int columnIndex) {
        boolean changed = false;
        Object record = this.getRowObject(rowIndex);
        if (record instanceof SampleAgeCreationRecord) {
            SampleAgeCreationRecord row = (SampleAgeCreationRecord)record;
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    changed = true;
                    break;
                }
                case 4: {
                    changed = row.getAge() != null;
                    break;
                }
                case 5: {
                    changed = row.getPositiveError() != null;
                    break;
                }
                case 6: {
                    changed = row.getNegativeError() != null;
                    break;
                }
                case 7: {
                    changed = row.getIsotopeRatio() != null;
                    break;
                }
            }
        } else if (record instanceof SampleAgeUpdateRecord) {
            SampleAgeUpdateRecord row = (SampleAgeUpdateRecord)record;
            switch (columnIndex) {
                case 4: {
                    changed = row.getAge() != null;
                    break;
                }
                case 5: {
                    changed = row.getPositiveError() != null;
                    break;
                }
                case 6: {
                    changed = row.getNegativeError() != null;
                    break;
                }
                case 7: {
                    changed = row.getIsotopeRatio() != null;
                    break;
                }
            }
        }
        return changed;
    }

    private Object getRowObject(int i) {
        if (i < this.creationRecords.size()) {
            return this.creationRecords.get(i);
        }
        return this.updateReocrds.get(i - this.creationRecords.size());
    }

    @Override
    public int getRowCount() {
        int updateRecCount = this.updateReocrds == null ? 0 : this.updateReocrds.size();
        int creationRecCount = this.creationRecords == null ? 0 : this.creationRecords.size();
        return updateRecCount + creationRecCount;
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0 || column == 1) {
            return colTitles[column] + " (" + DepthUnits.getUnits((char)this.units).getAbr() + ")";
        }
        if (column == 4 || column == 6 || column == 5) {
            return colTitles[column] + " (" + this.ageUnits.getDescr() + ")";
        }
        return colTitles[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object rowObject = this.getRowObject(rowIndex);
        if (rowObject == null) {
            return null;
        }
        Object props = null;
        Double age = null;
        Double ratio = null;
        Float positiveError = null;
        Float negativeError = null;
        if (rowObject instanceof SampleAgeCreationRecord) {
            SampleAgeCreationRecord creationRecord = (SampleAgeCreationRecord)rowObject;
            props = creationRecord.getSampleToCreate();
            age = creationRecord.getAge();
            ratio = creationRecord.getIsotopeRatio();
            positiveError = creationRecord.getPositiveError();
            negativeError = creationRecord.getNegativeError();
        } else if (rowObject instanceof SampleAgeUpdateRecord) {
            SampleAgeUpdateRecord updateRecord = (SampleAgeUpdateRecord)rowObject;
            props = updateRecord.getSapmleToUpdate();
            age = updateRecord.getAge();
            ratio = updateRecord.getIsotopeRatio();
            positiveError = updateRecord.getPositiveError();
            negativeError = updateRecord.getNegativeError();
        }
        switch (columnIndex) {
            case 0: {
                if (props == null || !props.hasDepth() || props.getTopDepth() == null) {
                    return null;
                }
                return DepthUtils.convFromM((double)props.getTopDepth(), (char)this.units);
            }
            case 1: {
                if (props == null || !props.hasDepth() || props.getBaseDepth() == null) {
                    return null;
                }
                return DepthUtils.convFromM((double)props.getBaseDepth(), (char)this.units);
            }
            case 2: {
                if (props == null) {
                    return null;
                }
                return props.getLabel();
            }
            case 3: {
                if (props == null) {
                    return null;
                }
                return props.getType();
            }
            case 4: {
                return AgeUtils.convertFromMa((Double)age, (AgeFormat)this.ageUnits);
            }
            case 5: {
                return AgeUtils.convertFromMa(positiveError, (AgeFormat)this.ageUnits);
            }
            case 6: {
                return AgeUtils.convertFromMa(negativeError, (AgeFormat)this.ageUnits);
            }
            case 7: {
                return ratio;
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return Double.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return SampleType.class;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return Double.class;
            }
        }
        return String.class;
    }
}

