/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.samplesandinterps;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jsbugs.table.AnalysisTaxonTotal;
import jsbugs.uiutil.UIColours;
import org.apache.commons.lang3.StringUtils;

public class TaxonTotalCellRenderer
extends DefaultTableCellRenderer {
    public TaxonTotalCellRenderer() {
        this.setHorizontalAlignment(4);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
            return;
        }
        if (value instanceof AnalysisTaxonTotal) {
            AnalysisTaxonTotal total = (AnalysisTaxonTotal)value;
            this.setText(total.getTotalStringValue());
        } else {
            this.setText(StringUtils.stripToEmpty((String)value.toString()));
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cellComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!table.getModel().isCellEditable(row, column)) {
            if (isSelected) {
                cellComponent.setBackground(table.getSelectionBackground());
                cellComponent.setForeground(table.getSelectionForeground());
            } else {
                cellComponent.setBackground(table.getBackground());
                cellComponent.setForeground(table.getForeground());
            }
        } else {
            if (!isSelected) {
                cellComponent.setBackground(UIColours.EDITABLE_CELL_BACKGROUND);
                cellComponent.setForeground(table.getForeground());
            } else if (isSelected) {
                cellComponent.setBackground(UIColours.EDITABLE_CELL_BACKGROUND);
                cellComponent.setForeground(table.getForeground());
                if (cellComponent instanceof JComponent) {
                    JComponent jComponent = (JComponent)cellComponent;
                    CompoundBorder b = BorderFactory.createCompoundBorder();
                    if (jComponent.getBorder() instanceof EmptyBorder) {
                        b = BorderFactory.createCompoundBorder(b, BorderFactory.createMatteBorder(2, 0, 2, 0, table.getSelectionBackground()));
                    } else {
                        b = BorderFactory.createCompoundBorder(b, jComponent.getBorder());
                        b = BorderFactory.createCompoundBorder(b, BorderFactory.createMatteBorder(1, 0, 1, 0, table.getSelectionBackground()));
                    }
                    jComponent.setBorder(b);
                }
            }
            if (value instanceof AnalysisTaxonTotal) {
                AnalysisTaxonTotal total = (AnalysisTaxonTotal)value;
                if (total.isSingleOccurrence() || total.isEmptyOccurrences()) {
                    cellComponent.setForeground(Color.BLACK);
                } else {
                    cellComponent.setForeground(Color.BLUE);
                }
            } else {
                cellComponent.setForeground(table.getForeground());
            }
        }
        return cellComponent;
    }
}

