/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.samplesandinterps.taxonoccurrences;

import com.stratadata.model3.well.analysis.Situation;
import model3.TaxonOcc;
import model3.TaxonOccCountUpdate;
import org.apache.commons.lang3.StringUtils;

public class TaxonOccurrencesTableRow {
    boolean marker;
    Situation situation;
    boolean questionable;
    String subjective;
    Integer coarse;
    Integer medium;
    Integer fine;
    int specType;
    String specTypeString;

    public TaxonOccurrencesTableRow(Situation situation, boolean questionable, boolean marker, String subjective, Integer coarse, Integer medium, Integer fine, int specType, String specTypeString) {
        this.situation = situation;
        this.questionable = questionable;
        this.marker = marker;
        this.subjective = subjective;
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
        this.specType = specType;
        this.specTypeString = specTypeString;
        if (!StringUtils.isBlank((CharSequence)subjective)) {
            this.medium = null;
        }
        if (coarse == 0) {
            this.coarse = null;
        }
        if (fine == 0) {
            this.fine = null;
        }
    }

    boolean isDeleted() {
        return !this.hasSubjCount() && this.coarse == null && this.medium == null && this.fine == null;
    }

    boolean hasChanged(TaxonOcc occ) {
        if (occ.getSubAbund() != null && !occ.getSubAbund().isEmpty()) {
            if (!this.hasSubjCount()) {
                return true;
            }
            return !occ.getSubAbund().equals(this.subjective);
        }
        if (this.hasSubjCount()) {
            return true;
        }
        return this.getCoarseCount() != occ.getCoarse() || this.getMediumCount() != occ.getMedium() || this.getFineCount() != occ.getFine();
    }

    TaxonOccCountUpdate buildCountUpdate(TaxonOcc occ) {
        return new TaxonOccCountUpdate(occ, this.getCoarseCount(), this.getMediumCount(), this.getFineCount(), this.getSubOcc());
    }

    private boolean hasSubjCount() {
        return this.subjective != null && !this.subjective.trim().isEmpty();
    }

    private int getCoarseCount() {
        return this.coarse == null ? 0 : this.coarse;
    }

    private int getMediumCount() {
        return this.medium == null ? 0 : this.medium;
    }

    private int getFineCount() {
        return this.fine == null ? 0 : this.fine;
    }

    private String getSubOcc() {
        if (this.subjective == null || this.subjective.isEmpty()) {
            return null;
        }
        if ("+".equals(this.subjective)) {
            return null;
        }
        return this.subjective;
    }
}

