/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.EventType;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jsbchart.correlation.Correlation;
import jsbugs.table.TableCellUtils;
import model3.Category;
import model3.WellEvent;

public class ButtonRenderer
extends DefaultTableCellRenderer {
    private final JPanel panel = new JPanel();
    private final JButton button;
    private String nullString;
    private final JButton clearButton;
    private boolean canClear = false;

    public ButtonRenderer() {
        this((String)null);
    }

    public ButtonRenderer(String nullString) {
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.button = new JButton("...");
        this.clearButton = new JButton(TableCellUtils.getIcon("closeTab.png"));
        TableCellUtils.setButtonDimensions(this.button, this.clearButton);
        this.nullString = nullString;
    }

    JLabel getSuperLabel(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    private String getNullText() {
        if (this.nullString != null) {
            return this.nullString;
        }
        if (this.canClear) {
            return "";
        }
        return "all";
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel oLabel = this.getSuperLabel(table, value, isSelected, hasFocus, row, column);
        this.panel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        if (value == null) {
            oLabel.setText(this.getNullText());
        } else if (value instanceof Collection) {
            label = "";
            Iterator iterator = ((Collection)value).iterator();
            while (iterator.hasNext()) {
                Object o;
                if (!((String)label).isEmpty()) {
                    label = (String)label + ", ";
                }
                if ((o = iterator.next()) instanceof Discipline) {
                    label = (String)label + ((Discipline)o).getAbr(false);
                    continue;
                }
                if (o instanceof EventType) {
                    label = (String)label + WellEvent.getType((EventType)o);
                    continue;
                }
                label = (String)label + (o == null ? "none" : o.toString());
            }
            oLabel.setText((String)label);
        } else if (value.getClass() == Category[].class) {
            Category[] cats;
            label = "";
            for (Category cat : cats = (Category[])value) {
                if (!((String)label).isEmpty()) {
                    label = (String)label + ", ";
                }
                label = (String)label + cat.getMnem();
            }
            oLabel.setText((String)label);
        } else if (value instanceof Correlation) {
            oLabel.setText(((Correlation)value).toDatumString());
        } else {
            oLabel.setText(value.toString());
        }
        oLabel.setBorder(new CompoundBorder(new LineBorder(oLabel.getBackground()), TableCellUtils.getEmptyBorder()));
        Dimension d = new Dimension(table.getColumnModel().getColumn(column).getWidth() - this.button.getPreferredSize().width * (this.canClear ? 2 : 1) - 1, 100);
        oLabel.setPreferredSize(d);
        this.panel.removeAll();
        this.panel.add(oLabel);
        this.panel.add(Box.createHorizontalGlue());
        this.panel.add(this.button);
        if (this.canClear && value != null) {
            this.panel.add(this.clearButton);
        }
        return this.panel;
    }

    public void canClear(boolean b) {
        this.canClear = b;
    }

    public boolean canClear() {
        return this.canClear;
    }

    JButton getButton() {
        return this.button;
    }

    JButton getClearButton() {
        return this.clearButton;
    }

    JPanel getPanel() {
        return this.panel;
    }
}

