/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JTable;
import jsbchart.block.BlockType;
import jsbugs.DialogChartBlockImport;
import jsbugs.DialogSelectProjectWellList;
import jsbugs.table.AllowNullEditor;
import jsbugs.table.ButtonEditor;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.wellheader.DialogSelectWell;
import model3.SBdb;
import model3.Well;
import model3.project.Project;
import model3.project.WellList;

public class ChartBlockWellEditor
extends ButtonEditor
implements AllowNullEditor {
    private final Frame parent;
    private final SBdb sbdb;
    private Object well;
    private BlockType blockType;
    private Project chartProject;
    private WellList chartDefaultWellList;
    private static final Object NULL_WELL = new Object();

    public ChartBlockWellEditor(Frame parent, SBdb sbdb) {
        this.parent = parent;
        this.sbdb = sbdb;
    }

    @Override
    public Object getCellEditorValue() {
        return this.well;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.renderer.getButton()) {
            Object o = null;
            switch (this.blockType) {
                case WELL: {
                    DialogSelectWell dialog = new DialogSelectWell(this.parent, true, this.sbdb, false);
                    dialog.setLocationRelativeTo(this.renderer);
                    dialog.setVisible(true);
                    o = dialog.getSelected();
                    break;
                }
                case PROJECT: {
                    try {
                        DialogSelectProjectWellList d = new DialogSelectProjectWellList((Window)this.parent, this.sbdb, this.chartProject, null);
                        d.setLocationRelativeTo(this.renderer);
                        d.setVisible(true);
                        o = d.getSelection();
                    }
                    catch (RuntimeException sql) {
                        SbugsExceptionHandler.showDialogStackError(sql, this.parent);
                    }
                    break;
                }
                default: {
                    DialogChartBlockImport diag = new DialogChartBlockImport(this.parent, true, this.sbdb, this.blockType, this.chartProject, this.chartDefaultWellList, false);
                    diag.setLocationRelativeTo(this.renderer);
                    diag.setVisible(true);
                    o = diag.getObject();
                    if (o != null) break;
                    o = NULL_WELL;
                }
            }
            if (o != null) {
                if (o == NULL_WELL) {
                    o = null;
                }
                this.well = o;
                this.fireEditingStopped();
            } else {
                this.fireEditingCanceled();
            }
        } else if (e.getSource() == this.renderer.getClearButton()) {
            this.well = null;
            this.fireEditingStopped();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        assert (value == null || value instanceof Well || value instanceof WellList);
        this.well = value;
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
    }

    @Override
    public void allowNullValue(boolean canClear) {
        this.renderer.canClear(canClear);
    }

    public void setBlockType(BlockType blockType, Project chartProject, WellList chartDefaultWellList) {
        this.blockType = blockType;
        this.chartProject = chartProject;
        this.chartDefaultWellList = chartDefaultWellList;
    }
}

