/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JColorChooser;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import jsbugs.table.AllowNullEditor;
import jsbugs.table.ColourButtonRenderer;

public class ColourChooserEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
AllowNullEditor {
    private final ColourButtonRenderer renderer;
    private Color colour;
    private boolean isInit = false;
    private boolean displaySelected = false;

    public ColourChooserEditor() {
        this(false);
    }

    public ColourChooserEditor(boolean canClear) {
        this.renderer = new ColourButtonRenderer(canClear);
    }

    private void init() {
        this.renderer.getButton().addActionListener(this);
        this.renderer.getClearButton().addActionListener(this);
        this.isInit = true;
    }

    public void setDisplaySelected(boolean value) {
        this.displaySelected = value;
    }

    @Override
    public Object getCellEditorValue() {
        return this.colour;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.colour = (Color)value;
        if (!this.isInit) {
            this.init();
        }
        boolean selected = isSelected;
        if (this.displaySelected) {
            selected = true;
        }
        return this.renderer.getTableCellRendererComponent(table, value, selected, isSelected, row, column);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isInit) {
            this.init();
        }
        if (e.getSource() == this.renderer.getButton()) {
            Color c = JColorChooser.showDialog(this.renderer, "Colour : Select", this.colour);
            if (c != null && !c.equals(this.colour)) {
                this.colour = c;
                this.fireEditingStopped();
            } else {
                this.fireEditingCanceled();
            }
        } else if (e.getSource() == this.renderer.getClearButton()) {
            this.colour = null;
            this.fireEditingStopped();
        }
    }

    @Override
    public void allowNullValue(boolean allowNull) {
        this.renderer.canClear(allowNull);
    }

    public void setRendererNullString(String nullString) {
        this.renderer.setNullString(nullString);
    }
}

