/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jsbugs.table.AbledRenderer;
import jsbugs.table.TableCellUtils;

public class ComboRenderer
extends DefaultTableCellRenderer
implements AbledRenderer {
    private final JPanel panel = new JPanel();
    private final JButton button;
    private boolean enabled = true;
    private final String NULL_STRING;
    private final Color backgroundColor;

    public ComboRenderer() {
        this((String)null);
    }

    public ComboRenderer(String nullString) {
        this(nullString, null);
    }

    public ComboRenderer(String nullString, Color backgroundColor) {
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        JComboBox box = new JComboBox();
        box.setEditable(true);
        this.button = (JButton)box.getComponent(0);
        this.button.setPreferredSize(new Dimension(15, 10));
        this.button.setMaximumSize(new Dimension(15, 100));
        this.button.setBorderPainted(false);
        this.button.setContentAreaFilled(false);
        this.NULL_STRING = nullString;
        this.backgroundColor = backgroundColor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel oLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null && this.NULL_STRING != null) {
            oLabel.setText(this.NULL_STRING);
        }
        oLabel.setBorder(new CompoundBorder(new LineBorder(oLabel.getBackground()), TableCellUtils.getEmptyBorder()));
        oLabel.setBorder(TableCellUtils.getEmptyBorder());
        Dimension d = new Dimension(table.getColumnModel().getColumn(column).getWidth() - this.button.getPreferredSize().width, 100);
        oLabel.setPreferredSize(d);
        oLabel.setMinimumSize(new Dimension(5, 5));
        oLabel.setOpaque(false);
        this.panel.removeAll();
        this.panel.add(oLabel);
        this.panel.setBackground(isSelected ? table.getSelectionBackground() : (this.backgroundColor == null ? table.getBackground() : this.backgroundColor));
        this.panel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        this.panel.add(Box.createHorizontalGlue());
        this.panel.add(this.button);
        this.button.setEnabled(this.enabled);
        return this.panel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

