/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import javax.swing.JComboBox;
import jsbugs.table.AllowNullEditor;
import jsbugs.table.ComboEditor;

public class EnumEditor
extends ComboEditor
implements AllowNullEditor {
    private final String nullValue;
    private final JComboBox combo;

    public EnumEditor(JComboBox combo, Class<? extends Enum> c, String nullValue) {
        super(combo);
        this.nullValue = nullValue;
        this.combo = combo;
        this.init(c);
    }

    private void init(Class<? extends Enum> c) {
        Enum[] enumConstants;
        if (this.nullValue != null) {
            this.combo.addItem(this.nullValue);
        }
        for (Enum e : enumConstants = c.getEnumConstants()) {
            this.combo.addItem(e);
        }
        this.combo.setFocusable(false);
        this.combo.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        if (enumConstants.length < 12) {
            this.combo.setMaximumRowCount(enumConstants.length + (this.nullValue != null ? 1 : 0));
        }
    }

    @Override
    public Object getCellEditorValue() {
        Object o = ((JComboBox)this.getComponent()).getSelectedItem();
        if (o instanceof String) {
            return null;
        }
        return o;
    }

    @Override
    public void allowNullValue(boolean allowNull) {
        if (allowNull) {
            if (this.nullValue != null && !this.hasNullValue()) {
                this.combo.addItem(this.nullValue);
            }
        } else if (this.hasNullValue()) {
            this.combo.removeItem(this.nullValue);
        }
    }

    private boolean hasNullValue() {
        if (this.nullValue == null) {
            return false;
        }
        for (int i = 0; i < this.combo.getItemCount(); ++i) {
            if (this.combo.getModel().getElementAt(i) != this.nullValue) continue;
            return true;
        }
        return false;
    }
}

