/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import jsbugs.table.ButtonEditor;

public class FileChooserEditor
extends ButtonEditor
implements TableCellEditor,
ActionListener {
    private File file;
    private boolean isInit = false;

    private void init() {
        this.isInit = true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.file;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.file = (File)value;
        if (!this.isInit) {
            this.init();
        }
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isInit) {
            this.init();
        }
        if (e.getSource() == this.renderer.getButton()) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            fc.setSelectedFile(this.file);
            int retval = fc.showOpenDialog(this.renderer);
            if (retval == 0 && !fc.getSelectedFile().equals(this.file)) {
                this.file = fc.getSelectedFile();
                this.fireEditingStopped();
            } else {
                this.fireEditingCanceled();
            }
        } else if (e.getSource() == this.renderer.getClearButton()) {
            this.fireEditingStopped();
        }
    }
}

