/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.util.Objects;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import jsbugs.table.TableCellUtils;
import jsbugs.table.VerifiedNumberEditor;

public class IntegerEditor
extends VerifiedNumberEditor {
    public IntegerEditor(final boolean allowNegitive) {
        this.setVerifier(new InputVerifier(this){
            final /* synthetic */ IntegerEditor this$0;
            {
                IntegerEditor integerEditor = this$0;
                Objects.requireNonNull(integerEditor);
                this.this$0 = integerEditor;
            }

            @Override
            public boolean verify(JComponent input) {
                boolean verified = true;
                String text = ((JTextField)input).getText();
                try {
                    Integer i = Integer.valueOf(text);
                    if (!allowNegitive && i < 0) {
                        verified = false;
                    }
                }
                catch (NumberFormatException e) {
                    verified = false;
                }
                this.this$0.setFieldBorder(verified);
                return verified;
            }
        });
    }

    public IntegerEditor(final int min, final int max) {
        this.setVerifier(new InputVerifier(this){
            final /* synthetic */ IntegerEditor this$0;
            {
                IntegerEditor integerEditor = this$0;
                Objects.requireNonNull(integerEditor);
                this.this$0 = integerEditor;
            }

            @Override
            public boolean verify(JComponent input) {
                boolean verified = true;
                String text = ((JTextField)input).getText();
                try {
                    Integer i = Integer.valueOf(text);
                    if (i < min || i > max) {
                        verified = false;
                    }
                }
                catch (NumberFormatException e) {
                    verified = false;
                }
                this.this$0.setFieldBorder(verified);
                return verified;
            }
        });
    }

    private void setFieldBorder(boolean verified) {
        JTextField field = (JTextField)this.editorComponent;
        field.setBorder(new CompoundBorder(new LineBorder(verified ? field.getBackground() : Color.RED), TableCellUtils.getEmptyBorder()));
    }
}

