/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import jsbugs.table.AllowNullEditor;
import jsbugs.table.ComboEditor;
import jsbugs.uiutil.ComboboxItem;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.InterpHdr;
import model3.SBdb;

public class InterpEditor
extends ComboEditor
implements AllowNullEditor {
    public static final String INHERIT = "Inherited";
    private final SBdb sbdb;

    public InterpEditor(SBdb sbdb) {
        super(new JComboBox());
        this.sbdb = sbdb;
        this.addDefaultValues(null);
    }

    private void addDefaultValues(Collection<InterpHdr> restriction) {
        JComboBox combo = (JComboBox)this.editorComponent;
        combo.removeAllItems();
        this.addComboItem(INHERIT, null);
        try {
            List<InterpHdr> interps = this.sbdb.getInterps();
            Collections.sort(interps);
            for (InterpHdr hdr : interps) {
                if (restriction != null && !restriction.contains(hdr)) continue;
                this.addComboItem(hdr.toString(), hdr);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    @Override
    public void allowNullValue(boolean includeNull) {
        if (includeNull) {
            if (this.getValueAt(0) != null) {
                this.insertComboItemAt(0, INHERIT, null);
            }
        } else if (this.getValueAt(0) == null) {
            ((JComboBox)this.editorComponent).removeItemAt(0);
        }
    }

    public void restrictCombo(Collection<InterpHdr> hdrs) {
        this.addDefaultValues(hdrs);
    }

    @Override
    public Object getCellEditorValue() {
        InterpHdr hdr = this.getSelectedValue();
        if (hdr == null) {
            return null;
        }
        return hdr.getInterpID();
    }

    private InterpHdr getSelectedValue() {
        JComboBox combo = (JComboBox)this.editorComponent;
        return this.getValueAt(combo.getSelectedIndex());
    }

    private InterpHdr getValueAt(int index) {
        JComboBox combo = (JComboBox)this.editorComponent;
        ComboboxItem item = (ComboboxItem)combo.getItemAt(index);
        return (InterpHdr)item.getValue();
    }

    private void addComboItem(String label, InterpHdr value) {
        JComboBox combo = (JComboBox)this.editorComponent;
        combo.addItem(new ComboboxItem<InterpHdr>(value, label));
    }

    private void insertComboItemAt(int index, String label, InterpHdr value) {
        JComboBox combo = (JComboBox)this.editorComponent;
        combo.insertItemAt(new ComboboxItem<InterpHdr>(value, label), index);
    }
}

