/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import jsbchart.graphics.FillPainter;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.SBGraphicsConverter;
import jsbchart.graphics.text.MapFill;

public class MapFillButtonRenderer
extends JPanel
implements TableCellRenderer {
    private final FillPainter painter = new FillPainter();
    private final JButton button = new JButton("...");
    MapFill fill = null;

    public MapFillButtonRenderer() {
        this.button.setMaximumSize(new Dimension(17, 17));
        this.button.setMinimumSize(new Dimension(17, 17));
        this.button.setPreferredSize(new Dimension(17, 17));
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.setOpaque(false);
        p.add(this.button);
        this.add((Component)p, "East");
    }

    public JButton getButton() {
        return this.button;
    }

    public void setFill(MapFill fill) {
        this.fill = fill;
    }

    public MapFill getFill() {
        return this.fill;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof MapFill) {
            this.fill = (MapFill)value;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle bounds = g.getClipBounds();
        if (this.fill == null) {
            g.setColor(Color.white);
            g.fillRect(0, 0, bounds.width, bounds.height);
            g.setColor(Color.red);
            g.drawLine(0, 0, bounds.width, bounds.height);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            SBGraphicsConverter converter = new SBGraphicsConverter(0.028346456587314606);
            AffineTransform saveTransform = g2d.getTransform();
            g2d.transform(AffineTransform.getScaleInstance(converter.getTransformFactor(), converter.getTransformFactor()));
            try {
                SBGraphics sg = new SBGraphics(g2d, null, true, true);
                Rectangle2D.Float area = converter.makeRectFromPixels(bounds.width, bounds.height);
                this.painter.paintFill(sg, this.fill, area);
            }
            finally {
                g2d.setTransform(saveTransform);
            }
        }
        this.setOpaque(false);
    }
}

