/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jsbugs.table.TableCellUtils;

public class NullableRenderer
extends DefaultTableCellRenderer {
    private final JPanel panel = new JPanel();
    final JButton button;
    private final String nullString;

    public NullableRenderer(String nullString) {
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.button = new JButton(TableCellUtils.getIcon("closeTab.png"));
        TableCellUtils.setButtonDimensions(this.button);
        this.panel.add(this.button);
        if (nullString == null) {
            nullString = "";
        }
        this.nullString = nullString;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel oLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.panel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        if (value == null) {
            oLabel.setText(this.nullString);
        } else {
            oLabel.setText(value.toString());
        }
        oLabel.setBorder(new CompoundBorder(new LineBorder(oLabel.getBackground()), TableCellUtils.getEmptyBorder()));
        Dimension d = new Dimension(table.getColumnModel().getColumn(column).getWidth() - this.button.getPreferredSize().width - 1, 100);
        oLabel.setPreferredSize(d);
        this.panel.removeAll();
        this.panel.add(oLabel);
        this.panel.add(Box.createHorizontalGlue());
        this.panel.add(this.button);
        return this.panel;
    }
}

