/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;

public class RolloverMouseAdapter
extends MouseAdapter {
    private int row = -1;
    private int column = -1;
    private final JTable table;

    public RolloverMouseAdapter(JTable table) {
        this.table = table;
    }

    public boolean isRolloverCell(int row, int column) {
        return this.row == row && this.column == column;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int lastRow = this.row;
        int lastColumn = this.column;
        this.row = this.table.rowAtPoint(e.getPoint());
        this.column = this.table.columnAtPoint(e.getPoint());
        if (this.row == lastRow && this.column == lastColumn) {
            return;
        }
        if (this.row >= 0 && this.column >= 0) {
            this.table.repaint(this.table.getCellRect(this.row, this.column, false));
        }
        if (lastRow >= 0 && lastColumn >= 0) {
            this.table.repaint(this.table.getCellRect(lastRow, lastColumn, false));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.row >= 0 && this.column >= 0) {
            this.table.repaint(this.table.getCellRect(this.row, this.column, false));
        }
        this.column = -1;
        this.row = -1;
    }
}

