/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.StringUtils;

public class SimpleTableModel
extends AbstractTableModel {
    private Object[][] data;
    private String[] headings = null;
    private int rowCount;
    private int colCount;

    public SimpleTableModel(Object[][] data, String[] headings) {
        this.data = data;
        this.headings = headings;
        this.setupCounts();
    }

    public SimpleTableModel(Object[][] data) {
        this.data = data;
        this.setupCounts();
    }

    private void setupCounts() {
        this.rowCount = this.data.length;
        int columnCount = -1;
        for (Object[] row : this.data) {
            if (row.length <= columnCount) continue;
            columnCount = row.length;
        }
        this.colCount = columnCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.colCount;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row >= this.rowCount) {
            return null;
        }
        if (column >= this.data[row].length) {
            return null;
        }
        return this.data[row][column];
    }

    @Override
    public String getColumnName(int column) {
        if (column >= this.colCount) {
            return null;
        }
        String heading = null;
        if (this.headings != null && column < this.headings.length) {
            heading = this.headings[column];
        }
        if (StringUtils.isBlank(heading)) {
            heading = Integer.toString(column + 1);
        }
        return heading;
    }
}

