/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.model3.well.analysis.SpeciesTypeService;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JTable;
import jsbugs.table.CollectionEditor;
import model3.exception.SuppressedSQLException;

public class SpecTypeCollectionEditor
extends CollectionEditor {
    private final SpeciesTypeService speciesTypeService;

    public SpecTypeCollectionEditor(JFrame frame, SpeciesTypeService speciesTypeService) {
        super(frame);
        this.speciesTypeService = speciesTypeService;
    }

    @Override
    Object[] getFullList() {
        try {
            return this.speciesTypeService.getAllSpeciesTypes().stream().map(SpeciesType::description).toArray();
        }
        catch (SuppressedSQLException ex) {
            return null;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value != null) {
            this.collection = new HashSet();
            for (Object o : (Collection)value) {
                try {
                    this.collection.add(this.speciesTypeService.getSpeciesType(((Integer)o).intValue()).get());
                }
                catch (SuppressedSQLException sql) {
                    sql.printStackTrace();
                    this.collection.add(o);
                }
            }
        }
        return this.renderer.getTableCellRendererComponent(table, this.collection, isSelected, isSelected, row, column);
    }

    @Override
    String getSelectionType() {
        return "sub-types";
    }

    @Override
    boolean allowNone() {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        HashSet<Integer> specTypes = new HashSet<Integer>();
        if (this.collection != null) {
            try {
                for (Object o : this.collection) {
                    int id = this.speciesTypeService.findSpeciesType(o.toString()).map(SpeciesType::specTypeID).orElse(0);
                    specTypes.add(id);
                }
            }
            catch (SuppressedSQLException e) {
                e.printStackTrace();
            }
        }
        if (specTypes.isEmpty()) {
            return null;
        }
        return specTypes;
    }
}

