/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class TableRowHeader {
    public static void addTableRowHeader(JScrollPane panel, final JTable table) {
        final AbstractTableModel model = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int row, int column) {
                return table.convertRowIndexToModel(row) + 1;
            }

            @Override
            public int getRowCount() {
                return table.getRowCount();
            }
        };
        JTable headerTable = new JTable(model);
        headerTable.setRowHeight(table.getRowHeight());
        headerTable.setShowGrid(true);
        headerTable.setGridColor(table.getGridColor());
        headerTable.setAutoResizeMode(0);
        headerTable.setPreferredScrollableViewportSize(new Dimension(30, 0));
        headerTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        headerTable.getColumnModel().getColumn(0).setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable x, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                boolean selected = table.getSelectionModel().isSelectedIndex(row);
                Component component = table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value, false, false, -1, -2);
                ((JLabel)component).setHorizontalAlignment(0);
                if (selected) {
                    component.setFont(component.getFont().deriveFont(1));
                } else {
                    component.setFont(component.getFont().deriveFont(0));
                }
                component.setBackground(Color.white);
                return component;
            }
        });
        if (table.getRowSorter() != null) {
            table.getRowSorter().addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent e) {
                    model.fireTableDataChanged();
                }
            });
        }
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                model.fireTableRowsUpdated(0, model.getRowCount() - 1);
            }
        });
        panel.setRowHeaderView(headerTable);
    }
}

