/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.taxa;

import com.stratadata.model3.Discipline;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import com.stratadata.util.ui.DialogBase;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import jsbugs.sbdb.ProjectUtils;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.LithostratUnit;
import model3.SBdb;
import model3.Taxon;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.project.Project;
import net.miginfocom.swing.MigLayout;
import util.SB;
import util.SBException;

public class DialogSelectTaxaAdv
extends DialogBase {
    static final int DEPTHLEN = 5;
    private static final String NONITEM = "<none>";
    SBdb db;
    DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private static IGDScheme lastScheme = null;
    private static IGDUnitBase lastUnit = null;
    private final List<Taxon> selection = new ArrayList<Taxon>();
    private JLabel jLabel1;
    private JComboBox<Object> jComboBoxGroup;
    private JLabel jLabel3;
    private JComboBox<Object> jComboBoxExcludeSet;
    private JLabel jLabel2;
    private JComboBox jComboBoxProject;
    private JPanel jPanel1;
    private JCheckBox jCheckBoxMacrofaunal;
    private JCheckBox jCheckBoxMicrofaunal;
    private JCheckBox jCheckBoxNannofloral;
    private JCheckBox jCheckBoxPalynofloral;
    private JTextField jTextFieldAbundance;
    private JScrollPane scrollPane1;
    private JTextArea jTextAreaSQL;
    private JLabel jLabel6;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonRestrictDepths;
    private JRadioButton jRadioButtonRestrictZone;
    private JTextField jTextFieldDepth1;
    private JLabel jLabel4;
    private JTextField jTextFieldDepth2;
    private JComboBox<DepthUnits> jComboBoxUnits;
    private JComboBox<IGDScheme> jComboBoxScheme;
    private JComboBox<Object> jComboBoxUnit;
    private JRadioButton jRadioButtonNoRestriction;
    private JLabel jLabel7;
    private ButtonGroup buttonGroupWellRestriction;

    public DialogSelectTaxaAdv(Frame parent, SBdb db) throws SQLException {
        super((Window)parent);
        this.setTitle("Search Taxon Dictionary");
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.jComboBoxGroup.removeAllItems();
        this.jComboBoxGroup.addItem(NONITEM);
        for (TxGroup group : this.db.getTxGroups()) {
            this.jComboBoxGroup.addItem(group);
        }
        this.jComboBoxExcludeSet.removeAllItems();
        this.jComboBoxExcludeSet.addItem(NONITEM);
        for (TxGroupSet set : this.db.getTxGroupSets()) {
            this.jComboBoxExcludeSet.addItem(set);
        }
        ProjectUtils.loadProjectCombo(this.db, this.projectModel, true);
        this.addOkButtonActionListener(this::jButtonOKActionPerformed);
        this.initSchemes();
        this.jComboBoxUnits.addItem(DepthUnits.M);
        this.jComboBoxUnits.addItem(DepthUnits.F);
        this.setUnitEnabled(false);
        this.setDepthsEnabled(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBoxGroup = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jComboBoxExcludeSet = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jCheckBoxMacrofaunal = new JCheckBox();
        this.jCheckBoxMicrofaunal = new JCheckBox();
        this.jCheckBoxNannofloral = new JCheckBox();
        this.jCheckBoxPalynofloral = new JCheckBox();
        this.jTextFieldAbundance = TextFieldUtils.buildIntegerOnlyTextField(false, 9999L);
        this.scrollPane1 = new JScrollPane();
        this.jTextAreaSQL = TextFieldUtils.buildLimitedLengthTextArea(2000);
        this.jLabel6 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jRadioButtonRestrictDepths = new JRadioButton();
        this.jRadioButtonRestrictZone = new JRadioButton();
        this.jTextFieldDepth1 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldDepth2 = new JTextField();
        this.jComboBoxUnits = new JComboBox();
        this.jComboBoxScheme = new JComboBox();
        this.jComboBoxUnit = new JComboBox();
        this.jRadioButtonNoRestriction = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.buttonGroupWellRestriction = new ButtonGroup();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setHelpLocation("dialogselecttaxaadv.html");
        this.setMaximumSize(new Dimension(268, Integer.MAX_VALUE));
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("insets dialog,hidemode 3,gap 5 5", "[right][fill][fill]", "rel[fill]rel[fill]unrel[fill]unrel[fill]unrel[fill]rel[fill]unrel[grow,fill]unrel"));
        this.jLabel1.setText("Within group:");
        contentPanel.add((Component)this.jLabel1, "cell 0 0");
        this.jComboBoxGroup.setMaximumRowCount(30);
        this.jComboBoxGroup.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        contentPanel.add(this.jComboBoxGroup, "cell 1 0 2 1");
        this.jLabel3.setText("Excluding Set:");
        contentPanel.add((Component)this.jLabel3, "cell 0 1");
        this.jComboBoxExcludeSet.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxExcludeSet.setToolTipText("Exclude from the search all species in group set");
        contentPanel.add(this.jComboBoxExcludeSet, "cell 1 1 2 1");
        this.jLabel2.setText("Within project:");
        this.jLabel2.setToolTipText("Taxa must occur in wells in this project");
        contentPanel.add((Component)this.jLabel2, "cell 0 2");
        this.jComboBoxProject.setModel(this.projectModel);
        this.jComboBoxProject.setMaximumRowCount(30);
        contentPanel.add((Component)this.jComboBoxProject, "cell 1 2 2 1");
        this.jPanel1.setBorder(new TitledBorder("Within disciplines"));
        this.jCheckBoxMacrofaunal.setSelected(true);
        this.jCheckBoxMacrofaunal.setText("Macrofaunal");
        this.jCheckBoxMacrofaunal.setBorder(BorderFactory.createEmptyBorder());
        this.jCheckBoxMacrofaunal.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxMicrofaunal.setSelected(true);
        this.jCheckBoxMicrofaunal.setText("Microfaunal");
        this.jCheckBoxMicrofaunal.setBorder(BorderFactory.createEmptyBorder());
        this.jCheckBoxMicrofaunal.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxNannofloral.setSelected(true);
        this.jCheckBoxNannofloral.setText("Nannofloral");
        this.jCheckBoxNannofloral.setBorder(BorderFactory.createEmptyBorder());
        this.jCheckBoxNannofloral.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxPalynofloral.setSelected(true);
        this.jCheckBoxPalynofloral.setText("Palynofloral");
        this.jCheckBoxPalynofloral.setBorder(BorderFactory.createEmptyBorder());
        this.jCheckBoxPalynofloral.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxMicrofaunal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxPalynofloral)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxMacrofaunal).addGap(18, 18, 18).addComponent(this.jCheckBoxNannofloral))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jCheckBoxNannofloral).addComponent(this.jCheckBoxMacrofaunal)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxMicrofaunal).addComponent(this.jCheckBoxPalynofloral)).addContainerGap()));
        contentPanel.add((Component)this.jPanel1, "cell 0 3 3 1,growx");
        this.jTextFieldAbundance.setPreferredSize(new Dimension(120, 22));
        contentPanel.add((Component)this.jTextFieldAbundance, "cell 2 5,alignx left,growx 0");
        this.jTextAreaSQL.setLineWrap(true);
        this.jTextAreaSQL.setRows(3);
        this.jTextAreaSQL.setPreferredSize(new Dimension(200, 52));
        this.scrollPane1.setViewportView(this.jTextAreaSQL);
        contentPanel.add((Component)this.scrollPane1, "cell 2 6");
        this.jLabel6.setText("With abundance greater than:");
        contentPanel.add((Component)this.jLabel6, "cell 0 5 2 1");
        this.jPanel3.setBorder(new TitledBorder("Depth restriction within well(s)"));
        this.jRadioButtonRestrictDepths.setText("Between depths: ");
        this.jRadioButtonRestrictDepths.addActionListener(e -> this.jRadioButtonRestrictDepthsActionPerformed(e));
        this.jRadioButtonRestrictZone.setText("Within zone/unit:");
        this.jRadioButtonRestrictZone.addActionListener(e -> this.jRadioButtonRestrictZoneActionPerformed(e));
        this.jTextFieldDepth1.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSelectTaxaAdv this$0;
            {
                DialogSelectTaxaAdv dialogSelectTaxaAdv = this$0;
                Objects.requireNonNull(dialogSelectTaxaAdv);
                this.this$0 = dialogSelectTaxaAdv;
            }

            @Override
            public void focusGained(FocusEvent e) {
                this.this$0.jTextFieldDepth1FocusGained(e);
            }
        });
        this.jTextFieldDepth1.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSelectTaxaAdv this$0;
            {
                DialogSelectTaxaAdv dialogSelectTaxaAdv = this$0;
                Objects.requireNonNull(dialogSelectTaxaAdv);
                this.this$0 = dialogSelectTaxaAdv;
            }

            @Override
            public void keyTyped(KeyEvent e) {
                this.this$0.jTextFieldDepth1KeyTyped(e);
            }
        });
        this.jLabel4.setText("to:");
        this.jTextFieldDepth2.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSelectTaxaAdv this$0;
            {
                DialogSelectTaxaAdv dialogSelectTaxaAdv = this$0;
                Objects.requireNonNull(dialogSelectTaxaAdv);
                this.this$0 = dialogSelectTaxaAdv;
            }

            @Override
            public void focusGained(FocusEvent e) {
                this.this$0.jTextFieldDepth2FocusGained(e);
            }
        });
        this.jTextFieldDepth2.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSelectTaxaAdv this$0;
            {
                DialogSelectTaxaAdv dialogSelectTaxaAdv = this$0;
                Objects.requireNonNull(dialogSelectTaxaAdv);
                this.this$0 = dialogSelectTaxaAdv;
            }

            @Override
            public void keyTyped(KeyEvent e) {
                this.this$0.jTextFieldDepth2KeyTyped(e);
            }
        });
        this.jComboBoxScheme.setMaximumRowCount(30);
        this.jComboBoxScheme.addActionListener(e -> this.jComboBoxSchemeActionPerformed(e));
        this.jComboBoxUnit.setMaximumRowCount(30);
        this.jComboBoxUnit.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jRadioButtonNoRestriction.setSelected(true);
        this.jRadioButtonNoRestriction.setText("No restriction");
        this.jRadioButtonNoRestriction.addActionListener(e -> this.jRadioButtonNoRestrictionActionPerformed(e));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup().addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup().addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jRadioButtonRestrictZone).addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup().addComponent(this.jComboBoxUnit, GroupLayout.Alignment.TRAILING, -1, 268, Short.MAX_VALUE).addComponent(this.jComboBoxScheme))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup().addComponent(this.jRadioButtonNoRestriction).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jRadioButtonRestrictDepths).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDepth1, -2, 57, -2).addGap(4, 4, 4).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDepth2, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxUnits, -2, -1, -2))).addGap(0, 54, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.linkSize(0, this.jTextFieldDepth1, this.jTextFieldDepth2);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup().addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonNoRestriction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonRestrictDepths).addComponent(this.jTextFieldDepth1, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jTextFieldDepth2, -2, -1, -2).addComponent(this.jComboBoxUnits, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonRestrictZone).addComponent(this.jComboBoxScheme, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxUnit, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        contentPanel.add((Component)this.jPanel3, "cell 0 4 3 1,growx");
        this.jLabel7.setText("Additional SQL parameters:");
        contentPanel.add((Component)this.jLabel7, "cell 0 6 2 1,aligny top,growy 0");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.buttonGroupWellRestriction.add(this.jRadioButtonRestrictDepths);
        this.buttonGroupWellRestriction.add(this.jRadioButtonRestrictZone);
        this.buttonGroupWellRestriction.add(this.jRadioButtonNoRestriction);
    }

    private void jTextFieldDepth2FocusGained(FocusEvent evt) {
        this.jTextFieldDepth2.setSelectionStart(0);
        this.jTextFieldDepth2.setSelectionEnd(this.jTextFieldDepth2.getText().length());
    }

    private void jTextFieldDepth1FocusGained(FocusEvent evt) {
        this.jTextFieldDepth1.setSelectionStart(0);
        this.jTextFieldDepth1.setSelectionEnd(this.jTextFieldDepth1.getText().length());
    }

    private void jTextFieldDepth2KeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepth2, (int)5, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldDepth1KeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepth1, (int)5, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            HashSet<Discipline> discs = new HashSet<Discipline>();
            if (this.jCheckBoxMicrofaunal.isSelected()) {
                discs.add(Discipline.MICRO);
            }
            if (this.jCheckBoxMacrofaunal.isSelected()) {
                discs.add(Discipline.MACRO);
            }
            if (this.jCheckBoxNannofloral.isSelected()) {
                discs.add(Discipline.NANNO);
            }
            if (this.jCheckBoxPalynofloral.isSelected()) {
                discs.add(Discipline.PALY);
            }
            if (discs.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "no discipline selected", this.getTitle(), 2);
                return;
            }
            TxGroup group = null;
            if (this.jComboBoxGroup.getSelectedIndex() > 0) {
                group = (TxGroup)this.jComboBoxGroup.getSelectedItem();
            }
            TxGroupSet set = null;
            if (this.jComboBoxExcludeSet.getSelectedIndex() > 0) {
                set = (TxGroupSet)this.jComboBoxExcludeSet.getSelectedItem();
            }
            Project project = this.jComboBoxProject.getSelectedItem() instanceof Project ? (Project)((Object)this.jComboBoxProject.getSelectedItem()) : null;
            int abund = -1;
            if (!this.jTextFieldAbundance.getText().isEmpty()) {
                abund = Integer.parseInt(this.jTextFieldAbundance.getText());
            }
            this.selection.clear();
            if (this.jRadioButtonRestrictZone.isSelected()) {
                IGDScheme scheme = (IGDScheme)this.jComboBoxScheme.getSelectedItem();
                IGDUnitBase unit = (IGDUnitBase)this.jComboBoxUnit.getSelectedItem();
                lastScheme = scheme;
                lastUnit = unit;
                String addSql = this.jTextAreaSQL.getText();
                this.selection.addAll(Taxon.search(this.db, discs, group, project, unit, abund, addSql));
            } else {
                Double upper = null;
                Double lower = null;
                if (this.jRadioButtonRestrictDepths.isSelected()) {
                    if (!this.jTextFieldDepth1.getText().isEmpty()) {
                        upper = DepthUtils.convToM((double)Double.valueOf(this.jTextFieldDepth1.getText()), (DepthUnits)((DepthUnits)this.jComboBoxUnits.getSelectedItem()));
                    }
                    if (!this.jTextFieldDepth2.getText().isEmpty()) {
                        lower = DepthUtils.convToM((double)Double.valueOf(this.jTextFieldDepth2.getText()), (DepthUnits)((DepthUnits)this.jComboBoxUnits.getSelectedItem()));
                    }
                }
                String addSql = this.jTextAreaSQL.getText();
                this.selection.addAll(Taxon.search(this.db, discs, group, project, 0, upper, lower, abund, addSql));
                if (!this.selection.isEmpty() && set != null) {
                    set.getGroups();
                    Iterator<Taxon> it = this.selection.iterator();
                    while (it.hasNext()) {
                        Taxon t = it.next();
                        if (!set.isMember(t.getSpecID(), 0)) continue;
                        it.remove();
                    }
                }
            }
            if (this.selection.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No taxa found", this.getTitle(), 2);
                return;
            }
            this.dispose();
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jRadioButtonNoRestrictionActionPerformed(ActionEvent evt) {
        this.setDepthsEnabled(false);
        this.setUnitEnabled(false);
    }

    private void jComboBoxSchemeActionPerformed(ActionEvent evt) {
        Object o = this.jComboBoxScheme.getSelectedItem();
        if (!(o instanceof IGDScheme)) {
            return;
        }
        try {
            IGDScheme scheme = (IGDScheme)o;
            this.jComboBoxUnit.removeAllItems();
            scheme.loadUnits();
            if (scheme.getIGDType() == 2) {
                for (LithostratUnit unit : scheme.getLithostratUnits()) {
                    this.jComboBoxUnit.addItem(unit);
                }
            } else {
                for (IGDUnit unit : scheme.getUnitsX()) {
                    this.jComboBoxUnit.addItem(unit);
                }
            }
            this.jComboBoxUnit.repaint();
        }
        catch (RuntimeException | SQLException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
    }

    private void jRadioButtonRestrictDepthsActionPerformed(ActionEvent evt) {
        this.setDepthsEnabled(true);
        this.setUnitEnabled(false);
    }

    private void jRadioButtonRestrictZoneActionPerformed(ActionEvent evt) {
        this.setDepthsEnabled(false);
        this.setUnitEnabled(true);
    }

    private void setDepthsEnabled(boolean b) {
        this.jTextFieldDepth1.setEnabled(b);
        this.jTextFieldDepth2.setEnabled(b);
    }

    private void setUnitEnabled(boolean b) {
        this.jComboBoxScheme.setEnabled(b);
        this.jComboBoxUnit.setEnabled(b);
    }

    private void initSchemes() throws SQLException {
        int[] igdTypes;
        this.jComboBoxScheme.removeAllItems();
        this.jComboBoxUnit.removeAllItems();
        for (int igdType : igdTypes = new int[]{3, 2, 4}) {
            List<IGDScheme> schemes = this.db.getIGDSchemes(igdType);
            Collections.sort(schemes);
            for (IGDScheme scheme : schemes) {
                this.jComboBoxScheme.addItem(scheme);
            }
        }
        if (lastScheme != null) {
            this.jComboBoxScheme.setSelectedItem(lastScheme);
            if (lastUnit != null) {
                this.jComboBoxUnit.setSelectedItem(lastUnit);
            }
        }
    }

    public List<Taxon> getSelection() {
        return this.selection;
    }
}

