/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.Timer;
import jsbugs.tools.DeadlockDetectorTask;

public class DeadlockDetectorHelper {
    private static long MSECPERMINUTE;
    private static long REFRESH_INTERVAL;
    private static DeadlockDetectorHelper helperInstance;
    private DeadlockDetectorTask currentTask = null;
    private Timer timer;
    private ActionListener timerListener;

    public static float getRefreshInterval() {
        return REFRESH_INTERVAL / MSECPERMINUTE;
    }

    public static void setRefreshInterval(float refreshInterval) {
        REFRESH_INTERVAL = (long)((int)refreshInterval) * MSECPERMINUTE;
    }

    private DeadlockDetectorHelper() {
    }

    public static boolean startDeadlockDetection() {
        if (REFRESH_INTERVAL <= 0L) {
            return false;
        }
        helperInstance = new DeadlockDetectorHelper();
        DeadlockDetectorHelper.helperInstance.timerListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (DeadlockDetectorHelper.helperInstance.currentTask != null && !DeadlockDetectorHelper.helperInstance.currentTask.isDone()) {
                    Logger.getLogger(DeadlockDetectorHelper.class.getName()).warning("Deadlock detection task aborted because previous refresh was not done");
                    return;
                }
                DeadlockDetectorHelper.helperInstance.currentTask = new DeadlockDetectorTask();
                DeadlockDetectorHelper.helperInstance.currentTask.execute();
            }
        };
        DeadlockDetectorHelper.helperInstance.timer = new Timer((int)REFRESH_INTERVAL, DeadlockDetectorHelper.helperInstance.timerListener);
        DeadlockDetectorHelper.helperInstance.timer.start();
        DeadlockDetectorHelper.helperInstance.currentTask = new DeadlockDetectorTask();
        DeadlockDetectorHelper.helperInstance.currentTask.execute();
        return true;
    }

    public static void stopDeadlockDetection() {
        if (helperInstance != null) {
            DeadlockDetectorHelper.helperInstance.timer.stop();
            helperInstance = null;
        }
    }

    static {
        REFRESH_INTERVAL = MSECPERMINUTE = 60000L;
    }
}

