/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.tools;

import com.stratadata.model3.db.DBType;
import java.awt.Toolkit;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import jsbugs.tools.DeadlockDetectorHelper;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import model3.SBdb;

class DeadlockDetectorTask
extends SwingWorker {
    private static final Logger LOGGER = Logger.getLogger(DeadlockDetectorTask.class.getName());
    private Exception ex;
    private final List<String> blockedUsers = new ArrayList<String>();

    DeadlockDetectorTask() {
    }

    public Object doInBackground() {
        SBdb db = SbugsSession.getSession().getDB();
        if (db.getDBType() == DBType.MSSQLSERVER) {
            try (Statement stmt = db.getDatabase().createStatement();){
                String sql = "SELECT nt_username FROM master.sys.sysprocesses WHERE blocked > 0";
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    this.blockedUsers.add(rs.getString("nt_username"));
                }
            }
            catch (RuntimeException | SQLException x) {
                this.ex = x;
                x.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected void done() {
        if (this.ex != null) {
            DeadlockDetectorHelper.stopDeadlockDetection();
            SbugsExceptionHandler.showStackError("Error during deadlock detection", this.ex);
        } else if (!this.blockedUsers.isEmpty()) {
            Object msg = "Deadlock Detected!\nThe following users are affected: ";
            for (String s : this.blockedUsers) {
                msg = (String)msg + "\n" + s;
            }
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, "Deadlock", (String)msg, 2);
        } else {
            System.out.println("No deadlock detected at: " + new SimpleDateFormat("HH:mm:ss").format(Calendar.getInstance().getTime()));
        }
    }
}

