/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.tools;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.FrameJsbugs;
import jsbugs.tools.SBLogger;
import jsbugs.userconnect.SbugsSession;
import model3.Lastval;
import org.apache.commons.lang3.StringUtils;

public class DialogLogging
extends SBDialog {
    private static final Logger LOGGER = Logger.getLogger(DialogLogging.class.getName());
    private static final String DEFAULT_PATH_DESCR = "<system default>";
    private static final String HELP_LOCATION = "logging.html";
    private final DefaultComboBoxModel<SBLogger.LogStoreDefault> defaultLocationModel = new DefaultComboBoxModel<SBLogger.LogStoreDefault>(SBLogger.LogStoreDefault.values());
    private final DefaultComboBoxModel<Level> levelComboModel = new DefaultComboBoxModel();
    private File loggingDir;
    private JButton jButtonApply;
    private JButton jButtonCancel;
    private JButton jButtonClearLocationPrefPath;
    private JButton jButtonDirectory;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonTestConfig;
    private JButton jButtonTestError;
    private JButton jButtonTestInfo;
    private JButton jButtonTestWarning;
    private JComboBox<SBLogger.LogStoreDefault> jComboBoxDefaultLocation;
    private JComboBox<Level> jComboBoxLevel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField jTextFieldPath;

    public DialogLogging(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Logging Configuration");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if ((SbugsSession.getDb().getUser().getPriv() & 0x40) == 0) {
            this.jComboBoxDefaultLocation.setEnabled(false);
        }
        this.levelComboModel.addElement(Level.SEVERE);
        this.levelComboModel.addElement(Level.WARNING);
        this.levelComboModel.addElement(Level.INFO);
        this.levelComboModel.addElement(Level.CONFIG);
        this.levelComboModel.addElement(Level.OFF);
        this.jComboBoxLevel.setSelectedItem(SBLogger.getLogLevel());
        try {
            String pathPref = Lastval.getString(SbugsSession.getDb(), "LOGPATH");
            if (!StringUtils.isBlank((CharSequence)pathPref)) {
                this.loggingDir = new File(pathPref);
            }
            this.jComboBoxDefaultLocation.setSelectedItem((Object)SBLogger.getSystemDefaultLogPath());
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error getting preference for log path", sql, SbugsSession.getDb());
        }
        this.jTextFieldPath.setText(this.loggingDir != null ? this.loggingDir.getAbsolutePath() : DEFAULT_PATH_DESCR);
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jButtonTestWarning = new JButton();
        this.jButtonTestInfo = new JButton();
        this.jButtonTestConfig = new JButton();
        this.jButtonTestError = new JButton();
        this.jButtonApply = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jComboBoxDefaultLocation = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jButtonDirectory = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldPath = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxLevel = new JComboBox();
        this.jButtonClearLocationPrefPath = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogging this$0;
            {
                DialogLogging dialogLogging = this$0;
                Objects.requireNonNull(dialogLogging);
                this.this$0 = dialogLogging;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogging this$0;
            {
                DialogLogging dialogLogging = this$0;
                Objects.requireNonNull(dialogLogging);
                this.this$0 = dialogLogging;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Test settings", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jButtonTestWarning.setText("Warning");
        this.jButtonTestWarning.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogging this$0;
            {
                DialogLogging dialogLogging = this$0;
                Objects.requireNonNull(dialogLogging);
                this.this$0 = dialogLogging;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTestWarningActionPerformed(evt);
            }
        });
        this.jButtonTestInfo.setText("Info");
        this.jButtonTestInfo.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogging this$0;
            {
                DialogLogging dialogLogging = this$0;
                Objects.requireNonNull(dialogLogging);
                this.this$0 = dialogLogging;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTestInfoActionPerformed(evt);
            }
        });
        this.jButtonTestConfig.setText("Config");
        this.jButtonTestConfig.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogging this$0;
            {
                DialogLogging dialogLogging = this$0;
                Objects.requireNonNull(dialogLogging);
                this.this$0 = dialogLogging;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTestConfigActionPerformed(evt);
            }
        });
        this.jButtonTestError.setText("Error");
        this.jButtonTestError.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogging this$0;
            {
                DialogLogging dialogLogging = this$0;
                Objects.requireNonNull(dialogLogging);
                this.this$0 = dialogLogging;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTestErrorActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonTestError).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonTestWarning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonTestInfo, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonTestConfig, -2, 72, -2).addContainerGap(38, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.jButtonTestConfig, this.jButtonTestError, this.jButtonTestInfo, this.jButtonTestWarning);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonTestError).addComponent(this.jButtonTestWarning).addComponent(this.jButtonTestInfo).addComponent(this.jButtonTestConfig)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonApply.setText("Apply");
        this.jButtonApply.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogging this$0;
            {
                DialogLogging dialogLogging = this$0;
                Objects.requireNonNull(dialogLogging);
                this.this$0 = dialogLogging;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonApplyActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Settings for all users", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel3.setText("Default logs location:");
        this.jComboBoxDefaultLocation.setModel(this.defaultLocationModel);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDefaultLocation, 0, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBoxDefaultLocation, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Settings for current user", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jButtonDirectory.setText("...");
        this.jButtonDirectory.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogging this$0;
            {
                DialogLogging dialogLogging = this$0;
                Objects.requireNonNull(dialogLogging);
                this.this$0 = dialogLogging;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDirectoryActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Logs folder:");
        this.jTextFieldPath.setEditable(false);
        this.jLabel2.setText("Logging level:");
        this.jComboBoxLevel.setModel(this.levelComboModel);
        this.jButtonClearLocationPrefPath.setText("Clear");
        this.jButtonClearLocationPrefPath.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogging this$0;
            {
                DialogLogging dialogLogging = this$0;
                Objects.requireNonNull(dialogLogging);
                this.this$0 = dialogLogging;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearLocationPrefPathActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDirectory, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClearLocationPrefPath)).addComponent(this.jComboBoxLevel, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldPath, -2, -1, -2).addComponent(this.jButtonDirectory).addComponent(this.jButtonClearLocationPrefPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBoxLevel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogging this$0;
            {
                DialogLogging dialogLogging = this$0;
                Objects.requireNonNull(dialogLogging);
                this.this$0 = dialogLogging;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonApply).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonApply, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonApply).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonTestWarningActionPerformed(ActionEvent evt) {
        LOGGER.warning("This is a warning.");
    }

    private void jButtonTestInfoActionPerformed(ActionEvent evt) {
        LOGGER.info("This is information.");
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonTestConfigActionPerformed(ActionEvent evt) {
        LOGGER.config("This is a configuration message");
    }

    private void jButtonTestErrorActionPerformed(ActionEvent evt) {
        try {
            throw new NullPointerException("This is an exception.");
        }
        catch (NullPointerException e) {
            FrameJsbugs.showStackError("An error occurred.", e, SbugsSession.getDb());
            return;
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.apply();
        this.dispose();
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        this.apply();
    }

    private void jButtonDirectoryActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        if (this.loggingDir != null) {
            fileChooser.setCurrentDirectory(this.loggingDir);
        }
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            this.loggingDir = fileChooser.getSelectedFile();
            this.jTextFieldPath.setText(this.loggingDir.getAbsolutePath());
        }
    }

    private void jButtonClearLocationPrefPathActionPerformed(ActionEvent evt) {
        this.loggingDir = null;
        this.jTextFieldPath.setText(DEFAULT_PATH_DESCR);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)HELP_LOCATION);
    }

    private void apply() {
        try {
            if (this.jComboBoxDefaultLocation.isEnabled()) {
                SBLogger.setDefaultLoggingLocation(this.defaultLocationModel.getElementAt(this.jComboBoxDefaultLocation.getSelectedIndex()));
            }
            SBLogger.setLogDirectory(this.loggingDir);
            SBLogger.setLogLevel(this.jComboBoxLevel.getSelectedItem().toString());
        }
        catch (IOException ioe) {
            FrameJsbugs.showStackError("Error creating logging directory", ioe, SbugsSession.getDb());
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error setting system preference", sql, SbugsSession.getDb());
        }
    }
}

