/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.tools;

import com.stratadata.model3.taxon.SynonymScheme;
import com.stratadata.util.ui.SBDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.tools.SbugsServerConfigController;
import model3.InterpHdr;
import net.miginfocom.swing.MigLayout;

public class DialogSbugsServer
extends SBDialog {
    private SbugsServerConfigController.ServerConfig newConfig;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel label6;
    private JSeparator separator3;
    private JLabel label1;
    private JComboBox jComboBoxVersion;
    private JLabel label2;
    private JLabel label5;
    private JTextField jTextFieldWellCodeFilter;
    private JLabel label4;
    private JLabel label3;
    private JComboBox jComboBoxSynonymy;
    private JCheckBox jCheckBoxCorrectDepths;
    private JCheckBox jCheckBoxCorrectCuttings;
    private JSeparator separator2;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public DialogSbugsServer(Frame parent, boolean modal, SbugsServerConfigController.ServerConfig config, List<InterpHdr> interpHdrs, List<SynonymScheme> synonymSchemes) {
        super(parent, modal);
        this.initComponents();
        this.init(config, interpHdrs, synonymSchemes);
    }

    private void init(SbugsServerConfigController.ServerConfig config, List<InterpHdr> interpHdrs, List<SynonymScheme> synonymSchemes) {
        this.setTitle("StrataBugs Server Configuration");
        this.jTextFieldWellCodeFilter.setText(config.filter());
        this.jCheckBoxCorrectDepths.setSelected(config.correctDepths());
        this.jCheckBoxCorrectCuttings.setSelected(config.correctCuttings());
        this.jComboBoxVersion.setModel(new DefaultComboBoxModel<Object>(interpHdrs.toArray()));
        InterpHdr selectedHdr = interpHdrs.stream().filter(interpHdr -> interpHdr.getInterpID() == config.interpID()).findFirst().orElse(interpHdrs.stream().filter(interpHdr -> interpHdr.getInterpID() == 0).findFirst().orElseThrow());
        this.jComboBoxVersion.setSelectedItem(selectedHdr);
        ArrayList<SynonymScheme> synItems = new ArrayList<SynonymScheme>(synonymSchemes);
        String noScheme = "<none>";
        synItems.add(0, (SynonymScheme)noScheme);
        this.jComboBoxSynonymy.setModel(new DefaultComboBoxModel<Object>(synItems.toArray()));
        SynonymScheme selectedSch = synonymSchemes.stream().filter(synonymScheme -> synonymScheme.getSchID() == config.synSchID()).findFirst().orElse(null);
        if (selectedSch != null) {
            this.jComboBoxSynonymy.setSelectedItem(selectedSch);
        } else {
            this.jComboBoxSynonymy.setSelectedItem(noScheme);
        }
    }

    private void cancel(ActionEvent e) {
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent e) {
        int n;
        String filter = this.jTextFieldWellCodeFilter.getText().trim();
        int interpID = ((InterpHdr)this.jComboBoxVersion.getSelectedItem()).getInterpID();
        Object object = this.jComboBoxSynonymy.getSelectedItem();
        if (object instanceof SynonymScheme) {
            SynonymScheme synSch = (SynonymScheme)object;
            n = synSch.getSchID();
        } else {
            n = 0;
        }
        int synSchID = n;
        this.newConfig = new SbugsServerConfigController.ServerConfig(interpID, filter, this.jCheckBoxCorrectDepths.isSelected(), this.jCheckBoxCorrectCuttings.isSelected(), synSchID);
        this.setOK();
    }

    public SbugsServerConfigController.ServerConfig getNewConfig() {
        return this.newConfig;
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.label6 = new JLabel();
        this.separator3 = new JSeparator();
        this.label1 = new JLabel();
        this.jComboBoxVersion = new JComboBox();
        this.label2 = new JLabel();
        this.label5 = new JLabel();
        this.jTextFieldWellCodeFilter = new JTextField();
        this.label4 = new JLabel();
        this.label3 = new JLabel();
        this.jComboBoxSynonymy = new JComboBox();
        this.jCheckBoxCorrectDepths = new JCheckBox();
        this.jCheckBoxCorrectCuttings = new JCheckBox();
        this.separator2 = new JSeparator();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setMinimumSize(new Dimension(460, 290));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new MigLayout("fillx,insets dialog,hidemode 3", "[shrink 0,right][284,grow,fill]", "[]rel[]unrel[][][]unrel[][][6]"));
        this.label6.setText("These settings will affect any instance of StrataBugs Server using this database.");
        this.label6.setForeground(new Color(0x3366CC));
        this.contentPanel.add((Component)this.label6, "cell 0 0 2 1,alignx leading,growx 0");
        this.contentPanel.add((Component)this.separator3, "cell 0 1 2 1,growx");
        this.label1.setText("Interpretation version:");
        this.contentPanel.add((Component)this.label1, "cell 0 2");
        this.contentPanel.add((Component)this.jComboBoxVersion, "cell 1 2");
        this.label2.setText("Well code filter:");
        this.contentPanel.add((Component)this.label2, "cell 0 3");
        this.label5.setText("%");
        this.contentPanel.add((Component)this.label5, "cell 1 3,width 10:10:10");
        this.contentPanel.add((Component)this.jTextFieldWellCodeFilter, "cell 1 3");
        this.label4.setText("%");
        this.contentPanel.add((Component)this.label4, "cell 1 3,width 10:10:10");
        this.label3.setText("Synonym scheme:");
        this.contentPanel.add((Component)this.label3, "cell 0 4");
        this.contentPanel.add((Component)this.jComboBoxSynonymy, "cell 1 4");
        this.jCheckBoxCorrectDepths.setText("Correct sample depths");
        this.contentPanel.add((Component)this.jCheckBoxCorrectDepths, "cell 0 5 2 1,alignx left,growx 0");
        this.jCheckBoxCorrectCuttings.setText("Correct cuttings");
        this.contentPanel.add((Component)this.jCheckBoxCorrectCuttings, "cell 0 6 2 1,alignx left,growx 0");
        this.contentPanel.add((Component)this.separator2, "cell 0 7 2 1,growx");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setLayout((LayoutManager)new MigLayout("insets dialog,alignx right", "[button,fill][button,fill]", "[]"));
        this.okButton.setText("OK");
        this.okButton.addActionListener(e -> this.jButtonOkActionPerformed(e));
        this.buttonBar.add((Component)this.okButton, "cell 0 0");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(e -> this.cancel(e));
        this.buttonBar.add((Component)this.cancelButton, "cell 1 0");
        this.dialogPane.add((Component)this.buttonBar, "Last");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

