/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.tools;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class MemoryMonitor {
    private final JProgressBar jProgressBarMemory;
    private Timer timer;

    static void attachInstance(JProgressBar jProgressBar) {
        MemoryMonitor memoryMonitor = new MemoryMonitor(jProgressBar);
        memoryMonitor.initTimer();
    }

    private MemoryMonitor(JProgressBar jProgressBarMemory) {
        this.jProgressBarMemory = jProgressBarMemory;
    }

    private void initTimer() {
        ActionListener timerListener = new ActionListener(this){
            final /* synthetic */ MemoryMonitor this$0;
            {
                MemoryMonitor memoryMonitor = this$0;
                Objects.requireNonNull(memoryMonitor);
                this.this$0 = memoryMonitor;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                this.this$0.setMemoryMonitor();
            }
        };
        this.timer = new Timer(5000, timerListener);
        this.timer.start();
    }

    private void setMemoryMonitor() {
        long max = Runtime.getRuntime().maxMemory() / 1000000L;
        this.jProgressBarMemory.setMaximum((int)max);
        long used = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000000L;
        if ((double)((float)used / (float)max) > 0.9) {
            this.jProgressBarMemory.setForeground(Color.red);
        } else {
            this.jProgressBarMemory.setForeground(Color.green);
        }
        this.jProgressBarMemory.setValue((int)used);
        this.jProgressBarMemory.setStringPainted(true);
        this.jProgressBarMemory.setString(used + "Mb/" + max + "Mb");
    }
}

