/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.tools;

import java.sql.SQLException;
import java.util.Locale;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;

public class SbugsServerConfigController {
    private static final String KEY_PREFIX = "sbs_";
    private static final String KEY_CORRECT_CORES = "correctcores";
    private static final String KEY_CORRECT_CUTTINGS = "correctcuttings";
    private static final String KEY_VERSION = "version";
    private static final String KEY_WELL_CODE_FILTER = "wellcodefilter";
    private static final String KEY_SYN_SCH = "synonymscheme";
    private final SBdb sbdb;

    public SbugsServerConfigController(SBdb sbdb) {
        this.sbdb = sbdb;
    }

    public ServerConfig loadConfig() throws SQLException {
        Boolean correctDepthsBool;
        ServerConfig defaults = ServerConfig.getDefault();
        String filterPrefString = this.sbdb.getDatabasePref("sbs_wellcodefilter");
        String interpPrefString = this.sbdb.getDatabasePref("sbs_version");
        int interpID = defaults.interpID();
        if (!StringUtils.isBlank((CharSequence)interpPrefString)) {
            interpID = Integer.parseInt(interpPrefString);
        }
        boolean correctDepths = (correctDepthsBool = this.sbdb.getDatabasePrefBool("sbs_correctcores")) != null ? correctDepthsBool.booleanValue() : defaults.correctDepths();
        Boolean correctCuttingsBool = this.sbdb.getDatabasePrefBool("sbs_correctcuttings");
        boolean correctCuttings = correctCuttingsBool != null ? correctCuttingsBool.booleanValue() : defaults.correctCuttings();
        String synSchPrefString = this.sbdb.getDatabasePref("sbs_synonymscheme");
        int synSchID = defaults.synSchID();
        if (!StringUtils.isBlank((CharSequence)synSchPrefString)) {
            synSchID = Integer.parseInt(synSchPrefString);
        }
        return new ServerConfig(interpID, filterPrefString, correctDepths, correctCuttings, synSchID);
    }

    public void updateConfig(ServerConfig config) throws SQLException {
        this.sbdb.putDatabasePref("sbs_wellcodefilter", config.filter().toUpperCase(Locale.UK));
        this.sbdb.putDatabasePref("sbs_version", "" + config.interpID());
        this.sbdb.putDatabasePref("sbs_correctcores", config.correctDepths);
        this.sbdb.putDatabasePref("sbs_correctcuttings", config.correctCuttings);
        this.sbdb.putDatabasePref("sbs_synonymscheme", "" + config.synSchID());
        this.sbdb.commit();
    }

    public record ServerConfig(int interpID, String filter, boolean correctDepths, boolean correctCuttings, int synSchID) {
        static ServerConfig getDefault() {
            return new ServerConfig(0, "", true, false, 0);
        }
    }
}

