/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import java.text.DecimalFormat;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import util.NumberUtils;

public class DecimalCellEditor
extends DefaultCellEditor {
    private DecimalFormat df = new DecimalFormat("0");

    public DecimalCellEditor(JTextField textField, int maxPrecision) {
        this(textField);
        this.df.setMaximumFractionDigits(maxPrecision);
    }

    public DecimalCellEditor(final JTextField textField) {
        super(textField);
        this.df.setMaximumFractionDigits(340);
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            final /* synthetic */ DecimalCellEditor this$0;
            {
                DecimalCellEditor decimalCellEditor = this$0;
                Objects.requireNonNull(decimalCellEditor);
                this.this$0 = decimalCellEditor;
                super(this$0);
            }

            @Override
            public void setValue(Object value) {
                if (value == null) {
                    textField.setText("");
                    return;
                }
                Double d = NumberUtils.tryParseDouble((String)value.toString());
                textField.setText(d != null ? this.this$0.df.format(d) : "");
            }

            @Override
            public Object getCellEditorValue() {
                return textField.getText();
            }
        };
    }
}

