/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import jsbugs.uiutil.IDocumentInsertErrorListener;

public class DecimalNumberOnlyDocument
extends PlainDocument {
    private IDocumentInsertErrorListener listener = null;
    private boolean allowNegative = true;
    private Double maxValue = Double.MAX_VALUE;
    private int maxPrecision = 10;
    private String allowedValues = "0123456789.-";

    public DecimalNumberOnlyDocument() {
    }

    public DecimalNumberOnlyDocument(IDocumentInsertErrorListener listener) {
        this.listener = listener;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (this.allowedValues.indexOf(str.charAt(i)) >= 0) continue;
            this.notifyOfInsertError();
            return;
        }
        String text = this.getText(0, offset) + str + this.getText(offset, this.getLength() - offset);
        if (".".equals(text) || this.getAllowNegative() && "-".equals(text) || this.getAllowNegative() && "-.".equals(text)) {
            super.insertString(offset, str, attr);
            return;
        }
        boolean success = true;
        Double newValue = null;
        try {
            newValue = Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            success = false;
        }
        if (!success) {
            this.notifyOfInsertError();
            return;
        }
        if (!this.getAllowNegative() && newValue < 0.0) {
            this.notifyOfInsertError();
            return;
        }
        if (this.getPrecision(text) > this.getMaxPrecision()) {
            this.notifyOfInsertError();
            return;
        }
        if (Math.abs(newValue) > this.getMaxValue()) {
            this.notifyOfInsertError();
            return;
        }
        super.insertString(offset, str, attr);
    }

    private int getPrecision(String text) {
        int indexOfDecimalMark = text.indexOf(46);
        if (indexOfDecimalMark > 0) {
            return text.length() - indexOfDecimalMark - 1;
        }
        return 0;
    }

    private void notifyOfInsertError() {
        if (this.listener != null) {
            this.listener.notifyOfInsertError();
        }
    }

    public boolean getAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Double maxValue) {
        if (maxValue == null) {
            return;
        }
        this.maxValue = maxValue;
    }

    public int getMaxPrecision() {
        return this.maxPrecision;
    }

    public void setMaxPrecision(int maxPrecision) {
        this.maxPrecision = maxPrecision;
    }
}

