/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.positioners.LeftBelowPositioner;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.EdgedBalloonStyle;

public abstract class ImageTooltip
extends MouseAdapter {
    private final BalloonTip balloonTip;
    private final JLabel imageLabel = new JLabel();
    private final Positioner positioner;

    public ImageTooltip(JComponent attachComponent) {
        JPanel tipContents = new JPanel();
        tipContents.add(this.imageLabel);
        this.positioner = new Positioner();
        this.balloonTip = new BalloonTip(attachComponent, (JComponent)tipContents, (BalloonTipStyle)new EdgedBalloonStyle(Color.WHITE, Color.DARK_GRAY), (BalloonTipPositioner)this.positioner, null);
        this.updateTip(null, new Point(0, 0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.refreshBalloonTip(e.getPoint());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.refreshBalloonTip(e.getPoint());
    }

    protected abstract void refreshBalloonTip(Point var1);

    protected final void updateTip(ImageIcon icon, Point positionerLocation) {
        if (icon != null) {
            this.imageLabel.setIcon(icon);
            this.positioner.point.x = positionerLocation.x;
            this.positioner.point.y = positionerLocation.y;
            this.balloonTip.refreshLocation();
        } else {
            this.imageLabel.setIcon(null);
        }
        this.balloonTip.setVisible(icon != null);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.balloonTip.setVisible(false);
    }

    private static class Positioner
    extends LeftBelowPositioner {
        final Point point = new Point(5, 5);

        Positioner() {
            super(0, 0);
        }

        protected void determineLocation(Rectangle attached) {
            int balloonWidth = this.balloonTip.getPreferredSize().width;
            int balloonHeight = this.balloonTip.getPreferredSize().height;
            this.flipX = false;
            this.flipY = true;
            this.hOffset = this.preferredHorizontalOffset;
            this.x = attached.x + this.point.x;
            this.y = attached.y + this.point.y;
            if (this.orientationCorrection) {
                if (this.y + balloonHeight > this.balloonTip.getTopLevelContainer().getHeight()) {
                    this.flipY = false;
                    this.y = this.balloonTip.getTopLevelContainer().getHeight() - balloonHeight;
                }
                if (this.x < 0) {
                    this.flipX = true;
                    this.x = attached.x + attached.width - balloonWidth;
                    this.hOffset = balloonWidth - this.hOffset;
                }
            }
            if (this.offsetCorrection) {
                this.applyOffsetCorrection();
            }
        }
    }
}

