/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class WaitCursorListenerFactory {
    public static final int CURSOR_CHANGE_DELAY = 250;

    private WaitCursorListenerFactory() {
    }

    public static ActionListener createListener(Component component, final ActionListener mainActionListener) {
        Component glassPane = null;
        if (component instanceof RootPaneContainer) {
            glassPane = ((RootPaneContainer)((Object)component)).getGlassPane();
        } else {
            JRootPane rootPane = SwingUtilities.getRootPane(component);
            if (rootPane != null) {
                glassPane = rootPane.getGlassPane();
            }
        }
        final boolean isGlassPaneComponent = glassPane != null;
        final Component componentForListener = glassPane != null ? glassPane : component;
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent ae) {
                TimerTask timerTask = new TimerTask(this){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    @Override
                    public void run() {
                        componentForListener.setCursor(Cursor.getPredefinedCursor(3));
                        if (isGlassPaneComponent) {
                            componentForListener.setVisible(true);
                        }
                    }
                };
                Timer timer = new Timer();
                try {
                    timer.schedule(timerTask, 250L);
                    mainActionListener.actionPerformed(ae);
                }
                finally {
                    timer.cancel();
                    componentForListener.setCursor(Cursor.getDefaultCursor());
                    if (isGlassPaneComponent) {
                        componentForListener.setVisible(false);
                    }
                }
            }
        };
        return actionListener;
    }
}

