/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil.audit;

import com.stratadata.util.DateUtils;
import java.time.LocalDate;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextField;
import jsbugs.userconnect.SbugsSession;
import org.apache.commons.lang3.StringUtils;

public class AuditUiUtilities {
    private static final String LABEL_TEXT = "%s %s %s";
    private static final String UNKNOWN = "<unknown>";
    private static final ResourceBundle resources = ResourceBundle.getBundle("locale/UiText");

    public static void setAuditText(String creator, LocalDate created, String modifier, LocalDate modified, JTextField jTextFieldCreator, JTextField jTextFieldModifier) {
        AuditUiUtilities.setLabelText(creator, created, jTextFieldCreator);
        AuditUiUtilities.setLabelText(modifier, modified, jTextFieldModifier);
    }

    public static void setAuditText(int creatorID, LocalDate created, int modifierID, LocalDate modified, UserNameFormat nameFormat, JTextField jTextFieldCreator, JTextField jTextFieldModifier) {
        try {
            String creator = SbugsSession.getDb().getUserService().findUser(creatorID).map(user -> switch (nameFormat.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> user.getAbr();
                case 1 -> user.getName();
            }).orElse(UNKNOWN);
            String modifier = SbugsSession.getDb().getUserService().findUser(modifierID).map(user -> switch (nameFormat.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> user.getAbr();
                case 1 -> user.getName();
            }).orElse(UNKNOWN);
            AuditUiUtilities.setLabelText(creator, created, jTextFieldCreator);
            AuditUiUtilities.setLabelText(modifier, modified, jTextFieldModifier);
        }
        catch (RuntimeException exception) {
            Logger.getLogger(AuditUiUtilities.class.getName()).log(Level.WARNING, "Error setting audit text", exception);
        }
    }

    private static void setLabelText(String user, LocalDate date, JTextField field) {
        if (StringUtils.isBlank((CharSequence)user)) {
            user = UNKNOWN;
        }
        String dateText = date != null ? date.format(DateUtils.DISPLAY_FORMAT) : UNKNOWN;
        String text = String.format(LABEL_TEXT, user, resources.getString("JPanelAudit.on"), dateText);
        field.setText(text);
    }

    public static enum UserNameFormat {
        ABR,
        FULL;

    }
}

