/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil.audit;

import com.stratadata.model3.user.Userdef;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jsbugs.userconnect.SbugsSession;
import org.apache.commons.lang3.StringUtils;

abstract class JPanelAudit
extends JPanel {
    private final ResourceBundle resources = ResourceBundle.getBundle("locale/UiText");
    private static final String LABEL_TEXT = "%s %s %s";
    private static final String DATE_FORMAT = "dd-MMM-yyyy";
    private static final String UNKNOWN = "<unknown>";
    private JTextField jTextFieldCreator;
    private JTextField jTextFieldModifier;
    private NameFormat nameFormat = NameFormat.ABR;

    JPanelAudit() {
    }

    void setFields(JTextField jTextFieldCreator, JTextField jTextFieldModifier) {
        this.jTextFieldCreator = jTextFieldCreator;
        this.jTextFieldModifier = jTextFieldModifier;
        jTextFieldCreator.setText("");
        jTextFieldModifier.setText("");
    }

    public void setAuditText(String creator, Date created, String modifier, Date modified) {
        this.setLabelText(creator, created, this.jTextFieldCreator);
        this.setLabelText(modifier, modified, this.jTextFieldModifier);
    }

    public void setAuditText(int creatorID, Date created, int modifierID, Date modified) {
        String creator = UNKNOWN;
        String modifier = UNKNOWN;
        try {
            Userdef user;
            if (creatorID > 0) {
                user = SbugsSession.getDb().getUser(creatorID);
                switch (this.nameFormat.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        String string = user.getAbr();
                        break;
                    }
                    case 1: {
                        String string = creator = user.getName();
                    }
                }
            }
            if (modifierID > 0) {
                user = SbugsSession.getDb().getUser(modifierID);
                modifier = switch (this.nameFormat.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> user.getAbr();
                    case 1 -> user.getName();
                };
            }
        }
        catch (SQLException sqle) {
            Logger.getLogger(JPanelAudit.class.getName()).log(Level.WARNING, "Error setting audit text", sqle);
        }
        this.setLabelText(creator, created, this.jTextFieldCreator);
        this.setLabelText(modifier, modified, this.jTextFieldModifier);
    }

    private void setLabelText(String user, Date date, JTextField field) {
        if (StringUtils.isBlank((CharSequence)user)) {
            user = UNKNOWN;
        }
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        String dateText = date != null ? df.format(date) : UNKNOWN;
        String text = String.format(LABEL_TEXT, user, this.resources.getString("JPanelAudit.on"), dateText);
        field.setText(text);
    }

    public void setNameFormatFull() {
        this.nameFormat = NameFormat.FULL;
    }

    public void setNameFormatAbr() {
        this.nameFormat = NameFormat.ABR;
    }

    private static enum NameFormat {
        ABR,
        FULL;

    }
}

