/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.userconnect;

import com.stratadata.model3.db.DBType;
import com.stratadata.model3.user.Userdef;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogCountryRoles;
import jsbugs.DialogMergeAnalysts;
import jsbugs.DialogUserData;
import jsbugs.FrameJsbugs;
import jsbugs.table.ColourRenderer;
import jsbugs.userconnect.DialogUserdef;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBRestrictable;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class DialogSelectAnalyst
extends JDialog {
    private static final int COLNAME = 0;
    private static final int COLID = 1;
    private static final int COLSYS = 2;
    private static final int COLCOLOUR = 3;
    private static final int COLISUSER = 4;
    private static String[] columnHeaders = new String[]{"Full Name", "SBugs ID", "Login name", "Colour", "Is user?"};
    private static int[] columnWidths = new int[]{120, 30, 50, 10, 20};
    private final SBdb sbdb;
    private boolean allUsers;
    public Userdef selectedUser = null;
    private final boolean isSelectable;
    private final TableModelUserdef model = new TableModelUserdef();
    private final TableRowSorter<TableModelUserdef> sorter = new TableRowSorter<TableModelUserdef>(this.model);
    private final Object parent;
    private ButtonGroup buttonGroupUsers;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonCountries;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonMerge;
    private JButton jButtonOK;
    private JButton jButtonShowData;
    private JRadioButton jRadioButtonAllPersonell;
    private JRadioButton jRadioButtonSBUsers;
    private JScrollPane jScrollPane1;
    private JTable jTableUsers;

    public DialogSelectAnalyst(Frame parent, boolean modal, SBdb sbdb, boolean isSelectable) throws SQLException {
        super(parent, modal);
        this.sbdb = sbdb;
        this.parent = parent;
        this.allUsers = true;
        this.isSelectable = isSelectable;
        this.initComponents();
        this.init();
    }

    public DialogSelectAnalyst(JDialog parent, boolean modal, SBdb sbdb, boolean showAllUsers) throws SQLException {
        super((Dialog)parent, modal);
        this.sbdb = sbdb;
        this.parent = parent;
        this.allUsers = showAllUsers;
        this.isSelectable = true;
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.loadUsers(this.allUsers);
        if (!this.isSelectable) {
            this.jButtonOK.setVisible(false);
            this.jButtonCancel.setText("Close");
            this.getRootPane().setDefaultButton(this.jButtonCancel);
            this.setTitle("Personnel");
        } else {
            this.setTitle("Analyst : Select");
            this.getRootPane().setDefaultButton(this.jButtonOK);
            this.jButtonMerge.setEnabled(false);
        }
        this.jTableUsers.setRowSorter(this.sorter);
        new ColumnSortResetHandler(this.jTableUsers).attach();
        SB.setTableHeaderBold((JTable)this.jTableUsers);
        for (int i = 0; i < this.model.maxColumn; ++i) {
            this.jTableUsers.getColumnModel().getColumn(i).setHeaderValue(columnHeaders[i]);
            this.jTableUsers.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        this.jTableUsers.setDefaultRenderer(Color.class, new ColourRenderer(true));
        this.jTableUsers.setSelectionMode(0);
        if (!this.allUsers) {
            this.jRadioButtonSBUsers.setSelected(true);
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            this.jButtonDelete.setEnabled(false);
            this.jButtonMerge.setEnabled(false);
        }
    }

    private void loadUsers(boolean allUsers) throws SQLException {
        this.allUsers = allUsers;
        this.model.users = new LinkedList<Userdef>();
        Collection<Userdef> c = this.sbdb.getUsers();
        for (Userdef u : c) {
            if (!allUsers && u.getPriv() <= 0) continue;
            this.model.users.add(u);
        }
        Collections.sort(this.model.users);
        this.model.fireTableDataChanged();
    }

    private Userdef getSelectedUserDef() {
        return this.model.users.get(this.jTableUsers.convertRowIndexToModel(this.jTableUsers.getSelectedRow()));
    }

    private void initComponents() {
        this.buttonGroupUsers = new ButtonGroup();
        this.jRadioButtonAllPersonell = new JRadioButton();
        this.jRadioButtonSBUsers = new JRadioButton();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonShowData = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableUsers = new JTable();
        this.jButtonMerge = new JButton();
        this.jButtonCountries = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 350));
        this.setModal(true);
        this.buttonGroupUsers.add(this.jRadioButtonAllPersonell);
        this.jRadioButtonAllPersonell.setSelected(true);
        this.jRadioButtonAllPersonell.setText("All personnel");
        this.jRadioButtonAllPersonell.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonAllPersonell.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonAllPersonell.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectAnalyst this$0;
            {
                DialogSelectAnalyst dialogSelectAnalyst = this$0;
                Objects.requireNonNull(dialogSelectAnalyst);
                this.this$0 = dialogSelectAnalyst;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonAllPersonellActionPerformed(evt);
            }
        });
        this.buttonGroupUsers.add(this.jRadioButtonSBUsers);
        this.jRadioButtonSBUsers.setText("Registered users only");
        this.jRadioButtonSBUsers.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonSBUsers.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonSBUsers.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectAnalyst this$0;
            {
                DialogSelectAnalyst dialogSelectAnalyst = this$0;
                Objects.requireNonNull(dialogSelectAnalyst);
                this.this$0 = dialogSelectAnalyst;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonSBUsersActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add..");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectAnalyst this$0;
            {
                DialogSelectAnalyst dialogSelectAnalyst = this$0;
                Objects.requireNonNull(dialogSelectAnalyst);
                this.this$0 = dialogSelectAnalyst;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectAnalyst this$0;
            {
                DialogSelectAnalyst dialogSelectAnalyst = this$0;
                Objects.requireNonNull(dialogSelectAnalyst);
                this.this$0 = dialogSelectAnalyst;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectAnalyst this$0;
            {
                DialogSelectAnalyst dialogSelectAnalyst = this$0;
                Objects.requireNonNull(dialogSelectAnalyst);
                this.this$0 = dialogSelectAnalyst;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonShowData.setText("Show data...");
        this.jButtonShowData.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonShowData.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectAnalyst this$0;
            {
                DialogSelectAnalyst dialogSelectAnalyst = this$0;
                Objects.requireNonNull(dialogSelectAnalyst);
                this.this$0 = dialogSelectAnalyst;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowDataActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectAnalyst this$0;
            {
                DialogSelectAnalyst dialogSelectAnalyst = this$0;
                Objects.requireNonNull(dialogSelectAnalyst);
                this.this$0 = dialogSelectAnalyst;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectAnalyst this$0;
            {
                DialogSelectAnalyst dialogSelectAnalyst = this$0;
                Objects.requireNonNull(dialogSelectAnalyst);
                this.this$0 = dialogSelectAnalyst;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectAnalyst this$0;
            {
                DialogSelectAnalyst dialogSelectAnalyst = this$0;
                Objects.requireNonNull(dialogSelectAnalyst);
                this.this$0 = dialogSelectAnalyst;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jTableUsers.setModel(this.model);
        this.jTableUsers.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectAnalyst this$0;
            {
                DialogSelectAnalyst dialogSelectAnalyst = this$0;
                Objects.requireNonNull(dialogSelectAnalyst);
                this.this$0 = dialogSelectAnalyst;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableUsersMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableUsers);
        this.jButtonMerge.setText("Merge...");
        this.jButtonMerge.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectAnalyst this$0;
            {
                DialogSelectAnalyst dialogSelectAnalyst = this$0;
                Objects.requireNonNull(dialogSelectAnalyst);
                this.this$0 = dialogSelectAnalyst;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMergeActionPerformed(evt);
            }
        });
        this.jButtonCountries.setText("Countries...");
        this.jButtonCountries.setToolTipText("Assign country access roles (SQL Server only)");
        this.jButtonCountries.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectAnalyst this$0;
            {
                DialogSelectAnalyst dialogSelectAnalyst = this$0;
                Objects.requireNonNull(dialogSelectAnalyst);
                this.this$0 = dialogSelectAnalyst;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCountriesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonSBUsers).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonAllPersonell).add((Component)this.jScrollPane1, -1, 435, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonShowData, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMerge, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCountries, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonAllPersonell).addPreferredGap(0).add((Component)this.jRadioButtonSBUsers, -2, 15, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonShowData).addPreferredGap(0).add((Component)this.jButtonMerge).addPreferredGap(1).add((Component)this.jButtonCountries).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 311, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jTableUsersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.isSelectable) {
                this.jButtonOKActionPerformed(null);
            } else {
                this.jButtonEditActionPerformed(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableUsers.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select a name from the list", "Warning", 2);
            return;
        }
        Userdef selected = this.getSelectedUserDef();
        if (this.sbdb.getUser().getUsrID() == selected.getUsrID()) {
            JOptionPane.showMessageDialog(this, "Cannot delete current user", "Warning", 2);
            return;
        }
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0 && selected.getPriv() > 0) {
            JOptionPane.showMessageDialog(this, "You do not have the privilege to modify this user's details", "Warning", 2);
            return;
        }
        Cursor c = this.getCursor();
        try {
            Userdef user = this.getSelectedUserDef();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (user.hasAnalyses()) {
                JOptionPane.showMessageDialog(this, "Cannot delete user/identity that has analyses.", "Warning", 2);
                return;
            }
            if (user.hasIGD()) {
                JOptionPane.showMessageDialog(this, "Cannot delete user/identity that has references to interpreted data", "Warning", 2);
                return;
            }
            int nAudit = user.getCountAudit();
            if (JOptionPane.showConfirmDialog(this, "Really delete person: " + String.valueOf(user) + " ?\nWarning: user ID is recorded in " + nAudit + " created/modified/updated records.", "Confirm User Delete", 0, 3) != 0) {
                return;
            }
            this.sbdb.deleteUser(user.getAbr());
            this.loadUsers(this.allUsers);
            this.sbdb.commit();
        }
        catch (RuntimeException | SQLException | SBPermissionException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        finally {
            this.setCursor(c);
        }
    }

    private void jRadioButtonAllPersonellActionPerformed(ActionEvent evt) {
        if (!this.allUsers) {
            try {
                this.loadUsers(true);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jRadioButtonSBUsersActionPerformed(ActionEvent evt) {
        if (this.allUsers) {
            try {
                this.loadUsers(false);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jButtonShowDataActionPerformed(ActionEvent evt) {
        if (this.jTableUsers.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "No item selected", this.getTitle(), 2);
            return;
        }
        try {
            Userdef user = this.getSelectedUserDef();
            DialogUserData dialog = new DialogUserData(this, true, user);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showDialogStackError(ex, this);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableUsers.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "No item selected", this.getTitle(), 2);
            return;
        }
        Userdef user = this.getSelectedUserDef();
        if (user.getPriv() > 0 && (this.sbdb.getUser().getPriv() & 0x40) == 0 && this.sbdb.getUser().getUsrID() != user.getUsrID()) {
            JOptionPane.showMessageDialog(this, "You have user privileges only: you can only edit your own or non-users' details", this.getTitle(), 2);
            return;
        }
        DialogUserdef dialog = new DialogUserdef(this, true, this.sbdb, user);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                this.loadUsers(this.allUsers);
                int index = this.getRowOf(dialog.getUser());
                if (index >= 0) {
                    this.jTableUsers.setRowSelectionInterval(index, index);
                } else {
                    this.jTableUsers.clearSelection();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private int getRowOf(Object o) {
        for (int i = 0; i < this.model.users.size(); ++i) {
            if (this.model.users.get(i) != o) continue;
            return i;
        }
        return -1;
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogUserdef dialog = new DialogUserdef(this, true, this.sbdb, null, null, null);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                this.loadUsers(this.allUsers);
                int i = this.model.users.indexOf(dialog.getUser());
                if (i >= 0) {
                    int index = this.jTableUsers.convertRowIndexToView(i);
                    this.jTableUsers.setRowSelectionInterval(index, index);
                } else {
                    this.jTableUsers.clearSelection();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableUsers.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "No item selected", this.getTitle(), 2);
            return;
        }
        this.selectedUser = this.getSelectedUserDef();
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogselectanalyst.html");
    }

    private void jButtonMergeActionPerformed(ActionEvent evt) {
        if (this.jTableUsers.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select a user to merge", this.getTitle(), 2);
            return;
        }
        this.selectedUser = this.getSelectedUserDef();
        if (this.selectedUser.getUsrID() == this.sbdb.getUser().getUsrID()) {
            JOptionPane.showMessageDialog(this, "You cannot merge the current user", this.getTitle(), 2);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "After this operation the control panel and all open modules will be closed.\nDo you want to continue?", "Merge Users", 2) == 0) {
            DialogMergeAnalysts dialog = new DialogMergeAnalysts(this, true, this.sbdb, this.model.users, this.selectedUser);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.completed && this.parent instanceof FrameJsbugs) {
                FrameJsbugs frame = (FrameJsbugs)this.parent;
                try {
                    frame.reconnect(true, true);
                    this.dispose();
                }
                catch (SQLException ex) {
                    JOptionPane.showMessageDialog(null, "SQL Error: " + ex.getMessage(), this.getTitle(), 0);
                    ex.printStackTrace();
                }
            }
        }
    }

    private void jButtonCountriesActionPerformed(ActionEvent evt) {
        if (this.sbdb.getDBType() != DBType.MSSQLSERVER) {
            JOptionPane.showMessageDialog(this, "This utility is only available on SQL server", this.getTitle(), 2);
            return;
        }
        if ((this.sbdb.getUser().getPriv() & 0x400) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a key user or super user to assign country roles.", this.getTitle(), 2);
            return;
        }
        Userdef user = null;
        if (this.jTableUsers.getSelectedRowCount() == 1 && (user = this.getSelectedUserDef()).getPriv() == 0) {
            JOptionPane.showMessageDialog(this, "Selected user must be a registered user to assign a country role.", this.getTitle(), 2);
            return;
        }
        try {
            if (!DialogCountryRoles.checkSecurityFunctionExists(this.sbdb)) {
                JOptionPane.showMessageDialog(this, "Row Level Security function not implemented: contact StrataData for details.", this.getTitle(), 2);
                return;
            }
            if (!DialogCountryRoles.checkDatabasePriv(this.sbdb)) {
                JOptionPane.showMessageDialog(this, "You do not have the database privilege required to set roles.\n(ALTER ANY USER required). Contact StrataData for details.", this.getTitle(), 2);
                return;
            }
            DialogCountryRoles dialog = new DialogCountryRoles(this, true, this.sbdb, user);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "SQL Error: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private static class TableModelUserdef
    extends AbstractTableModel {
        List<Userdef> users = null;
        int maxColumn = 5;

        private TableModelUserdef() {
        }

        @Override
        public int getColumnCount() {
            return this.maxColumn;
        }

        @Override
        public int getRowCount() {
            if (this.users == null) {
                return 0;
            }
            return this.users.size();
        }

        public void setSize(int i) {
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.users == null) {
                return "";
            }
            try {
                switch (col) {
                    default: {
                        return "";
                    }
                    case 0: {
                        return this.users.get(row).getName();
                    }
                    case 1: {
                        return this.users.get(row).getAbr();
                    }
                    case 2: {
                        return this.users.get(row).getSysName();
                    }
                    case 3: {
                        return this.users.get(row).getColour();
                    }
                    case 4: 
                }
                return this.users.get(row).getPriv() > 0;
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }

        public Class getColumnClass(int col) {
            switch (col) {
                default: {
                    return String.class;
                }
                case 3: {
                    return Color.class;
                }
                case 4: 
            }
            return Boolean.class;
        }
    }
}

