/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import model3.Sample;

public class SampleUtils {
    public static Sample findNearestSample(double depth, List<Sample> samples) {
        if (samples == null || samples.isEmpty()) {
            return null;
        }
        ArrayList<Sample> localSamples = new ArrayList<Sample>(samples);
        Collections.sort(localSamples, new Comparator<Sample>(){

            @Override
            public int compare(Sample o1, Sample o2) {
                return Double.compare(o1.getDepth(), o2.getDepth());
            }
        });
        Sample closest = null;
        Double closestDistance = null;
        for (Sample s : localSamples) {
            double distance = Math.abs(depth - s.getDepth());
            if (s.getDepth() > depth) {
                if (closestDistance == null || distance < closestDistance) {
                    closestDistance = distance;
                    closest = s;
                    break;
                }
                if (distance != closestDistance) break;
                return null;
            }
            closestDistance = distance;
            closest = s;
        }
        return closest;
    }
}

