/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.webservices.pbdb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jsbugs.webservices.WebCitationQuery;
import jsbugs.webservices.WebCitationService;
import jsbugs.webservices.pbdb.PbddQueryResponse;
import jsbugs.webservices.pbdb.Record;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class PbdbQuery
extends WebCitationQuery {
    private static final Logger LOGGER = Logger.getLogger(PbdbQuery.class.getName());

    @Override
    public String getCitationQueryUrl(Taxon taxon) {
        return "https://paleobiodb.org/data1.2/taxa/list.json?datainfo&rowcount&base_name=" + PbdbQuery.getUrlTaxonName(taxon) + "&rank=species&show=attr";
    }

    @Override
    public WebCitationService.WebCitation parseCitation(InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        PbddQueryResponse q = (PbddQueryResponse)mapper.readValue(inputStream, PbddQueryResponse.class);
        if (q.getRecordsFound() == 0) {
            return null;
        }
        Record record = q.getRecords().get(0);
        String citation = record.getAttribution();
        String source = "PBDB";
        String citationUrl = PbdbQuery.getCitationUrl(record.getId());
        return new WebCitationService.WebCitation(2, source, citation, citationUrl);
    }

    private static String getCitationUrl(String recordId) {
        Object citationUrl = "";
        if (!StringUtils.isBlank((CharSequence)recordId)) {
            citationUrl = "https://paleobiodb.org/data1.2/taxa/single.json?id=" + recordId + "&show=attr";
        }
        return citationUrl;
    }

    @Override
    public String getSearchQueryUrl(Taxon taxon) {
        if (!taxon.getGenus().getSubGenus().isEmpty()) {
            LOGGER.warning("Disregarding sub genus");
            taxon.getGenus().setSubGenus("");
        }
        if (taxon.getGenus().getGenusName().endsWith("%") || taxon.getGenus().getGenusName().endsWith(".")) {
            String genusName = taxon.getGenus().getGenusName();
            taxon.getGenus().setGenusName(genusName.substring(0, genusName.length() - 1));
        }
        taxon.getGenus().setGenusName(taxon.getGenus().getGenusName() + ".");
        boolean wildcardSpecies = true;
        if (taxon.getSpecies().isEmpty() || taxon.getSpecies().endsWith("%") || !taxon.getSubSpecies().isEmpty()) {
            wildcardSpecies = false;
        }
        if (wildcardSpecies) {
            taxon.setSpecies(taxon.getSpecies() + "%");
        }
        String queryName = taxon.toString(false, false).trim().replaceAll(" ", "%20");
        return "https://paleobiodb.org/data1.2/taxa/list.json?datainfo&rowcount&base_name=" + queryName + "&rank=species&show=attr";
    }

    @Override
    public List<WebCitationService.CitedTaxon> parseTaxa(InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        PbddQueryResponse q = (PbddQueryResponse)mapper.readValue(inputStream, PbddQueryResponse.class);
        ArrayList<WebCitationService.CitedTaxon> taxa = new ArrayList<WebCitationService.CitedTaxon>();
        for (Record record : q.getRecords()) {
            String taxonName = record.getTaxonName();
            Taxon taxon = TaxonFactory.parse((String)taxonName);
            taxon.setAuthor(StringEscapeUtils.unescapeHtml4((String)record.getAttribution()));
            taxon.setUrl(PbdbQuery.getCitationUrl(record.getId()));
            taxa.add(new WebCitationService.CitedTaxon(taxon, new WebCitationService.WebCitation(2, WebCitationService.SERVICE_NAMES[2], null, taxon.getUrl())));
        }
        return taxa;
    }
}

