/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wellheader;

import com.stratadata.model3.well.WellHeader;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;
import jsbugs.TableModelSB;
import model3.SBRestrictable;
import model3.SBdb;

class TableModelWells
extends TableModelSB {
    List<WellHeader> results;
    int maxColumn = columnHeaders.length;
    static final int COLWELLNAME = 0;
    static final int COLWELLALTNAME = 1;
    static final int COLWELLCODE = 2;
    static final int COLCOUNTRY = 3;
    static final int COLSECTIONTYPE = 4;
    static final int COLOPER = 5;
    static final int COLCLIENT = 6;
    static final int COLFIELD = 7;
    static final int COLBASIN = 8;
    static final int COLAREA = 9;
    static final int COLCOUNTY = 10;
    static final int COLSTATE = 11;
    static final int COLPERM = 12;
    static String[] columnHeaders = new String[]{"Well Name", "Well Alt Name", "Well Code", "Country", "Type", "Operator", "Client", "Field", "Basin", "Area", "County", "State", "Access"};
    static int[] columnWidths = new int[]{90, 70, 90, 90, 90, 90, 70, 70, 90, 90, 90, 90, 90};

    TableModelWells(boolean showAllFields) {
        this.maxColumn = showAllFields ? columnHeaders.length : 4;
    }

    @Override
    public int getColumnCount() {
        return this.maxColumn;
    }

    @Override
    public int getRowCount() {
        if (this.results == null) {
            return 0;
        }
        return this.results.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.results == null) {
            return "";
        }
        WellHeader result = this.results.get(row);
        return switch (col) {
            case 0 -> result.getWellName();
            case 1 -> result.getWellAltName();
            case 2 -> result.getWellCode();
            case 3 -> result.getCountry();
            case 4 -> result.getSectionType().getStringType();
            case 7 -> result.getField();
            case 8 -> result.getBasin();
            case 9 -> result.getArea();
            case 5 -> result.getOperator();
            case 6 -> result.getClient();
            case 10 -> result.getCounty();
            case 12 -> SBRestrictable.getPermissionString(result.getAcm());
            case 11 -> result.getLocState();
            default -> "";
        };
    }

    public Class getColumnClass(int c) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    @Override
    public String getPrefString() {
        return "TABLESW";
    }

    @Override
    public String getPrefOrderString() {
        return "TABLESWO";
    }

    @Override
    public String getAutoResizeString() {
        return "TABLESWRZ";
    }

    @Override
    public int[] getDefaultColumnWidths() {
        return columnWidths;
    }

    @Override
    public String[] getColumnTitles() {
        return columnHeaders;
    }

    @Override
    public void setupTable(JTable table, SBdb sbdb) {
        assert (false);
    }

    void setupTable(JTable jTableWells, boolean tips, SBdb sbdb) {
        this.init(jTableWells, sbdb);
        jTableWells.setRowSorter(new TableRowSorter<TableModelWells>(this));
        new ColumnSortResetHandler(jTableWells).attach();
        if (tips) {
            // empty if block
        }
    }
}

