/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogMatchCasing;
import jsbugs.FrameJsbugs;
import jsbugs.wells.DialogCasingPoint;
import jsbugs.wells.ModelessWellInfoDialog;
import model3.Casing;
import model3.CasingPoint;
import model3.SBdb;
import model3.Well;
import model3.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogCasing
extends ModelessWellInfoDialog
implements Observer {
    private static final String[] titles = new String[]{"Depth", "Diameter"};
    private static final int[] widths = new int[]{30, 30};
    private final Well well;
    private final TableModelCasing model = new TableModelCasing(this);
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonMatch;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JScrollPane jScrollPane1;
    private JTable jTableCasing;

    public DialogCasing(Frame parent, boolean modal, Well well) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        Font font = this.jTableCasing.getTableHeader().getFont();
        font = new Font(font.getName(), 1, font.getSize());
        this.jTableCasing.getTableHeader().setFont(font);
        TableColumnModel columnModel = this.jTableCasing.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(titles[i]);
            columnModel.getColumn(i).setWidth(widths[i]);
        }
        this.setTitle("Casing : " + this.well.getWellName());
        this.model.casing = this.well.getCasing(true);
        this.model.units = this.well.getWellUnits();
        this.buttonGroupUnits.setSelected(this.model.units == 'F' ? this.jRadioButtonFeet.getModel() : this.jRadioButtonMetres.getModel(), true);
        this.jTableCasing.repaint();
        this.testMaster();
        this.setObserver();
        this.getRootPane().setDefaultButton(this.jButtonClose);
        if (!this.well.canWrite(this.well.getDataModel(), null)) {
            this.jButtonDelete.setEnabled(false);
        }
    }

    @Override
    public void update(Observable obs, Object obj) {
        try {
            if (obs == this.well.getCasing()) {
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in update method: " + String.valueOf(e));
            e.printStackTrace();
        }
    }

    @Override
    public void testMaster() {
        try {
            if (!this.well.getDataModel().hasCasingMaster()) {
                this.jButtonMatch.setVisible(false);
            } else if (!this.well.getCasing().updateFromMaster(this.well.getWellID(), this.well.getWellCode())) {
                JOptionPane.showMessageDialog(this.getParent(), "Master casing table is different: use Match for comparison", "Casing", 2);
            }
        }
        catch (SQLException | SBException | SBPermissionException e) {
            JOptionPane.showMessageDialog(this.getParent(), "Error from casing_master update: " + e.getMessage(), "Casing", 2);
            e.printStackTrace();
        }
    }

    @Override
    public Well getWell() {
        return this.well;
    }

    private void initComponents() {
        this.jButtonEdit = new JButton();
        this.buttonGroupUnits = new ButtonGroup();
        this.jButtonClose = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonAdd = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCasing = new JTable();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jButtonMatch = new JButton();
        this.jButtonEdit.setText("Edit...");
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(257, 189));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasing this$0;
            {
                DialogCasing dialogCasing = this$0;
                Objects.requireNonNull(dialogCasing);
                this.this$0 = dialogCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasing this$0;
            {
                DialogCasing dialogCasing = this$0;
                Objects.requireNonNull(dialogCasing);
                this.this$0 = dialogCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.setMaximumSize(new Dimension(59, 23));
        this.jButtonHelp.setMinimumSize(new Dimension(59, 23));
        this.jButtonHelp.setPreferredSize(new Dimension(59, 23));
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasing this$0;
            {
                DialogCasing dialogCasing = this$0;
                Objects.requireNonNull(dialogCasing);
                this.this$0 = dialogCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.setPreferredSize(new Dimension(93, 23));
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasing this$0;
            {
                DialogCasing dialogCasing = this$0;
                Objects.requireNonNull(dialogCasing);
                this.this$0 = dialogCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jTableCasing.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCasing);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Depth units", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasing this$0;
            {
                DialogCasing dialogCasing = this$0;
                Objects.requireNonNull(dialogCasing);
                this.this$0 = dialogCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMetresActionPerformed(evt);
            }
        });
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasing this$0;
            {
                DialogCasing dialogCasing = this$0;
                Objects.requireNonNull(dialogCasing);
                this.this$0 = dialogCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonFeetActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonMetres).addPreferredGap(0).add((Component)this.jRadioButtonFeet).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonMetres, -2, 16, -2).add((Component)this.jRadioButtonFeet, -2, 16, -2)).add(0, 1, Short.MAX_VALUE)));
        this.jButtonMatch.setText("Master...");
        this.jButtonMatch.setToolTipText("Match casing points from master table/view");
        this.jButtonMatch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasing this$0;
            {
                DialogCasing dialogCasing = this$0;
                Objects.requireNonNull(dialogCasing);
                this.this$0 = dialogCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMatchActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 154, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMatch, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -2, 0, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 181, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonMatch).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCasing.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 1);
            return;
        }
        try {
            LinkedList<CasingPoint> toDelete = new LinkedList<CasingPoint>();
            for (int row : this.jTableCasing.getSelectedRows()) {
                CasingPoint casing = this.model.casing.getCasingPoint(row);
                toDelete.add(casing);
            }
            if (toDelete.size() > 0) {
                String msg = "Really delete " + (String)(toDelete.size() == 1 ? "this casing point?" : "these " + toDelete.size() + " casing points?");
                int option = JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3);
                if (option != 0) {
                    return;
                }
                this.well.deleteCasingPoints(toDelete);
                this.well.getDataModel().commit();
                this.jTableCasing.clearSelection();
                this.model.casing.notifyObservers();
                this.model.fireTableDataChanged();
                this.well.setDataChanged();
                this.well.notifyObservers(toDelete.get(0));
            }
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.well.getDataModel());
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogCasingPoint dialog = new DialogCasingPoint(this, true, this.well, this.model.units);
            dialog.setLocation(this.getLocation().x + 25, this.getLocation().y + 25);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error starting casing point dialog: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogcasing.html");
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        this.setModelUnits('M');
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        this.setModelUnits('F');
    }

    private void jButtonMatchActionPerformed(ActionEvent evt) {
        try {
            SBdb ws = new SBdb(this.well.getDataModel());
            this.well.loadInterps();
            WsWell wsWell = ws.addWellToWorkspace(this.well);
            DialogMatchCasing dialog = new DialogMatchCasing(this, false, ws, wsWell, this.well.getWellUnits());
            dialog.setLocationRelativeTo(this);
            dialog.load();
            dialog.setVisible(true);
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException se) {
            StackError.showStackError((Exception)se);
        }
    }

    void setObserver() throws SQLException {
        this.model.casing = this.well.getCasing();
        this.model.casing.addObserver(this);
    }

    private void setModelUnits(char c) {
        if (this.model.units != c) {
            this.model.units = c;
            this.model.fireTableDataChanged();
        }
    }

    private class TableModelCasing
    extends AbstractTableModel {
        char units;
        Casing casing;
        final /* synthetic */ DialogCasing this$0;

        private TableModelCasing(DialogCasing dialogCasing) {
            DialogCasing dialogCasing2 = dialogCasing;
            Objects.requireNonNull(dialogCasing2);
            this.this$0 = dialogCasing2;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.casing == null) {
                return 0;
            }
            return this.casing.getSize();
        }

        @Override
        public Object getValueAt(int row, int col) {
            CasingPoint casingPoint = this.casing.getCasingPoint(row);
            switch (col) {
                case 0: {
                    return SB.getDepthString((double)casingPoint.getDepth(), (char)this.units, (int)2);
                }
                case 1: {
                    return casingPoint;
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            switch (col) {
                default: 
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return CasingPoint.class;
                }
            }
            return Object.class;
        }

        public void load(Casing casing, char units) {
            this.casing = casing;
        }
    }
}

