/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import com.stratadata.util.ui.HelpUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogCoreImages;
import jsbugs.DialogCoreShifts;
import jsbugs.DialogMatchCores;
import jsbugs.wells.DialogCoredInterval;
import jsbugs.wells.ModelessWellInfoDialog;
import model3.CoredInterval;
import model3.Cores;
import model3.SBdb;
import model3.Well;
import model3.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogCores
extends ModelessWellInfoDialog
implements Observer {
    private final TableModelCores model = new TableModelCores();
    private final Well well;
    private static final Logger LOGGER = Logger.getLogger(DialogCores.class.getName());
    private ButtonGroup buttonGroupDepthUnits;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonImages;
    private JButton jButtonMatch;
    private JButton jButtonShifts;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableCores;

    public DialogCores(Frame parent, boolean modal, Well well) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.initComponents();
        this.init();
    }

    @Override
    public void update(Observable obs, Object obj) {
        try {
            if (obs == this.well.getCores()) {
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException | SBException e) {
            LOGGER.log(Level.WARNING, "Exception in update method: ", e);
        }
    }

    @Override
    public Well getWell() {
        return this.well;
    }

    private void init() throws SQLException, SBException {
        SB.setTableHeaderBold((JTable)this.jTableCores);
        TableColumnModel columnModel = this.jTableCores.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelCores.titles[i]);
            columnModel.getColumn(i).setWidth(TableModelCores.widths[i]);
        }
        this.setTitle("Cores : " + this.well.getWellName());
        this.jTableCores.repaint();
        this.model.setWell(this.well);
        this.buttonGroupDepthUnits.setSelected(this.model.units == 'F' ? this.jRadioButtonFeet.getModel() : this.jRadioButtonMetres.getModel(), true);
        this.testMaster();
        this.model.cores.addObserver(this);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        if (!this.well.canWrite(this.well.getDataModel(), null)) {
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroupDepthUnits = new ButtonGroup();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCores = new JTable();
        this.jButtonImages = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jButtonShifts = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jButtonMatch = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(550, 335));
        ResourceBundle bundle = ResourceBundle.getBundle("locale/UiText");
        this.jButtonAdd.setText(bundle.getString("button.add"));
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCores this$0;
            {
                DialogCores dialogCores = this$0;
                Objects.requireNonNull(dialogCores);
                this.this$0 = dialogCores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText(bundle.getString("button.edit"));
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCores this$0;
            {
                DialogCores dialogCores = this$0;
                Objects.requireNonNull(dialogCores);
                this.this$0 = dialogCores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText(bundle.getString("button.delete"));
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCores this$0;
            {
                DialogCores dialogCores = this$0;
                Objects.requireNonNull(dialogCores);
                this.this$0 = dialogCores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText(bundle.getString("button.close"));
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCores this$0;
            {
                DialogCores dialogCores = this$0;
                Objects.requireNonNull(dialogCores);
                this.this$0 = dialogCores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTableCores.setModel(this.model);
        this.jTableCores.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogCores this$0;
            {
                DialogCores dialogCores = this$0;
                Objects.requireNonNull(dialogCores);
                this.this$0 = dialogCores;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableCoresMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableCores);
        this.jButtonImages.setText(bundle.getString("button.images"));
        this.jButtonImages.setMargin(new Insets(2, 12, 2, 12));
        this.jButtonImages.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCores this$0;
            {
                DialogCores dialogCores = this$0;
                Objects.requireNonNull(dialogCores);
                this.this$0 = dialogCores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonImagesActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText(bundle.getString("button.help"));
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCores this$0;
            {
                DialogCores dialogCores = this$0;
                Objects.requireNonNull(dialogCores);
                this.this$0 = dialogCores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonShifts.setText(bundle.getString("DialogCores.button.shifts"));
        this.jButtonShifts.setToolTipText("Show core shifts/corrections");
        this.jButtonShifts.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCores this$0;
            {
                DialogCores dialogCores = this$0;
                Objects.requireNonNull(dialogCores);
                this.this$0 = dialogCores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShiftsActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("DialogCores.depthUnits"), 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupDepthUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText(bundle.getString("depth.units.m"));
        this.jRadioButtonMetres.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCores this$0;
            {
                DialogCores dialogCores = this$0;
                Objects.requireNonNull(dialogCores);
                this.this$0 = dialogCores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMetresActionPerformed(evt);
            }
        });
        this.buttonGroupDepthUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText(bundle.getString("depth.units.f"));
        this.jRadioButtonFeet.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCores this$0;
            {
                DialogCores dialogCores = this$0;
                Objects.requireNonNull(dialogCores);
                this.this$0 = dialogCores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonFeetActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonMetres).addPreferredGap(0).add((Component)this.jRadioButtonFeet).add(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonMetres, -2, 16, -2).add((Component)this.jRadioButtonFeet, -2, 16, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonMatch.setText(bundle.getString("button.match"));
        this.jButtonMatch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCores this$0;
            {
                DialogCores dialogCores = this$0;
                Objects.requireNonNull(dialogCores);
                this.this$0 = dialogCores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMatchActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 429, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -2, 73, -2)).add((Component)this.jButtonMatch).add(2, (GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jSeparator1).add(2, (Component)this.jButtonShifts, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonImages, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonMatch).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonImages).addPreferredGap(0).add((Component)this.jButtonShifts).addPreferredGap(0, 26, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jTableCoresMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        int row = this.jTableCores.getSelectedRow();
        if (row < 0) {
            JOptionPane.showMessageDialog(this, "No cores selected", this.getTitle(), 1);
            return;
        }
        CoredInterval core = this.model.cores.getCore(row);
        try {
            DialogCoredInterval dialog = new DialogCoredInterval(this, true, this.well, core, this.model.units);
            dialog.setLocation(this.getLocation().x + 20, this.getLocation().y + 20);
            dialog.setVisible(true);
        }
        catch (SQLException | SBException e) {
            JOptionPane.showMessageDialog(this, "Error constructing cores dialog", this.getTitle(), 0);
            LOGGER.log(Level.WARNING, "Error constructing cores dialog", e);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogCoredInterval dialog = new DialogCoredInterval(this, true, this.well, null, this.model.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException | SBException sbe) {
            StackError.showStackError((String)"Error opening cores dialog", (Throwable)sbe);
            LOGGER.log(Level.WARNING, "Error opening cores dialog", sbe);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCores.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No cores selected", this.getTitle(), 1);
            return;
        }
        try {
            LinkedList<CoredInterval> toDelete = new LinkedList<CoredInterval>();
            for (int row : this.jTableCores.getSelectedRows()) {
                CoredInterval core = this.model.cores.getCore(row);
                toDelete.add(core);
            }
            if (!toDelete.isEmpty()) {
                String msg = "Really delete " + (String)(toDelete.size() == 1 ? "this cored interval?" : "these " + toDelete.size() + " cored intervals?");
                int option = JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3);
                if (option != 0) {
                    return;
                }
                this.well.deleteCoredIntervals(toDelete);
                this.jTableCores.clearSelection();
                this.model.cores.notifyObservers();
                this.well.setDataChanged();
                this.well.notifyObservers(toDelete.get(0));
            }
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            this.well.getDataModel().doRollback();
            LOGGER.log(Level.WARNING, "Error", sql);
            StackError.showStackError((String)"Error", (Throwable)sql);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonImagesActionPerformed(ActionEvent evt) {
        try {
            DialogCoreImages dialog = new DialogCoreImages((Frame)this.getParent(), false, this.well);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException | SBException sql) {
            LOGGER.log(Level.WARNING, "Error", sql);
            StackError.showStackError((String)"Error", (Throwable)sql);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogcores.html");
    }

    private void jButtonShiftsActionPerformed(ActionEvent evt) {
        try {
            DialogCoreShifts dialog = new DialogCoreShifts(this, true, this.well, this.model.units);
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width - this.getX() - this.getWidth() > dialog.getWidth()) {
                dialog.setLocation(this.getX() + this.getWidth(), this.getY());
            } else {
                dialog.setLocationRelativeTo(this);
            }
            dialog.setVisible(true);
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            LOGGER.log(Level.WARNING, "Error", sql);
            StackError.showStackError((String)"Error", (SQLException)sql);
        }
    }

    @Override
    public void testMaster() {
        try {
            if (!this.well.getDataModel().hasCoresMaster()) {
                this.jButtonMatch.setVisible(false);
            } else if (!this.well.getCores().updateFromMaster(this.well.getWellID(), this.well.getWellCode())) {
                JOptionPane.showMessageDialog(this.getParent(), "Master cores table is different: use Match for comparison", "Cores", 2);
            }
        }
        catch (SQLException | SBException | SBPermissionException e) {
            JOptionPane.showMessageDialog(this.getParent(), "Error from cores_master update: " + e.getMessage(), "Coes", 2);
            LOGGER.log(Level.WARNING, "Error", e);
        }
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        this.setModelUnits('M');
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        this.setModelUnits('F');
    }

    private void jButtonMatchActionPerformed(ActionEvent evt) {
        try {
            SBdb ws = new SBdb(this.well.getDataModel());
            this.well.loadInterps();
            WsWell wsWell = ws.addWellToWorkspace(this.well);
            DialogMatchCores dialog = new DialogMatchCores(this, false, ws, wsWell, this.well.getWellUnits());
            dialog.setLocationRelativeTo(this);
            dialog.load();
            dialog.setVisible(true);
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException se) {
            StackError.showStackError((Exception)se);
        }
    }

    private void setModelUnits(char c) {
        if (this.model.units != c) {
            this.model.units = c;
            this.model.fireTableDataChanged();
        }
    }

    private static class TableModelCores
    extends AbstractTableModel {
        char units;
        Cores cores;
        Well well;
        static Boolean recovered = true;
        static Boolean notRecovered = false;
        static String[] titles = new String[]{"Top", "Base", "Number", "Recovered?", "+/- top", "+/- base"};
        static int[] widths = new int[]{30, 30, 30, 15, 20, 20};

        private TableModelCores() {
        }

        @Override
        public int getColumnCount() {
            return titles.length;
        }

        @Override
        public int getRowCount() {
            if (this.cores == null) {
                return 0;
            }
            return this.cores.getSize();
        }

        void setWell(Well well) throws SQLException, SBException {
            this.well = well;
            this.cores = well.getCores();
            this.units = well.getWellUnits();
        }

        @Override
        public Object getValueAt(int row, int col) {
            CoredInterval core = this.cores.getCore(row);
            switch (col) {
                case 0: {
                    return SB.getDepthString((double)core.getTopDepth(), (char)this.units, (int)2);
                }
                case 1: {
                    return SB.getDepthString((double)core.getBaseDepth(), (char)this.units, (int)2);
                }
                case 2: {
                    return core;
                }
                case 3: {
                    return core.getRecovered() ? recovered : notRecovered;
                }
                case 4: {
                    try {
                        Float deltaTop = core.getDeltaTop(this.well);
                        if (deltaTop != null) {
                            return SB.getDepthString((double)deltaTop.floatValue(), (char)this.units, (int)2);
                        }
                        return "";
                    }
                    catch (SQLException e) {
                        LOGGER.log(Level.WARNING, "Exception in table cores.getValueAt ", e);
                        return e.getMessage();
                    }
                }
                case 5: {
                    try {
                        Float deltaBase = core.getDeltaBase(this.well);
                        if (deltaBase != null) {
                            return SB.getDepthString((double)deltaBase.floatValue(), (char)this.units, (int)2);
                        }
                        return "";
                    }
                    catch (SQLException e) {
                        LOGGER.log(Level.WARNING, "Exception in table cores.getValueAt ", e);
                        return e.getMessage();
                    }
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            switch (col) {
                default: 
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: 
                case 4: 
                case 5: {
                    return String.class;
                }
                case 2: {
                    return CoredInterval.class;
                }
                case 3: 
                case 6: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public void load(Cores cores, char units) {
            this.cores = cores;
        }
    }
}

