/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.external.WebServiceDescription;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.curve.Curve;
import com.stratadata.model3.well.curve.Curves;
import com.stratadata.model3.well.curve.WellCurveService;
import com.stratadata.model3.well.curve.WitsmlCurveHeader;
import com.stratadata.model3.well.curve.WitsmlCurveHeaderService;
import com.stratadata.model3.well.curve.WitsmlCurveService;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogFilePreview;
import jsbugs.DialogSelectVersion;
import jsbugs.table.ColouredRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.wells.DialogCurve;
import jsbugs.wells.DialogCurveReader;
import jsbugs.wells.DialogWitsmlImport;
import jsbugs.wells.ModelessWellInfoDialog;
import model3.Lastval;
import model3.LogFile;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import model3.exception.SuppressedSQLException;
import org.apache.commons.lang3.StringUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;

public class DialogCurves
extends ModelessWellInfoDialog
implements WellCurveService.Listener {
    private static final Logger LOGGER = Logger.getLogger(DialogCurves.class.getName());
    private static final String[] COL_TITLES = new String[]{"Abr.", "Type", "Mnemonic", "Top", "Base", "Source", "Comment", "Active"};
    private static final int[] COL_WIDTHS = new int[]{30, 60, 30, 20, 20, 80, 120, 30};
    private final TableModelCurves model = new TableModelCurves(this);
    private final Well well;
    private List<TableModelCurves.CurveTableRow> curveList = new ArrayList<TableModelCurves.CurveTableRow>();
    private LogFile logFile = null;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonRead;
    private JButton jButtonSaveAs;
    private JButton jButtonWITSML;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTable jTableCurves;

    public DialogCurves(Frame parent, boolean modal, Well well) throws SQLException, SBException {
        super(parent, modal);
        this.initComponents();
        this.well = well;
        this.init(well);
    }

    private void init(Well well) throws SQLException {
        this.initCurves();
        this.model.setupTable(this.jTableCurves);
        this.setTitle("Wireline Logs : " + well.getWellName());
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jTableCurves.setRowSorter(new TableRowSorter<TableModelCurves>(this.model));
        new ColumnSortResetHandler(this.jTableCurves).attach();
        this.model.fireTableDataChanged();
        if (!well.canWrite(well.getDataModel(), null)) {
            this.jButtonRead.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
            this.jButtonWITSML.setEnabled(false);
        }
        well.getCurves().addListener(this);
    }

    private void initCurves() throws SQLException {
        this.curveList = new ArrayList<TableModelCurves.CurveTableRow>();
        Curves dbCurves = this.well.getCurves();
        for (Curve curve : dbCurves.getCurves(false)) {
            this.curveList.add(new CurveRow(this, curve));
        }
        if (this.well.getDataModel().hasWITSML()) {
            WitsmlCurveHeaderService witsmlCurveHeaderService = this.well.getWitsmlCurveHeaderService();
            WitsmlCurveService witsmlCurveService = this.well.getWitsmlCurveService();
            List<Curve> witsmlCurves = witsmlCurveService.getCurves(false);
            for (WitsmlCurveHeader header : witsmlCurveHeaderService.getWitsmlCurveHeaders()) {
                if (StringUtils.isBlank((CharSequence)header.abr())) continue;
                Curve curve = witsmlCurves.stream().filter(c -> c.getMnem().equals(header.mnemonic())).findFirst().orElse(null);
                this.curveList.add(new WitsmlRow(this, header, curve));
            }
        }
        this.curveList.sort(Comparator.comparing(TableModelCurves.CurveTableRow::getAbr));
    }

    public void curveListUpdated() {
        try {
            this.initCurves();
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException | SQLException e) {
            LOGGER.log(Level.WARNING, "Error updating DialogCurves", e);
        }
    }

    @Override
    public Well getWell() {
        return this.well;
    }

    private List<TableModelCurves.CurveTableRow> getSelectedCurves() {
        LinkedList<TableModelCurves.CurveTableRow> selected = new LinkedList<TableModelCurves.CurveTableRow>();
        int[] selection = this.jTableCurves.getSelectedRows();
        for (int i = 0; i < selection.length; ++i) {
            selected.add(this.curveList.get(this.jTableCurves.convertRowIndexToModel(selection[i])));
        }
        return selected;
    }

    private TableModelCurves.CurveTableRow getSelectedCurve() {
        if (this.jTableCurves.getSelectedRow() < 0) {
            return null;
        }
        return this.curveList.get(this.jTableCurves.convertRowIndexToModel(this.jTableCurves.getSelectedRow()));
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCurves = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonRead = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonEdit = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonSaveAs = new JButton();
        this.jButtonWITSML = new JButton();
        this.jSeparator3 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(550, 250));
        this.jTableCurves.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCurves);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurves this$0;
            {
                DialogCurves dialogCurves = this$0;
                Objects.requireNonNull(dialogCurves);
                this.this$0 = dialogCurves;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.setToolTipText("Import curves from LAS or TXT files (also drag and drop files in Wells & Outcrops)");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurves this$0;
            {
                DialogCurves dialogCurves = this$0;
                Objects.requireNonNull(dialogCurves);
                this.this$0 = dialogCurves;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurves this$0;
            {
                DialogCurves dialogCurves = this$0;
                Objects.requireNonNull(dialogCurves);
                this.this$0 = dialogCurves;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurves this$0;
            {
                DialogCurves dialogCurves = this$0;
                Objects.requireNonNull(dialogCurves);
                this.this$0 = dialogCurves;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.setToolTipText("");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurves this$0;
            {
                DialogCurves dialogCurves = this$0;
                Objects.requireNonNull(dialogCurves);
                this.this$0 = dialogCurves;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.setToolTipText("Save selected curve in age scale");
        this.jButtonSaveAs.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurves this$0;
            {
                DialogCurves dialogCurves = this$0;
                Objects.requireNonNull(dialogCurves);
                this.this$0 = dialogCurves;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsActionPerformed(evt);
            }
        });
        this.jButtonWITSML.setText("WITSML...");
        this.jButtonWITSML.setToolTipText("Read curves from WITSML server");
        this.jButtonWITSML.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurves this$0;
            {
                DialogCurves dialogCurves = this$0;
                Objects.requireNonNull(dialogCurves);
                this.this$0 = dialogCurves;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWITSMLActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 546, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonClose, -2, 83, -2).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator2).addComponent(this.jButtonEdit, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonWITSML).addComponent(this.jButtonRead, GroupLayout.Alignment.TRAILING)).addComponent(this.jButtonSaveAs).addComponent(this.jButtonDelete, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addComponent(this.jSeparator3, -2, 83, -2)).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonDelete, this.jButtonEdit, this.jButtonHelp, this.jButtonRead, this.jButtonSaveAs, this.jSeparator2);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonWITSML).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveAs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 115, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        if (this.curveList.stream().anyMatch(row -> row.getCurve() != null && !row.getCurve().isActive())) {
            JOptionPane.showMessageDialog(this, "Inactive logs will be restored next time you open StrataBugs.", this.getTitle(), 2);
        }
        this.dispose();
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.well.getDataModel(), "WINLOGIMP", "UNXLOGIMP"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                Lastval.putString(this.well.getDataModel(), "WINLOGIMP", "UNXLOGIMP", file.getPath());
                this.well.getDataModel().commit();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error storing preference", e);
            }
            this.importFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(File file) {
        DialogCurveReader dialog;
        if (this.logFile != null && !file.getPath().equals(this.logFile.getPath())) {
            this.logFile = null;
        }
        if (this.logFile == null) {
            try {
                this.logFile = new LogFile(file);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Could not parse log file", this.getTitle(), 0);
                return;
            }
            if (this.logFile.hasformatException()) {
                JOptionPane.showMessageDialog(this, "Warning: there were errors encountered during file read. Check for missing or suspicious log values.", this.getTitle(), 2);
            } else if (this.logFile.hasUnreadColumns()) {
                JOptionPane.showMessageDialog(this, "Warning: the following columns could not be read because the format is not supported:\n" + this.logFile.getUnreadColumns(), this.getTitle(), 2);
            }
        }
        try {
            dialog = new DialogCurveReader(this, true, this.well, this.logFile);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sqlException) {
            SbugsExceptionHandler.showDialogStackError(sqlException, this);
            return;
        }
        if (dialog.isOK()) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                ArrayList<Curve> newCurves = new ArrayList<Curve>();
                for (int i = 0; i < dialog.logDef.length; ++i) {
                    Curve curve;
                    if (!dialog.getCurve[i]) continue;
                    try {
                        curve = this.logFile.parseCurve(dialog.units, dialog.logDef[i], i, dialog.depthFilter, this.well.getType(), dialog.comment[i]);
                    }
                    catch (RuntimeException e) {
                        JOptionPane.showMessageDialog(this, "Error reading curve: " + String.valueOf(dialog.logDef[i]));
                        LOGGER.log(Level.WARNING, "Error reading curve" + String.valueOf(dialog.logDef[i]), e);
                        DialogFilePreview dialogFilePreview = new DialogFilePreview(this, true, file.getPath());
                        dialogFilePreview.setLocationRelativeTo(this);
                        dialogFilePreview.setVisible(true);
                        this.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    if (curve.getTopDepth() == null) {
                        JOptionPane.showMessageDialog(this, "Could not read any data from file for curve: " + String.valueOf(dialog.logDef[i]));
                        continue;
                    }
                    if (this.well.getCurves().checkOverlap(curve)) {
                        int opt = JOptionPane.showConfirmDialog(this, "The curve:" + dialog.logDef[i].getAbr() + " overlaps other curves in the database. Continue to add curve (not recommended)?", "Curves overlap", 1);
                        if (opt == 2) break;
                        if (opt == 1) continue;
                    }
                    newCurves.add(curve);
                }
                if (newCurves.isEmpty()) {
                    return;
                }
                this.well.addAndStoreCurves(newCurves);
            }
            catch (RuntimeException | SQLException | SBPermissionException e) {
                SbugsExceptionHandler.showStackError("Error adding curves to database", e, this);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        List<TableModelCurves.CurveTableRow> toDelete = this.getSelectedCurves();
        if (this.getSelectedCurves().isEmpty()) {
            JOptionPane.showMessageDialog(this, "No curves selected", this.getTitle(), 1);
            return;
        }
        int opt = JOptionPane.showConfirmDialog(this, "Really delete " + (String)(toDelete.size() == 1 ? "this curve?" : "these " + toDelete.size() + " curves?"), this.getTitle(), 0, 3);
        if (opt != 0) {
            return;
        }
        ArrayList<Curve> deleteFromDatabase = new ArrayList<Curve>();
        ArrayList<WitsmlCurveHeader> deleteFromWitsml = new ArrayList<WitsmlCurveHeader>();
        for (TableModelCurves.CurveTableRow row : toDelete) {
            if (row instanceof CurveRow) {
                CurveRow dRow = (CurveRow)row;
                deleteFromDatabase.add(dRow.curve);
                continue;
            }
            if (!(row instanceof WitsmlRow)) continue;
            WitsmlRow wRow = (WitsmlRow)row;
            deleteFromWitsml.add(wRow.header);
        }
        try {
            if (!deleteFromDatabase.isEmpty()) {
                this.well.getCurves().deleteCurves(deleteFromDatabase);
            }
            if (!deleteFromWitsml.isEmpty()) {
                this.well.getWitsmlCurveHeaderService().deleteWitsmlCurveHeaders(deleteFromWitsml);
            }
            this.curveListUpdated();
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtowireline.html");
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        TableModelCurves.CurveTableRow curveTableRow = this.getSelectedCurve();
        if (curveTableRow == null) {
            JOptionPane.showMessageDialog(this, "Select one curve to edit", this.getTitle(), 1);
            return;
        }
        Curve curve = curveTableRow.getCurve();
        if (curve == null && curveTableRow instanceof WitsmlRow) {
            JOptionPane.showMessageDialog(this, "Cannot access this curve. Use WITSML dialog to edit parameters", this.getTitle(), 1);
            return;
        }
        Curve curveCopy = Curve.copyOf((Curve)curve, (int)curve.getID(), (AuditImpl)new AuditImpl(), (String)curve.getAbr());
        DialogCurve dialog = new DialogCurve(this, true, curveCopy, DepthUnits.getUnits((char)this.well.getWellUnits()), this.well.getSectionType());
        dialog.setLocationRelativeTo(this);
        try {
            if (!this.well.canWrite(this.well.getDataModel(), null)) {
                dialog.disableEditing(this.well.getDeniedReason(this.well.getDataModel(), "well", false));
            }
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showStackError(e, this);
            return;
        }
        dialog.setVisible(true);
        if (!dialog.isOK() || curveTableRow instanceof CurveRow && curveCopy.getSize() == curve.getSize() && StringUtils.equals((CharSequence)curve.getComments(), (CharSequence)curveCopy.getComments())) {
            return;
        }
        try {
            if (curveTableRow instanceof CurveRow) {
                this.well.updateCurve(curveCopy);
            } else if (curveTableRow instanceof WitsmlRow) {
                WitsmlRow witsmlRow = (WitsmlRow)curveTableRow;
                int opt = JOptionPane.showConfirmDialog(this, "Do you want to import this WITSML log into your database?", "Import Log", 0);
                if (opt != 0) {
                    return;
                }
                curveCopy = Curve.copyWithFilterValue((Curve)curveCopy);
                curveCopy.setFilename("Imported from " + witsmlRow.getSource());
                this.well.addCurve(curveCopy);
                this.well.getWitsmlCurveHeaderService().deleteWitsmlCurveHeaders(List.of(witsmlRow.header));
                this.well.getCurves().notifyListeners();
            }
        }
        catch (SQLException | SuppressedSQLException | SBPermissionException ex) {
            SbugsExceptionHandler.showStackError("Error updating wireline log", ex);
            return;
        }
        this.model.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        block29: {
            TableModelCurves.CurveTableRow row = this.getSelectedCurve();
            if (row == null) {
                JOptionPane.showMessageDialog(this, "Select one curve to save", this.getTitle(), 1);
                return;
            }
            Curve curve = row.getCurve();
            if (curve == null) {
                JOptionPane.showMessageDialog(this, "No curve to use", this.getTitle(), 2);
                return;
            }
            try {
                WellInterp wellInterp;
                SBdb db = this.well.getDataModel();
                this.well.loadInterps();
                Iterator<WellInterp> it = this.well.getInterpIterator();
                int nInterps = 0;
                while (it.hasNext()) {
                    ++nInterps;
                    it.next();
                }
                if (nInterps > 1) {
                    ArrayList<Well> l = new ArrayList<Well>();
                    l.add(this.well);
                    DialogSelectVersion dialog = new DialogSelectVersion((Dialog)this, true, db, l);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                    if (dialog.getSelection() == null || dialog.getSelection().isEmpty()) {
                        return;
                    }
                    wellInterp = this.well.getInterp(dialog.getSelection().get(0).getInterpID());
                } else {
                    wellInterp = this.well.getInterp(0);
                }
                if (wellInterp == null) {
                    JOptionPane.showMessageDialog(this, "There is no are no data for this version, for this well.", this.getTitle(), 1);
                    return;
                }
                wellInterp.loadLOC(this.well.getWellID());
                if (wellInterp.getLOC() == null || wellInterp.getLOC().getSize() < 2) {
                    JOptionPane.showMessageDialog(this, "There is no depth/age curve selected for version: " + wellInterp.toString() + ", for this well.", this.getTitle(), 1);
                    return;
                }
                boolean valueFound = false;
                for (Curve.CurveValue v : curve.getTrace()) {
                    double age = wellInterp.getLOC().getAge(v.depth(), false);
                    if (!(age > 0.0)) continue;
                    valueFound = true;
                    break;
                }
                if (!valueFound) {
                    JOptionPane.showMessageDialog(this, "The log curve depth values to not intersect the depth/age curve.", this.getTitle(), 1);
                    return;
                }
                File file = FileChooserUtils.chooseFileToWrite((SBdb)this.well.getDataModel(), (Component)this, (String)"LOGAGE", (String)"LOGAGE", (String[])new String[]{"txt", "csv"}, (String[])new String[]{"Text files", "Comma Separated Value files"}, (String)(SB.makeFileName((String)this.well.getWellCode()) + "_" + curve.getAbr()));
                if (file == null) break block29;
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    char delim = '\t';
                    Object fileName = file.getPath();
                    if (!((String)fileName).toLowerCase().endsWith(".txt")) {
                        if (((String)fileName).endsWith(".csv")) {
                            delim = ',';
                        } else {
                            fileName = (String)fileName + ".txt";
                        }
                    }
                    try (FileWriter out = new FileWriter((String)fileName);){
                        out.write("StrataBugs wireline curve on age scale\r\n");
                        out.write("Age" + delim + curve.getAbr() + delim + "Depth\r\n");
                        for (Curve.CurveValue v : curve.getTrace()) {
                            double age = wellInterp.getLOC().getAge(v.depth(), false);
                            if (!(age >= 0.0)) continue;
                            out.write(SB.floatString((double)age, (int)2) + delim + v.value() + delim + DepthUtils.convFromM((double)v.depth(), (DepthUnits)DepthUnits.getUnits((char)this.well.getWellUnits())) + "\r\n");
                        }
                        out.write("\r\n");
                    }
                    if (JOptionPane.showConfirmDialog(this, "File '" + (String)fileName + "' written", "File Saved", 2) == 0) {
                        try {
                            Lastval.putString(db, "LOGAGE", (String)fileName);
                            db.commit();
                        }
                        catch (SQLException sql) {
                            sql.printStackTrace();
                        }
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "Error writing file: " + ex.getMessage());
                    ex.printStackTrace();
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (RuntimeException | SQLException | SBException e) {
                SbugsExceptionHandler.showStackError(e, this);
            }
        }
    }

    private void jButtonWITSMLActionPerformed(ActionEvent evt) {
        if (!this.well.getDataModel().hasWITSML()) {
            JOptionPane.showMessageDialog(this, "This database is not enabled for WITSML.\nContact support for more information", this.getTitle(), 1);
            return;
        }
        try {
            DialogWitsmlImport dialog = new DialogWitsmlImport(this, true, this.well.getDataModel(), this.well);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.curveListUpdated();
            }
        }
        catch (RuntimeException | SQLException ex) {
            SbugsExceptionHandler.showDialogStackError(ex, this);
        }
    }

    private class TableModelCurves
    extends AbstractTableModel {
        static final int COL_ABR = 0;
        static final int COL_TYPE = 1;
        static final int COL_MNEM = 2;
        static final int COL_TOP = 3;
        static final int COL_BASE = 4;
        static final int COL_SOURCE = 5;
        static final int COL_COMMENT = 6;
        static final int COL_ACTIVE = 7;
        final /* synthetic */ DialogCurves this$0;

        private TableModelCurves(DialogCurves dialogCurves) {
            DialogCurves dialogCurves2 = dialogCurves;
            Objects.requireNonNull(dialogCurves2);
            this.this$0 = dialogCurves2;
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public int getRowCount() {
            return this.this$0.curveList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int col) {
            CurveTableRow row = this.this$0.curveList.get(rowIndex);
            return switch (col) {
                case 3 -> row.getTopDepth();
                case 4 -> row.getBaseDepth();
                case 0 -> row.getAbr();
                case 1 -> row.getType();
                case 2 -> row.getMnem();
                case 5 -> row.getSource();
                case 6 -> row.getComments();
                case 7 -> row.getCurve() != null && row.getCurve().isActive();
                default -> "";
            };
        }

        public Class getColumnClass(int c) {
            if (c == 7) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 7 && this.this$0.curveList.get(rowIndex).getCurve() != null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex != 7) {
                return;
            }
            this.this$0.curveList.get(rowIndex).setCurveActive((Boolean)aValue);
            this.fireTableDataChanged();
        }

        void setupTable(JTable jTable) {
            TableUtils.setTableHeaderBold((JTable)jTable);
            for (int i = 0; i < COL_TITLES.length; ++i) {
                jTable.getColumnModel().getColumn(i).setHeaderValue(COL_TITLES[i]);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(COL_WIDTHS[i]);
            }
            jTable.setDefaultRenderer(String.class, new CurveStatusRenderer(this));
        }

        static interface CurveTableRow {
            public String getTopDepth();

            public String getBaseDepth();

            public String getAbr();

            public String getType();

            public String getMnem();

            public String getSource();

            public String getComments();

            default public boolean isOK() {
                return true;
            }

            public Curve getCurve();

            public void setCurveActive(boolean var1);
        }

        class CurveStatusRenderer
        extends ColouredRenderer {
            private static final Color RED = new Color(255, 204, 204);
            final /* synthetic */ TableModelCurves this$1;

            public CurveStatusRenderer(TableModelCurves this$1) {
                TableModelCurves tableModelCurves = this$1;
                Objects.requireNonNull(tableModelCurves);
                this.this$1 = tableModelCurves;
                super(false, RED);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Color foregroundColour;
                Color backgroundColour;
                CurveTableRow curveRow = this.this$1.this$0.curveList.get(table.convertRowIndexToModel(row));
                if (!curveRow.isOK()) {
                    backgroundColour = RED;
                    foregroundColour = table.getForeground();
                } else {
                    backgroundColour = isSelected ? table.getSelectionBackground() : table.getBackground();
                    foregroundColour = isSelected ? table.getSelectionForeground() : table.getForeground();
                }
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                comp.setBackground(backgroundColour);
                comp.setForeground(foregroundColour);
                return comp;
            }
        }
    }

    private class CurveRow
    implements TableModelCurves.CurveTableRow {
        private final Curve curve;
        final /* synthetic */ DialogCurves this$0;

        public CurveRow(DialogCurves dialogCurves, Curve curve) {
            DialogCurves dialogCurves2 = dialogCurves;
            Objects.requireNonNull(dialogCurves2);
            this.this$0 = dialogCurves2;
            this.curve = curve;
        }

        @Override
        public String getTopDepth() {
            if (this.curve.getTopDepth() != null) {
                return DepthUtils.depthString((double)this.curve.getTopDepth(), (DepthUnits)DepthUnits.getUnits((char)this.this$0.well.getWellUnits()), (int)2, (SectionType)this.this$0.well.getSectionType());
            }
            return "";
        }

        @Override
        public String getBaseDepth() {
            if (this.curve.getBaseDepth() != null) {
                return DepthUtils.depthString((double)this.curve.getBaseDepth(), (DepthUnits)DepthUnits.getUnits((char)this.this$0.well.getWellUnits()), (int)2, (SectionType)this.this$0.well.getSectionType());
            }
            return "";
        }

        @Override
        public String getAbr() {
            return this.curve.getAbr();
        }

        @Override
        public String getType() {
            try {
                return this.this$0.well.getDataModel().getLogDef(this.curve.getAbr()).getTitle();
            }
            catch (Exception ex) {
                return ex.getMessage();
            }
        }

        @Override
        public String getMnem() {
            return this.curve.getMnem();
        }

        @Override
        public String getSource() {
            return Objects.requireNonNullElse(this.curve.getFilename(), "");
        }

        @Override
        public String getComments() {
            return Objects.requireNonNullElse(this.curve.getComments(), "");
        }

        @Override
        public Curve getCurve() {
            return this.curve;
        }

        @Override
        public void setCurveActive(boolean active) {
            try {
                this.this$0.well.getCurves().setCurveActive(this.curve.getID(), active);
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, "Unexpected error", e);
            }
        }
    }

    private class WitsmlRow
    implements TableModelCurves.CurveTableRow {
        final WitsmlCurveHeader header;
        Curve curve;
        final /* synthetic */ DialogCurves this$0;

        public WitsmlRow(DialogCurves dialogCurves, WitsmlCurveHeader header, Curve curve) {
            DialogCurves dialogCurves2 = dialogCurves;
            Objects.requireNonNull(dialogCurves2);
            this.this$0 = dialogCurves2;
            this.header = header;
            this.curve = curve;
        }

        @Override
        public String getTopDepth() {
            if (this.curve != null && this.curve.getTopDepth() != null) {
                return DepthUtils.depthString((double)this.curve.getTopDepth(), (DepthUnits)DepthUnits.getUnits((char)this.this$0.well.getWellUnits()), (int)2, (SectionType)this.this$0.well.getSectionType());
            }
            return "";
        }

        @Override
        public String getBaseDepth() {
            if (this.curve != null && this.curve.getBaseDepth() != null) {
                return DepthUtils.depthString((double)this.curve.getBaseDepth(), (DepthUnits)DepthUnits.getUnits((char)this.this$0.well.getWellUnits()), (int)2, (SectionType)this.this$0.well.getSectionType());
            }
            return "";
        }

        @Override
        public String getAbr() {
            return this.header.abr();
        }

        @Override
        public String getType() {
            try {
                return this.this$0.well.getDataModel().getLogDef(this.header.abr()).getTitle();
            }
            catch (Exception ex) {
                return ex.getMessage();
            }
        }

        @Override
        public String getMnem() {
            return this.header.mnemonic();
        }

        @Override
        public String getSource() {
            return "WITSML service '" + this.this$0.well.getDataModel().getWebServiceDescriptionService().getServiceDescription(this.header.serverID()).map(WebServiceDescription::name).orElse("") + "'";
        }

        @Override
        public String getComments() {
            if (this.curve != null) {
                return "";
            }
            if (this.this$0.well.getWitsmlCurveService().getServerException() != null) {
                return this.this$0.well.getWitsmlCurveService().getServerException().getMessage();
            }
            return "Error reading curves";
        }

        @Override
        public boolean isOK() {
            return this.curve != null;
        }

        @Override
        public Curve getCurve() {
            return this.curve;
        }

        @Override
        public void setCurveActive(boolean active) {
            if (this.curve != null) {
                this.this$0.well.getWitsmlCurveService().setCurveActive(this.curve.getID(), active);
            }
        }
    }
}

