/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import javax.activation.MimetypesFileTypeMap;
import javax.swing.TransferHandler;

public class FrameWellsListTransferHandler
extends TransferHandler {
    private final Consumer<File> fileImportFunction;
    private static final MimetypesFileTypeMap MIMETYPES_FILE_TYPE_MAP = new MimetypesFileTypeMap();

    public FrameWellsListTransferHandler(Consumer<File> fileImportFunction) {
        this.fileImportFunction = fileImportFunction;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        for (DataFlavor flavor : support.getDataFlavors()) {
            if (!flavor.isFlavorJavaFileListType()) continue;
            try {
                for (Object f : (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor)) {
                    if (!this.isLasFile((File)f)) continue;
                    return true;
                }
            }
            catch (InvalidDnDOperationException e) {
                return true;
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        List files;
        if (!this.canImport(support)) {
            return false;
        }
        try {
            files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            return false;
        }
        for (File file : files) {
            if (!this.isLasFile(file)) continue;
            this.fileImportFunction.accept(file);
            return true;
        }
        return false;
    }

    private boolean isLasFile(File file) {
        return MIMETYPES_FILE_TYPE_MAP.getContentType(file).equals("logfile");
    }

    static {
        MIMETYPES_FILE_TYPE_MAP.addMimeTypes("logfile LAS las");
    }
}

