/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.io.BufferedMarkedInputStream;
import org.icepdf.core.io.ConservativeSizingByteArrayOutputStream;
import org.icepdf.core.io.SeekableByteArrayInputStream;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.CrossReference;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.HexStringObject;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.ObjectStream;
import org.icepdf.core.pobjects.OptionalContentGroup;
import org.icepdf.core.pobjects.OptionalContentMembership;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.fonts.CMap;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.pobjects.fonts.FontDescriptor;
import org.icepdf.core.pobjects.fonts.FontFactory;
import org.icepdf.core.pobjects.graphics.TilingPattern;
import org.icepdf.core.util.Library;

public class Parser {
    private static final Logger logger = Logger.getLogger(Parser.class.toString());
    public static final int PARSE_MODE_NORMAL = 0;
    public static final int PARSE_MODE_OBJECT_STREAM = 1;
    private InputStream reader;
    boolean lastTokenHString = false;
    private Stack<Object> stack = new Stack();
    private int parseMode;
    private boolean isTrailer;
    private int linearTraversalOffset;

    public Parser(SeekableInput r) {
        this(r, 0);
    }

    public Parser(SeekableInput r, int pm) {
        this.reader = r.getInputStream();
        this.parseMode = pm;
    }

    public Parser(InputStream r) {
        this(r, 0);
    }

    public Parser(InputStream r, int pm) {
        this.reader = new BufferedMarkedInputStream(r);
        this.parseMode = pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object getObject(Library library) throws PDFException {
        deepnessCount = 0;
        inObject = false;
        complete = false;
        objectReference = null;
        try {
            this.reader.mark(1);
            if (library.isLinearTraversal() && this.reader instanceof BufferedMarkedInputStream) {
                this.linearTraversalOffset = ((BufferedMarkedInputStream)this.reader).getMarkedPosition();
            }
            do {
                block107: {
                    block110: {
                        block109: {
                            block108: {
                                block106: {
                                    try {
                                        nextToken = this.getToken();
                                    }
                                    catch (IOException e) {
                                        return null;
                                    }
                                    if (!(nextToken instanceof StringObject) && !(nextToken instanceof Name) && !(nextToken instanceof Number)) break block106;
                                    if (nextToken instanceof StringObject) {
                                        tmp = (StringObject)nextToken;
                                        tmp.setReference(objectReference);
                                    }
                                    this.stack.push(nextToken);
                                    break block107;
                                }
                                if (!nextToken.equals("obj")) break block108;
                                if (inObject) {
                                    this.stack.pop();
                                    this.stack.pop();
                                    return this.addPObject(library, objectReference);
                                }
                                deepnessCount = 0;
                                inObject = true;
                                generationNumber = (Number)this.stack.pop();
                                objectNumber = (Number)this.stack.pop();
                                objectReference = new Reference(objectNumber, generationNumber);
                                break block107;
                            }
                            if (!nextToken.equals("endobj") && !nextToken.equals("endobject") && !nextToken.equals("enbobj")) break block109;
                            if (inObject) {
                                inObject = false;
                                return this.addPObject(library, objectReference);
                            }
                            break block107;
                        }
                        if (!nextToken.equals("endstream")) break block110;
                        --deepnessCount;
                        if (inObject) {
                            inObject = false;
                            return this.addPObject(library, objectReference);
                        }
                        break block107;
                    }
                    if (!nextToken.equals("stream")) ** GOTO lbl150
                    ++deepnessCount;
                    tmp = this.stack.pop();
                    streamHash = tmp instanceof Dictionary != false ? ((Dictionary)tmp).getEntries() : (HashMap<Object, Object>)tmp;
                    streamLength = library.getInt(streamHash, Dictionary.LENGTH_KEY);
                    try {
                        this.reader.mark(2);
                        curChar = this.reader.read();
                        if (curChar == 13) {
                            this.reader.mark(1);
                            if (this.reader.read() != 10) {
                                this.reader.reset();
                            }
                        } else if (curChar != 10) {
                            this.reader.reset();
                        }
                        if (this.reader instanceof SeekableInput) {
                            streamDataInput = (SeekableInput)this.reader;
                            filePositionOfStreamData = streamDataInput.getAbsolutePosition();
                            if (streamLength > 0) {
                                lengthOfStreamData = streamLength;
                                streamDataInput.seekRelative(streamLength);
                                lengthOfStreamData += this.skipUntilEndstream(null);
                            } else {
                                lengthOfStreamData = this.captureStreamData(null);
                            }
                            streamInputWrapper = new SeekableInputConstrainedWrapper(streamDataInput, filePositionOfStreamData, lengthOfStreamData);
                        } else {
                            if (!library.isLinearTraversal() && streamLength > 0) {
                                buffer = new byte[streamLength];
                                for (totalRead = 0; totalRead < buffer.length && (currRead = this.reader.read(buffer, totalRead, buffer.length - totalRead)) > 0; totalRead += currRead) {
                                }
                                out = new ConservativeSizingByteArrayOutputStream(buffer);
                                this.skipUntilEndstream(out);
                            } else {
                                out = new ConservativeSizingByteArrayOutputStream(16384);
                                this.captureStreamData(out);
                            }
                            size = out.size();
                            out.trim();
                            buffer = out.relinquishByteArray();
                            streamDataInput = new SeekableByteArrayInputStream(buffer);
                            filePositionOfStreamData = 0L;
                            streamInputWrapper = new SeekableInputConstrainedWrapper(streamDataInput, filePositionOfStreamData, size);
                        }
                    }
                    catch (IOException e) {
                        if (Parser.logger.isLoggable(Level.FINE)) {
                            Parser.logger.log(Level.FINE, "Error getting next object", e);
                        }
                        return null;
                    }
                    trailer = null;
                    stream = null;
                    type = (Name)library.getObject(streamHash, Dictionary.TYPE_KEY);
                    subtype = (Name)library.getObject(streamHash, Dictionary.SUBTYPE_KEY);
                    if (type != null) {
                        if (type.equals("XRef")) {
                            stream = new Stream(library, streamHash, streamInputWrapper);
                            stream.init();
                            in = stream.getDecodedByteArrayInputStream();
                            xrefStream = new CrossReference();
                            if (in != null) {
                                try {
                                    xrefStream.addXRefStreamEntries(library, streamHash, in);
                                }
                                finally {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable e) {
                                        Parser.logger.log(Level.WARNING, "Error appending stream entries.", e);
                                    }
                                }
                            }
                            trailerHash = (HashMap)streamHash.clone();
                            trailer = new PTrailer(library, trailerHash, null, xrefStream);
                        } else if (type.equals("ObjStm")) {
                            stream = new ObjectStream(library, streamHash, streamInputWrapper);
                        } else if (type.equals("XObject") && subtype.equals("Image")) {
                            stream = new ImageStream(library, streamHash, streamInputWrapper);
                        } else if (type.equals("Pattern")) {
                            stream = new TilingPattern(library, streamHash, streamInputWrapper);
                        }
                    }
                    if (stream == null && subtype != null) {
                        if (subtype.equals("Image")) {
                            stream = new ImageStream(library, streamHash, streamInputWrapper);
                        } else if (subtype.equals("Form") && !"Pattern".equals(type)) {
                            stream = new Form(library, streamHash, streamInputWrapper);
                        } else if (subtype.equals("Form") && "Pattern".equals(type)) {
                            stream = new TilingPattern(library, streamHash, streamInputWrapper);
                        }
                    }
                    if (trailer != null) {
                        this.stack.push(trailer);
                    } else {
                        if (stream == null) {
                            stream = new Stream(library, streamHash, streamInputWrapper);
                        }
                        this.stack.push(stream);
                        return this.addPObject(library, objectReference);
lbl150:
                        // 1 sources

                        if (nextToken.equals("true")) {
                            this.stack.push(true);
                        } else if (nextToken.equals("false")) {
                            this.stack.push(false);
                        } else if (nextToken.equals("R")) {
                            generationNumber = (Number)this.stack.pop();
                            objectNumber = (Number)this.stack.pop();
                            this.stack.push(new Reference(objectNumber, generationNumber));
                        } else if (nextToken.equals("[")) {
                            ++deepnessCount;
                            this.stack.push(nextToken);
                        } else if (nextToken.equals("]")) {
                            --deepnessCount;
                            searchPosition = this.stack.search("[");
                            size = searchPosition - 1;
                            if (size < 0) {
                                Parser.logger.warning("Negative array size, a  malformed content stream has likely been encountered.");
                                size = 0;
                            }
                            v = new ArrayList<Object>(size);
                            tmp = new Object[size];
                            if (searchPosition > 0) {
                                for (i = size - 1; i >= 0; --i) {
                                    tmp[i] = this.stack.pop();
                                }
                                for (i = 0; i < size; ++i) {
                                    v.add(tmp[i]);
                                }
                                this.stack.pop();
                            } else {
                                this.stack.clear();
                            }
                            this.stack.push(v);
                        } else if (nextToken.equals("<<")) {
                            ++deepnessCount;
                            this.stack.push(nextToken);
                        } else if (nextToken.equals(">>")) {
                            if (!this.isTrailer && --deepnessCount >= 0) {
                                if (!this.stack.isEmpty()) {
                                    hashMap = new HashMap<Object, Object>();
                                    obj = this.stack.pop();
                                    while (!(obj instanceof String && obj.equals("<<") || this.stack.isEmpty())) {
                                        key = this.stack.pop();
                                        hashMap.put(key, obj);
                                        if (this.stack.isEmpty()) break;
                                        obj = this.stack.pop();
                                    }
                                    if ((obj = hashMap.get(Dictionary.TYPE_KEY)) == null) {
                                        obj = hashMap.get(new Name("type"));
                                    }
                                    if (obj != null && obj instanceof Name) {
                                        n = (Name)obj;
                                        if (n.equals(Catalog.TYPE)) {
                                            this.stack.push(new Catalog(library, hashMap));
                                        } else if (n.equals(PageTree.TYPE)) {
                                            this.stack.push(new PageTree(library, hashMap));
                                        } else if (n.equals(Page.TYPE)) {
                                            this.stack.push(new Page(library, hashMap));
                                        } else if (n.equals(Font.TYPE)) {
                                            v0 = fontDescriptor = hashMap.get(FontDescriptor.FONT_FILE) != null || hashMap.get(FontDescriptor.FONT_FILE_2) != null || hashMap.get(FontDescriptor.FONT_FILE_3) != null;
                                            if (!fontDescriptor) {
                                                this.stack.push(FontFactory.getInstance().getFont(library, hashMap));
                                            } else {
                                                this.stack.push(new FontDescriptor(library, hashMap));
                                            }
                                        } else if (n.equals(FontDescriptor.TYPE)) {
                                            this.stack.push(new FontDescriptor(library, hashMap));
                                        } else if (n.equals(CMap.TYPE)) {
                                            this.stack.push(hashMap);
                                        } else if (n.equals(Annotation.TYPE)) {
                                            this.stack.push(Annotation.buildAnnotation(library, hashMap));
                                        } else if (n.equals(OptionalContentGroup.TYPE)) {
                                            this.stack.push(new OptionalContentGroup(library, hashMap));
                                        } else if (n.equals(OptionalContentMembership.TYPE)) {
                                            this.stack.push(new OptionalContentMembership(library, hashMap));
                                        } else {
                                            this.stack.push(hashMap);
                                        }
                                    } else {
                                        this.stack.push(hashMap);
                                    }
                                }
                            } else if (this.isTrailer && deepnessCount == 0) {
                                hashMap = new HashMap<Object, Object>();
                                obj = this.stack.pop();
                                while (!(obj instanceof String && obj.equals("<<") || this.stack.isEmpty())) {
                                    key = this.stack.pop();
                                    hashMap.put(key, obj);
                                    if (this.stack.isEmpty()) break;
                                    obj = this.stack.pop();
                                }
                                return hashMap;
                            }
                        } else if (nextToken.equals("xref")) {
                            xrefTable = new CrossReference();
                            xrefTable.addXRefTableEntries(this);
                            this.stack.push(xrefTable);
                        } else {
                            if (nextToken.equals("trailer")) {
                                xrefTable = null;
                                if (this.stack.peek() instanceof CrossReference) {
                                    xrefTable = (CrossReference)this.stack.pop();
                                }
                                this.stack.clear();
                                this.isTrailer = true;
                                trailerDictionary = (HashMap)this.getObject(library);
                                this.isTrailer = false;
                                return new PTrailer(library, trailerDictionary, xrefTable, null);
                            }
                            if (!(nextToken instanceof String) || !((String)nextToken).startsWith("%")) {
                                if (nextToken instanceof String && ((String)nextToken).startsWith("endobj")) {
                                    if (inObject) {
                                        inObject = false;
                                        return this.addPObject(library, objectReference);
                                    }
                                } else {
                                    this.stack.push(nextToken);
                                }
                            }
                        }
                    }
                }
                if (this.parseMode != 1 || deepnessCount != 0 || this.stack.size() <= 0) continue;
                return this.stack.pop();
            } while (!complete);
        }
        catch (Exception e) {
            Parser.logger.log(Level.WARNING, "Fatal error parsing PDF file stream.", e);
            return null;
        }
        return this.stack.pop();
    }

    public String peek2() throws IOException {
        this.reader.mark(2);
        char[] c = new char[]{(char)this.reader.read(), (char)this.reader.read()};
        String s = new String(c);
        this.reader.reset();
        return s;
    }

    public boolean readLineForInlineImage(OutputStream out) throws IOException {
        int c;
        boolean STATE_PRE_E = false;
        boolean STATE_PRE_I = true;
        int STATE_PRE_WHITESPACE = 2;
        int state = 0;
        while ((c = this.reader.read()) >= 0) {
            if (state == 0 && c == 69) {
                ++state;
                continue;
            }
            if (state == 1 && c == 73) {
                ++state;
                continue;
            }
            if (state == 2 && Parser.isWhitespace((char)(0xFF & c))) {
                boolean imageDataFound = Parser.isStillInlineImageData(this.reader, 32);
                if (imageDataFound) {
                    out.write(69);
                    out.write(73);
                    out.write(c);
                    state = 0;
                    if (c != 13 && c != 10) continue;
                    break;
                }
                return true;
            }
            if (state > 0) {
                out.write(69);
            }
            if (state > 1) {
                out.write(73);
            }
            state = 0;
            out.write((byte)c);
            if (c != 13 && c != 10) continue;
            break;
        }
        return state == 2;
    }

    private static boolean isStillInlineImageData(InputStream reader, int numBytesToCheck) throws IOException {
        boolean imageDataFound = false;
        boolean onlyWhitespaceSoFar = true;
        reader.mark(numBytesToCheck);
        byte[] toCheck = new byte[numBytesToCheck];
        int numReadToCheck = reader.read(toCheck);
        for (int i = 0; i < numReadToCheck; ++i) {
            boolean typicalTextTokenInContentStream;
            char charToCheck = (char)(toCheck[i] & 0xFF);
            boolean bl = typicalTextTokenInContentStream = charToCheck == 'Q' || charToCheck == 'q' || charToCheck == 'S' || charToCheck == 's';
            if (onlyWhitespaceSoFar && typicalTextTokenInContentStream && i + 1 < numReadToCheck && Parser.isWhitespace((char)(toCheck[i + 1] & 0xFF))) break;
            if (!Parser.isWhitespace(charToCheck)) {
                onlyWhitespaceSoFar = false;
            }
            if (Parser.isExpectedInContentStream(charToCheck)) continue;
            imageDataFound = true;
            break;
        }
        reader.reset();
        return imageDataFound;
    }

    private static boolean isExpectedInContentStream(char c) {
        return c >= 'a' && c <= 'Z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Parser.isWhitespace(c) || Parser.isDelimiter(c) || c == '\\' || c == '\'' || c == '\"' || c == '*' || c == '.';
    }

    public PObject addPObject(Library library, Reference objectReference) {
        Object o = this.stack.pop();
        if (o instanceof Stream) {
            Stream tmp = (Stream)o;
            tmp.setPObjectReference(objectReference);
        } else if (o instanceof Dictionary) {
            Dictionary tmp = (Dictionary)o;
            tmp.setPObjectReference(objectReference);
        }
        library.addObject(o, objectReference);
        return new PObject(o, objectReference);
    }

    public Object getStreamObject() throws IOException {
        Cloneable o = this.getToken();
        if (o instanceof String) {
            if (((Object)o).equals("<<")) {
                HashMap<Object, Object> h = new HashMap<Object, Object>();
                Object o1 = this.getStreamObject();
                while (!o1.equals(">>")) {
                    h.put(o1, this.getStreamObject());
                    o1 = this.getStreamObject();
                }
                o = h;
            } else if (((Object)o).equals("[")) {
                ArrayList<Object> v = new ArrayList<Object>();
                Object o1 = this.getStreamObject();
                while (!o1.equals("]")) {
                    v.add(o1);
                    o1 = this.getStreamObject();
                }
                o = v;
            }
        }
        return o;
    }

    public Object getToken() throws IOException {
        int currentByte;
        char currentChar;
        boolean inString = false;
        boolean hexString = false;
        boolean inNumber = false;
        this.lastTokenHString = false;
        do {
            if ((currentByte = this.reader.read()) >= 0) continue;
            throw new IOException();
        } while (Parser.isWhitespace(currentChar = (char)currentByte));
        if (currentChar == '(') {
            inString = true;
        } else {
            if (currentChar == ']') {
                return "]";
            }
            if (currentChar == '[') {
                return "[";
            }
            if (currentChar == '%') {
                StringBuilder stringBuffer = new StringBuilder();
                do {
                    stringBuffer.append(currentChar);
                    currentByte = this.reader.read();
                    if (currentByte >= 0) continue;
                    if (stringBuffer.length() > 0) {
                        return stringBuffer.toString();
                    }
                    throw new IOException();
                } while ((currentChar = (char)currentByte) != '\r' && currentChar != '\n');
                return stringBuffer.toString();
            }
            if (currentChar >= '0' && currentChar <= '9' || currentChar == '-' || currentChar == '+' || currentChar == '.') {
                inNumber = true;
            }
        }
        this.reader.mark(1);
        char nextChar = (char)this.reader.read();
        if (currentChar == '>' && nextChar == '>') {
            return ">>";
        }
        if (currentChar == '<') {
            if (nextChar == '<') {
                return "<<";
            }
            inString = true;
            hexString = true;
        }
        this.reader.reset();
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(currentChar);
        int parenthesisCount = 0;
        boolean complete = false;
        boolean ignoreChar = false;
        do {
            block32: {
                block30: {
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        block34: {
                                            block33: {
                                                block31: {
                                                    if (!inString) {
                                                        this.reader.mark(1);
                                                    }
                                                    if ((currentByte = this.reader.read()) < 0) break;
                                                    currentChar = (char)currentByte;
                                                    if (!inString) break block30;
                                                    if (!hexString) break block31;
                                                    if (currentChar == '>') {
                                                        stringBuffer.append(currentChar);
                                                        break;
                                                    }
                                                    break block32;
                                                }
                                                if (currentChar == '(') {
                                                    ++parenthesisCount;
                                                }
                                                if (currentChar == ')') {
                                                    if (parenthesisCount == 0) {
                                                        stringBuffer.append(currentChar);
                                                        break;
                                                    }
                                                    --parenthesisCount;
                                                }
                                                if (currentChar != '\\') break block32;
                                                currentChar = (char)this.reader.read();
                                                if (!Character.isDigit(currentChar)) break block33;
                                                StringBuilder digit = new StringBuilder();
                                                digit.append(currentChar);
                                                for (int i = 0; i < 2; ++i) {
                                                    this.reader.mark(1);
                                                    currentChar = (char)this.reader.read();
                                                    if (!Character.isDigit(currentChar)) {
                                                        this.reader.reset();
                                                        break;
                                                    }
                                                    digit.append(currentChar);
                                                }
                                                int charNumber = 0;
                                                try {
                                                    charNumber = Integer.parseInt(digit.toString(), 8);
                                                }
                                                catch (NumberFormatException e) {
                                                    logger.log(Level.FINE, "Integer parse error ", e);
                                                }
                                                currentChar = (char)charNumber;
                                                break block32;
                                            }
                                            if (currentChar == '(' || currentChar == ')' || currentChar == '\\') break block32;
                                            if (currentChar != 't') break block34;
                                            currentChar = '\t';
                                            break block32;
                                        }
                                        if (currentChar != 114) break block35;
                                        currentChar = '\r';
                                        break block32;
                                    }
                                    if (currentChar != 110) break block36;
                                    currentChar = '\n';
                                    break block32;
                                }
                                if (currentChar != 98) break block37;
                                currentChar = '\b';
                                break block32;
                            }
                            if (currentChar != 102) break block38;
                            currentChar = '\f';
                            break block32;
                        }
                        if (currentChar != 13) break block39;
                        ignoreChar = true;
                        break block32;
                    }
                    if (!logger.isLoggable(Level.FINE)) break block32;
                    logger.warning("C=" + currentChar);
                    break block32;
                }
                if (Parser.isWhitespace(currentChar)) {
                    if (currentByte != 13 && currentByte != 10) break;
                    this.reader.reset();
                    break;
                }
                if (Parser.isDelimiter(currentChar)) {
                    this.reader.reset();
                    break;
                }
            }
            if (!ignoreChar) {
                if (inString) {
                    stringBuffer.append(currentChar);
                    continue;
                }
                if (currentChar >= '\u0080') continue;
                stringBuffer.append(currentChar);
                continue;
            }
            ignoreChar = false;
        } while (!complete);
        if (hexString) {
            this.lastTokenHString = true;
            return new HexStringObject(stringBuffer);
        }
        if (inString) {
            return new LiteralStringObject(stringBuffer);
        }
        if (stringBuffer.charAt(0) == '/') {
            return new Name(stringBuffer.deleteCharAt(0));
        }
        if (inNumber) {
            return this.getNumber(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public Object getNumberOrStringWithMark(int maxLength) throws IOException {
        int curr;
        this.reader.mark(maxLength);
        StringBuilder sb = new StringBuilder(maxLength);
        boolean readNonWhitespaceYet = false;
        boolean foundDigit = false;
        boolean foundDecimal = false;
        for (int i = 0; i < maxLength && (curr = this.reader.read()) >= 0; ++i) {
            char currChar = (char)curr;
            if (Parser.isWhitespace(currChar)) {
                if (!readNonWhitespaceYet) continue;
                break;
            }
            if (Parser.isDelimiter(currChar)) {
                this.reader.reset();
                this.reader.mark(maxLength);
                for (int j = 0; j < i; ++j) {
                    this.reader.read();
                }
                readNonWhitespaceYet = true;
                break;
            }
            readNonWhitespaceYet = true;
            if (currChar == '.') {
                foundDecimal = true;
            } else if (currChar >= '0' && curr <= 57) {
                foundDigit = true;
            }
            sb.append(currChar);
        }
        if (foundDigit) {
            return this.getNumber(sb);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public void ungetNumberOrStringWithReset() throws IOException {
        this.reader.reset();
    }

    public int getIntSurroundedByWhitespace() {
        int num = 0;
        boolean makeNegative = false;
        boolean readNonWhitespace = false;
        try {
            int curr;
            while ((curr = this.reader.read()) >= 0) {
                if (Character.isWhitespace((char)curr)) {
                    if (!readNonWhitespace) continue;
                } else {
                    if (curr == 45) {
                        makeNegative = true;
                        readNonWhitespace = true;
                        continue;
                    }
                    if (curr >= 48 && curr <= 57) {
                        num *= 10;
                        num += curr - 48;
                        readNonWhitespace = true;
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error detecting int.", e);
        }
        if (makeNegative) {
            num *= -1;
        }
        return num;
    }

    public Number getNumber(StringBuilder value) {
        int startTokenPos;
        int digit = 0;
        float decimal = 0.0f;
        float divisor = 10.0f;
        boolean isDecimal = false;
        byte[] streamBytes = value.toString().getBytes();
        boolean singed = streamBytes[startTokenPos = 0] == 45;
        boolean positive = streamBytes[startTokenPos] == 43;
        int n = startTokenPos = singed || positive ? startTokenPos + 1 : startTokenPos;
        if (singed && streamBytes[startTokenPos] == 45) {
            ++startTokenPos;
        }
        int max = streamBytes.length;
        for (int i = startTokenPos; i < max; ++i) {
            boolean isDigit;
            int current = streamBytes[i] - 48;
            boolean bl = isDigit = streamBytes[i] >= 48 && streamBytes[i] <= 57;
            if (!isDecimal && isDigit) {
                digit = digit * 10 + current;
                continue;
            }
            if (isDecimal && isDigit) {
                decimal += (float)current / divisor;
                divisor *= 10.0f;
                continue;
            }
            if (streamBytes[i] != 46) break;
            isDecimal = true;
        }
        if (singed) {
            if (isDecimal) {
                return Float.valueOf(-((float)digit + decimal));
            }
            return -digit;
        }
        if (isDecimal) {
            return Float.valueOf((float)digit + decimal);
        }
        return digit;
    }

    public long getLongSurroundedByWhitespace() {
        long num = 0L;
        boolean makeNegative = false;
        boolean readNonWhitespace = false;
        try {
            int curr;
            while ((curr = this.reader.read()) >= 0) {
                if (Character.isWhitespace((char)curr)) {
                    if (!readNonWhitespace) continue;
                } else {
                    if (curr == 45) {
                        makeNegative = true;
                        readNonWhitespace = true;
                        continue;
                    }
                    if (curr >= 48 && curr <= 57) {
                        num *= 10L;
                        num += (long)(curr - 48);
                        readNonWhitespace = true;
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            logger.log(Level.FINER, "Error detecting long.", e);
        }
        if (makeNegative) {
            num *= -1L;
        }
        return num;
    }

    public int getLinearTraversalOffset() {
        return this.linearTraversalOffset;
    }

    public char getCharSurroundedByWhitespace() {
        char alpha = '\u0000';
        try {
            int curr;
            while ((curr = this.reader.read()) >= 0) {
                char c = (char)curr;
                if (Character.isWhitespace(c)) continue;
                alpha = c;
                break;
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error detecting char.", e);
        }
        return alpha;
    }

    public static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f' || c == '\u0000';
    }

    private static boolean isDelimiter(char c) {
        return c == '[' || c == ']' || c == '(' || c == ')' || c == '<' || c == '>' || c == '{' || c == '}' || c == '/' || c == '%';
    }

    private long captureStreamData(OutputStream out) throws IOException {
        long numBytes = 0L;
        while (true) {
            int nextByte;
            if ((nextByte = this.reader.read()) == 101) {
                this.reader.mark(10);
                if (this.reader.read() == 110 && this.reader.read() == 100 && this.reader.read() == 115 && this.reader.read() == 116 && this.reader.read() == 114 && this.reader.read() == 101 && this.reader.read() == 97 && this.reader.read() == 109) break;
                this.reader.reset();
            } else if (nextByte < 0) break;
            if (out != null) {
                out.write(nextByte);
            }
            ++numBytes;
        }
        return numBytes;
    }

    private long skipUntilEndstream(OutputStream out) throws IOException {
        long skipped = 0L;
        while (true) {
            this.reader.mark(10);
            int nextByte = this.reader.read();
            if (nextByte == 101 && this.reader.read() == 110 && this.reader.read() == 100 && this.reader.read() == 115 && this.reader.read() == 116 && this.reader.read() == 114 && this.reader.read() == 101 && this.reader.read() == 97 && this.reader.read() == 109) {
                this.reader.reset();
                break;
            }
            if (nextByte < 0) break;
            if (nextByte == 10 || nextByte == 13 || nextByte == 32) continue;
            if (out != null) {
                out.write(nextByte);
            }
            ++skipped;
        }
        return skipped;
    }

    private float parseNumber(StringBuilder stringBuilder) {
        float digit = 0.0f;
        float divisor = 10.0f;
        boolean isDecimal = false;
        int startTokenPos = 0;
        int length = stringBuilder.length();
        char[] streamBytes = new char[length];
        stringBuilder.getChars(0, length, streamBytes, 0);
        boolean singed = streamBytes[startTokenPos] == '-';
        for (int i = startTokenPos = singed ? startTokenPos + 1 : startTokenPos; i < length; ++i) {
            boolean isDigit;
            int current = streamBytes[i] - 48;
            boolean bl = isDigit = streamBytes[i] >= '0' && streamBytes[i] <= '9';
            if (!isDecimal && isDigit) {
                digit = digit * 10.0f + (float)current;
                continue;
            }
            if (isDecimal && isDigit) {
                digit += (float)current / divisor;
                divisor *= 10.0f;
                continue;
            }
            if (streamBytes[i] != '.') break;
            isDecimal = true;
        }
        if (singed) {
            return -digit;
        }
        return digit;
    }
}

