/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sbconnect;

import org.apache.commons.lang3.StringUtils;

public class ICConnection {
    String server;
    String database;
    String user;
    String password;

    public ICConnection(String server, String database, String user, String password) {
        this.server = server;
        this.database = database;
        this.user = user;
        this.password = password;
    }

    public ICConnection(String dbString) {
        String[] parms = dbString.split("\\|");
        this.server = parms[0];
        if (parms.length > 1) {
            this.database = parms[1];
        }
        if (parms.length > 2) {
            this.user = parms[2];
        }
        if (parms.length > 3) {
            this.password = parms[3];
        }
    }

    public String getConnectionString() {
        String s = "jdbc:sqlserver://" + this.server + ";databaseName=" + this.database + ";";
        if (!StringUtils.isEmpty((CharSequence)this.user)) {
            s = s + "user=" + this.user + ";";
        }
        if (!StringUtils.isEmpty((CharSequence)this.password)) {
            s = s + "password=" + this.password + ";";
        }
        return s;
    }

    public String encodeParams() {
        String s = this.server + "|" + this.database + "|";
        if (!StringUtils.isEmpty((CharSequence)this.user)) {
            s = s + this.user + "|";
        }
        if (!StringUtils.isEmpty((CharSequence)this.password)) {
            s = s + this.password + "|";
        }
        return s;
    }

    public String getServer() {
        return this.server;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }
}

